/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.nativequery.impl;

import org.hibernate.ogm.datastore.mongodb.query.impl.MongoDBQueryDescriptor;
import org.hibernate.ogm.datastore.mongodb.query.parsing.nativequery.impl.MongoDBQueryDescriptorBuilder;
import org.parboiled.BaseParser;
import org.parboiled.Rule;
import org.parboiled.annotations.BuildParseTree;
import org.parboiled.annotations.SuppressNode;
import org.parboiled.annotations.SuppressSubnodes;

@BuildParseTree
public class NativeQueryParser
extends BaseParser<MongoDBQueryDescriptorBuilder> {
    final MongoDBQueryDescriptorBuilder builder = new MongoDBQueryDescriptorBuilder();

    public Rule Query() {
        return this.Sequence(this.FirstOf(this.ParsedQuery(), this.CriteriaOnlyFindQuery(), new Object[0]), EOI, new Object[]{this.push(this.builder)});
    }

    public Rule ParsedQuery() {
        return this.Sequence(this.Db(), this.Collection(), new Object[]{this.Operation()});
    }

    public Rule CriteriaOnlyFindQuery() {
        return this.Sequence(this.ZeroOrMore(ANY), this.builder.setOperation(MongoDBQueryDescriptor.Operation.FIND), new Object[]{this.builder.setCriteria(this.match())});
    }

    @SuppressNode
    public Rule Db() {
        return this.Sequence(this.ZeroOrMore(this.WhiteSpace()), "db ", new Object[]{this.Separator()});
    }

    @SuppressSubnodes
    public Rule Collection() {
        return this.Sequence(this.OneOrMore(this.TestNot(this.Reserved()), ANY, new Object[0]), this.builder.setCollection(this.match()), new Object[0]);
    }

    @SuppressNode
    public Rule Separator() {
        return this.Sequence(this.ZeroOrMore(this.WhiteSpace()), ". ", new Object[0]);
    }

    public Rule Reserved() {
        return this.FirstOf(this.Find(), this.FindOne(), new Object[]{this.FindAndModify(), this.Insert(), this.Remove(), this.Update(), this.Count()});
    }

    public Rule Operation() {
        return this.FirstOf(this.Sequence(this.Find(), this.builder.setOperation(MongoDBQueryDescriptor.Operation.FIND), new Object[0]), this.Sequence(this.FindOne(), this.builder.setOperation(MongoDBQueryDescriptor.Operation.FINDONE), new Object[0]), new Object[]{this.Sequence(this.FindAndModify(), this.builder.setOperation(MongoDBQueryDescriptor.Operation.FINDANDMODIFY), new Object[0]), this.Sequence(this.Insert(), this.builder.setOperation(MongoDBQueryDescriptor.Operation.INSERT), new Object[0]), this.Sequence(this.Remove(), this.builder.setOperation(MongoDBQueryDescriptor.Operation.REMOVE), new Object[0]), this.Sequence(this.Update(), this.builder.setOperation(MongoDBQueryDescriptor.Operation.UPDATE), new Object[0]), this.Sequence(this.Count(), this.builder.setOperation(MongoDBQueryDescriptor.Operation.COUNT), new Object[0])});
    }

    public Rule Find() {
        return this.Sequence(this.Separator(), "find ", new Object[]{"( ", this.JsonObject(), this.builder.setCriteria(this.match()), this.Optional(this.Sequence(", ", this.JsonObject(), new Object[]{this.builder.setProjection(this.match())})), ") "});
    }

    public Rule FindOne() {
        return this.Sequence(this.Separator(), "findOne ", new Object[]{"( ", this.Optional(this.JsonObject(), this.builder.setCriteria(this.match()), new Object[0]), this.Optional(this.Sequence(", ", this.JsonObject(), new Object[]{this.builder.setProjection(this.match())})), ") "});
    }

    public Rule FindAndModify() {
        return this.Sequence(this.Separator(), "findAndModify ", new Object[]{"( ", this.JsonObject(), this.builder.setCriteria(this.match()), ") "});
    }

    public Rule Insert() {
        return this.Sequence(this.Separator(), "insert ", new Object[]{"( ", this.JsonComposite(), this.builder.setUpdateOrInsert(this.match()), this.Optional(this.Sequence(", ", this.JsonObject(), new Object[]{this.builder.setOptions(this.match())})), ") "});
    }

    public Rule Remove() {
        return this.Sequence(this.Separator(), "remove ", new Object[]{"( ", this.JsonObject(), this.builder.setCriteria(this.match()), this.Optional(this.Sequence(", ", this.FirstOf(this.Sequence(this.BooleanValue(), this.builder.setOptions("{ 'justOne': " + this.match() + " }"), new Object[0]), this.Sequence(this.JsonObject(), this.builder.setOptions(this.match()), new Object[0]), new Object[0]), new Object[0])), ") "});
    }

    public Rule Update() {
        return this.Sequence(this.Separator(), "update ", new Object[]{"( ", this.JsonObject(), this.builder.setCriteria(this.match()), ", ", this.JsonObject(), this.builder.setUpdateOrInsert(this.match()), this.Optional(this.Sequence(", ", this.JsonObject(), new Object[]{this.builder.setOptions(this.match())})), ") "});
    }

    public Rule Count() {
        return this.Sequence(this.Separator(), "count ", new Object[]{"( ", this.Optional(this.Sequence(this.JsonComposite(), this.builder.setCriteria(this.match()), new Object[0])), ") "});
    }

    public Rule JsonComposite() {
        return this.FirstOf(this.JsonObject(), this.JsonArray(), new Object[0]);
    }

    public Rule JsonObject() {
        return this.Sequence(this.ZeroOrMore(this.WhiteSpace()).skipNode(), "{ ", new Object[]{this.FirstOf(this.Sequence(this.Pair(), this.ZeroOrMore(this.Sequence(", ", this.Pair(), new Object[0])), new Object[0]), this.Optional(this.Pair()), new Object[0]).suppressNode(), "} "});
    }

    public Rule Pair() {
        return this.Sequence(this.JsonString(), ": ", new Object[]{this.Value()});
    }

    public Rule Value() {
        return this.FirstOf(this.PrimitiveValue(), this.JsonComposite(), new Object[]{this.BsonFunctionCall()});
    }

    public Rule PrimitiveValue() {
        return this.FirstOf(this.JsonString(), this.JsonNumber(), new Object[]{"true ", "false ", "null ", "Infinity ", "NaN ", "undefined "});
    }

    public Rule BooleanValue() {
        return this.FirstOf("true", "false", new Object[0]);
    }

    @SuppressNode
    public Rule JsonNumber() {
        return this.Sequence(this.Integer(), this.Optional(this.Sequence(this.Frac(), this.Optional(this.Exp()), new Object[0])), new Object[]{this.ZeroOrMore(this.WhiteSpace())});
    }

    public Rule JsonArray() {
        return this.Sequence("[ ", this.FirstOf(this.Sequence(this.Value(), this.ZeroOrMore(this.Sequence(", ", this.Value(), new Object[0])), new Object[0]), this.Optional(this.Value()), new Object[0]), new Object[]{"] "});
    }

    @SuppressSubnodes
    public Rule JsonString() {
        return this.FirstOf(this.JsonDoubleQuotedString(), this.JsonSingleQuotedString(), new Object[0]);
    }

    @SuppressSubnodes
    public Rule JsonDoubleQuotedString() {
        return this.Sequence("\"", this.ZeroOrMore(this.Character()), new Object[]{"\" "});
    }

    @SuppressSubnodes
    public Rule JsonSingleQuotedString() {
        return this.Sequence("'", this.ZeroOrMore(this.SingleQuotedStringCharacter()), new Object[]{"' "});
    }

    @SuppressSubnodes
    public Rule BsonFunctionCall() {
        return this.Sequence(this.Optional("new "), this.SupportedBsonFunction(), new Object[]{this.ZeroOrMore(this.WhiteSpace()), "( ", this.FirstOf(this.Sequence(this.PrimitiveValue(), this.ZeroOrMore(this.Sequence(", ", this.PrimitiveValue(), new Object[0])), new Object[0]), this.Optional(this.PrimitiveValue()), new Object[0]), ") "});
    }

    public Rule SupportedBsonFunction() {
        return this.FirstOf("BinData", "Date", new Object[]{"HexData", "ISODate", "NumberInt", "NumberLong", "ObjectId", "Timestamp", "RegExp", "DBPointer", "UUID", "GUID", "CSUUID", "CSGUID", "JUUID", "JGUID", "PYUUID", "PYGUID"});
    }

    public Rule Character() {
        return this.FirstOf(this.EscapedChar(), this.NormalChar(), new Object[0]);
    }

    public Rule SingleQuotedStringCharacter() {
        return this.FirstOf(this.SingleQuotedStringEscapedChar(), this.SingleQuotedStringNormalChar(), new Object[0]);
    }

    public Rule EscapedChar() {
        return this.Sequence("\\", this.FirstOf(this.AnyOf("\"\\/bfnrt"), this.Unicode(), new Object[0]), new Object[0]);
    }

    public Rule SingleQuotedStringEscapedChar() {
        return this.Sequence("\\", this.FirstOf(this.AnyOf("'\\/bfnrt"), this.Unicode(), new Object[0]), new Object[0]);
    }

    public Rule NormalChar() {
        return this.Sequence(this.TestNot(this.AnyOf("\"\\")), ANY, new Object[0]);
    }

    public Rule SingleQuotedStringNormalChar() {
        return this.Sequence(this.TestNot(this.AnyOf("'\\")), ANY, new Object[0]);
    }

    public Rule Unicode() {
        return this.Sequence("u", this.HexDigit(), new Object[]{this.HexDigit(), this.HexDigit(), this.HexDigit()});
    }

    public Rule Integer() {
        return this.Sequence(this.Optional("-"), this.NonZeroDigit(), new Object[]{this.ZeroOrMore(this.Digit())});
    }

    public Rule Digits() {
        return this.OneOrMore(this.Digit());
    }

    public Rule Digit() {
        return this.CharRange('0', '9');
    }

    public Rule NonZeroDigit() {
        return this.CharRange('1', '9');
    }

    public Rule HexDigit() {
        return this.FirstOf(this.CharRange('0', '9'), this.CharRange('a', 'f'), new Object[]{this.CharRange('A', 'F')});
    }

    public Rule Frac() {
        return this.Sequence(".", this.Digits(), new Object[0]);
    }

    public Rule Exp() {
        return this.Sequence(this.IgnoreCase("e"), this.Optional(this.AnyOf("+-")), new Object[]{this.Digits()});
    }

    @SuppressNode
    public Rule WhiteSpace() {
        return this.OneOrMore(this.AnyOf(" \n\r\t\f"));
    }

    @SuppressNode
    protected Rule fromStringLiteral(String string) {
        if (string.endsWith(" ")) {
            return this.Sequence(string.trim(), this.Optional(this.WhiteSpace()), new Object[0]);
        }
        return this.String(string);
    }
}

