/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.dialect.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.regex.Pattern;

public class MongoHelpers {
    private static final Pattern DOT_SEPARATOR_PATTERN = Pattern.compile("\\.");

    public static void setValue(DBObject entity, String column, Object value) {
        if (!column.contains(".")) {
            entity.put(column, value);
        } else {
            String[] path = DOT_SEPARATOR_PATTERN.split(column);
            Object field = entity;
            int size = path.length;
            for (int index = 0; index < size; ++index) {
                DBObject parent = field;
                String node = path[index];
                if ((field = parent.get(node)) != null) continue;
                field = index == size - 1 ? value : new BasicDBObject();
                parent.put(node, field);
            }
        }
    }

    public static void resetValue(DBObject entity, String column) {
        if (!column.contains(".")) {
            entity.removeField(column);
        } else {
            String[] path = DOT_SEPARATOR_PATTERN.split(column);
            Object field = entity;
            int size = path.length;
            for (int index = 0; index < size; ++index) {
                DBObject parent = field;
                String node = path[index];
                if ((field = parent.get(node)) == null && index < size - 1) {
                    return;
                }
                if (index != size - 1) continue;
                parent.removeField(node);
            }
        }
    }

    public static boolean hasField(DBObject entity, String dotPath) {
        return MongoHelpers.getValueOrNull(entity, dotPath) != null;
    }

    public static <T> T getValueOrNull(DBObject entity, String dotPath, Class<T> type) {
        Object value = MongoHelpers.getValueOrNull(entity, dotPath);
        return type.isInstance(value) ? (T)type.cast(value) : null;
    }

    public static Object getValueOrNull(DBObject entity, String dotPath) {
        if (!dotPath.contains(".")) {
            return entity.get(dotPath);
        }
        String[] path = DOT_SEPARATOR_PATTERN.split(dotPath);
        int size = path.length;
        for (int index = 0; index < size - 1; ++index) {
            Object next = entity.get(path[index]);
            if (next == null || !(next instanceof DBObject)) {
                return null;
            }
            entity = (DBObject)next;
        }
        String field = path[size - 1];
        return entity.get(field);
    }

    public static String flatten(String left, String right) {
        return left == null || left.isEmpty() ? right : left + "." + right;
    }
}

