/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.type;

import java.util.Arrays;
import java.util.List;
import org.bson.BsonArray;
import org.bson.Document;
import org.hibernate.ogm.datastore.mongodb.type.AbstractGeoJsonObject;
import org.hibernate.ogm.datastore.mongodb.type.GeoPoint;
import org.hibernate.ogm.util.Experimental;
import org.hibernate.ogm.util.impl.Contracts;

@Experimental
public class GeoLineString
extends AbstractGeoJsonObject {
    private static final String TYPE = "LineString";
    private GeoPoint startPoint;
    private GeoPoint endPoint;

    public GeoLineString(GeoPoint startPoint, GeoPoint endPoint) {
        super(TYPE);
        Contracts.assertNotNull((Object)startPoint, (String)"startPoint");
        Contracts.assertNotNull((Object)endPoint, (String)"endPoint");
        this.startPoint = startPoint;
        this.endPoint = endPoint;
    }

    public GeoPoint getStartPoint() {
        return this.startPoint;
    }

    public GeoPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    protected BsonArray toCoordinates() {
        BsonArray coordinates = new BsonArray(Arrays.asList(this.startPoint.toCoordinates(), this.endPoint.toCoordinates()));
        return coordinates;
    }

    static GeoLineString fromCoordinates(List<List<Double>> coordinates) {
        if (coordinates == null) {
            return null;
        }
        return new GeoLineString(GeoPoint.fromCoordinates(coordinates.get(0)), GeoPoint.fromCoordinates(coordinates.get(1)));
    }

    public static GeoLineString fromDocument(Document document) {
        if (document == null) {
            return null;
        }
        GeoLineString.checkType(TYPE, document);
        List coordinates = (List)document.get((Object)"coordinates");
        return GeoLineString.fromCoordinates(coordinates);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeoLineString that = (GeoLineString)obj;
        if (!that.startPoint.equals(this.startPoint)) {
            return false;
        }
        return that.endPoint.equals(this.endPoint);
    }

    public int hashCode() {
        int hashCode = this.startPoint.hashCode();
        hashCode = hashCode * 31 + this.endPoint.hashCode();
        return hashCode;
    }

    public String toString() {
        return "GeoLineString [startPoint=" + this.startPoint + ", endPoint=" + this.endPoint + "]";
    }
}

