package org.hibernate.ogm.datastore.mongodb.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import org.hibernate.ogm.exception.EntityAlreadyExistsException;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import org.hibernate.MappingException;
import org.hibernate.ogm.model.key.spi.EntityKey;
import java.lang.RuntimeException;
import org.hibernate.TransactionException;
import javax.transaction.SystemException;
import org.jboss.logging.BasicLogger;
import java.lang.IllegalArgumentException;
import org.hibernate.ogm.datastore.mongodb.query.impl.MongoDBQueryDescriptor;
import java.lang.annotation.ElementType;
import javax.annotation.Generated;
import com.mongodb.MongoException;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import java.lang.Exception;
import org.hibernate.service.spi.ServiceException;
import javax.persistence.PersistenceException;
import java.util.Collection;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-02-20T14:41:23+0000")
public class Log_$logger extends DelegatingBasicLogger implements org.hibernate.ogm.datastore.mongodb.logging.impl.Log, Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void connectingToMongo(final String host, final int timeout) {
        super.log.logf(FQCN, INFO, null, connectingToMongo$str(), host, timeout);
    }
    private static final String connectingToMongo = "OGM001201: Connecting to MongoDB at %1$s with a timeout set at %2$d millisecond(s)";
    protected String connectingToMongo$str() {
        return connectingToMongo;
    }
    @Override
    public final void disconnectingFromMongo() {
        super.log.logf(FQCN, INFO, null, disconnectingFromMongo$str());
    }
    private static final String disconnectingFromMongo = "OGM001202: Closing connection to MongoDB";
    protected String disconnectingFromMongo$str() {
        return disconnectingFromMongo;
    }
    private static final String unableToInitializeMongoDB = "OGM001203: Unable to find or initialize a connection to the MongoDB server";
    protected String unableToInitializeMongoDB$str() {
        return unableToInitializeMongoDB;
    }
    @Override
    public final HibernateException unableToInitializeMongoDB(final RuntimeException e) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToInitializeMongoDB$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void creatingDatabase(final String dbName) {
        super.log.logf(FQCN, INFO, null, creatingDatabase$str(), dbName);
    }
    private static final String creatingDatabase = "OGM001206: Mongo database named [%s] is not defined. Creating it!";
    protected String creatingDatabase$str() {
        return creatingDatabase;
    }
    @Override
    public final void connectingToMongoDatabase(final String dbName) {
        super.log.logf(FQCN, INFO, null, connectingToMongoDatabase$str(), dbName);
    }
    private static final String connectingToMongoDatabase = "OGM001207: Connecting to Mongo database named [%s].";
    protected String connectingToMongoDatabase$str() {
        return connectingToMongoDatabase;
    }
    private static final String unableToDropDatabase = "OGM001209: The database named [%s] cannot be dropped";
    protected String unableToDropDatabase$str() {
        return unableToDropDatabase;
    }
    @Override
    public final HibernateException unableToDropDatabase(final MongoException e, final String databaseName) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToDropDatabase$str(), databaseName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void removedAssociation(final long nAffected) {
        super.log.logf(FQCN, TRACE, null, removedAssociation$str(), nAffected);
    }
    private static final String removedAssociation = "OGM001210: Removed [%d] associations";
    protected String removedAssociation$str() {
        return removedAssociation;
    }
    private static final String unableToConnectToDatastore = "OGM001214: Unable to connect to MongoDB instance: %1$s";
    protected String unableToConnectToDatastore$str() {
        return unableToConnectToDatastore;
    }
    @Override
    public final HibernateException unableToConnectToDatastore(final String message, final Exception e) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToConnectToDatastore$str(), message), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToDetermineCollectionName = "OGM001217: The following native query does neither specify the collection name nor is its result type mapped to an entity: %s";
    protected String unableToDetermineCollectionName$str() {
        return unableToDetermineCollectionName;
    }
    @Override
    public final HibernateException unableToDetermineCollectionName(final String nativeQuery) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToDetermineCollectionName$str(), nativeQuery));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cannotUseGivenPrimaryKeyColumnName(final String givenKeyColumnName, final String usedKeyColumnName) {
        super.log.logf(FQCN, WARN, null, cannotUseGivenPrimaryKeyColumnName$str(), givenKeyColumnName, usedKeyColumnName);
    }
    private static final String cannotUseGivenPrimaryKeyColumnName = "OGM001218: Cannot use primary key column name '%s' for id generator, going to use '%s' instead";
    protected String cannotUseGivenPrimaryKeyColumnName$str() {
        return cannotUseGivenPrimaryKeyColumnName;
    }
    private static final String databaseDoesNotExistException = "OGM001219: Database %s does not exist. Either create it yourself or set property 'hibernate.ogm.datastore.create_database' to true.";
    protected String databaseDoesNotExistException$str() {
        return databaseDoesNotExistException;
    }
    @Override
    public final HibernateException databaseDoesNotExistException(final String databaseName) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), databaseDoesNotExistException$str(), databaseName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String collectionNameHasInvalidSystemPrefix = "OGM001220: When using MongoDB it is not valid to use a name for a table (a collection) which starts with the 'system.' prefix. Please change name for '%s', for example by using @Table ";
    protected String collectionNameHasInvalidSystemPrefix$str() {
        return collectionNameHasInvalidSystemPrefix;
    }
    @Override
    public final MappingException collectionNameHasInvalidSystemPrefix(final String qualifiedName) {
        final MappingException result = new MappingException(String.format(getLoggingLocale(), collectionNameHasInvalidSystemPrefix$str(), qualifiedName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String collectionNameContainsNULCharacter = "OGM001221: When using MongoDB it is not valid to use a name for a table (a collection) which contains the NUL character '\\0'. Please change name for '%s', for example by using @Table ";
    protected String collectionNameContainsNULCharacter$str() {
        return collectionNameContainsNULCharacter;
    }
    @Override
    public final MappingException collectionNameContainsNULCharacter(final String qualifiedName) {
        final MappingException result = new MappingException(String.format(getLoggingLocale(), collectionNameContainsNULCharacter$str(), qualifiedName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String collectionNameContainsDollarCharacter = "OGM001222: When using MongoDB it is not valid to use a name for a table (a collection) which contains the dollar character '$'; for example this is a common problem with inner classes. Please pick a valid collection name for '%s', for example by using @Table ";
    protected String collectionNameContainsDollarCharacter$str() {
        return collectionNameContainsDollarCharacter;
    }
    @Override
    public final MappingException collectionNameContainsDollarCharacter(final String qualifiedName) {
        final MappingException result = new MappingException(String.format(getLoggingLocale(), collectionNameContainsDollarCharacter$str(), qualifiedName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fieldNameHasInvalidDollarPrefix = "OGM001223: When using MongoDB it is not valid to use a field name which starts with the prefix '$'. Please change name for '%s', for example by using @Column ";
    protected String fieldNameHasInvalidDollarPrefix$str() {
        return fieldNameHasInvalidDollarPrefix;
    }
    @Override
    public final MappingException fieldNameHasInvalidDollarPrefix(final String columnName) {
        final MappingException result = new MappingException(String.format(getLoggingLocale(), fieldNameHasInvalidDollarPrefix$str(), columnName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fieldNameContainsNULCharacter = "OGM001224: When using MongoDB it is not valid to use a field name which contains the NUL character '\\0'. Please change name for '%s', for example by using @Column ";
    protected String fieldNameContainsNULCharacter$str() {
        return fieldNameContainsNULCharacter;
    }
    @Override
    public final MappingException fieldNameContainsNULCharacter(final String fieldName) {
        final MappingException result = new MappingException(String.format(getLoggingLocale(), fieldNameContainsNULCharacter$str(), fieldName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String writeConcernDeprecated = "OGM001225: This WriteConcern has been deprecated or removed by MongoDB: %s";
    protected String writeConcernDeprecated$str() {
        return writeConcernDeprecated;
    }
    @Override
    public final HibernateException writeConcernDeprecated(final String writeConcern) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), writeConcernDeprecated$str(), writeConcern));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInvokeMethodViaReflection = "OGM001226: Unable to use reflection on invoke method '%s#%s' via reflection.";
    protected String unableToInvokeMethodViaReflection$str() {
        return unableToInvokeMethodViaReflection;
    }
    @Override
    public final HibernateException unableToInvokeMethodViaReflection(final String clazz, final String method) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToInvokeMethodViaReflection$str(), clazz, method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String updateQueryMustBeExecutedViaExecuteUpdate = "OGM001227: Query must be executed using the 'executeUpdate()' method: %s";
    protected String updateQueryMustBeExecutedViaExecuteUpdate$str() {
        return updateQueryMustBeExecutedViaExecuteUpdate;
    }
    @Override
    public final HibernateException updateQueryMustBeExecutedViaExecuteUpdate(final MongoDBQueryDescriptor queryDescriptor) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), updateQueryMustBeExecutedViaExecuteUpdate$str(), queryDescriptor));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String readQueryMustBeExecutedViaGetResultList = "OGM001228: Query must be executed using 'getResultList()' or 'getSingleResult()' method: %s";
    protected String readQueryMustBeExecutedViaGetResultList$str() {
        return readQueryMustBeExecutedViaGetResultList;
    }
    @Override
    public final HibernateException readQueryMustBeExecutedViaGetResultList(final MongoDBQueryDescriptor queryDescriptor) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), readQueryMustBeExecutedViaGetResultList$str(), queryDescriptor));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String constraintViolationForEntity = "OGM001229: Constraint violation for entity %s (%s)";
    protected String constraintViolationForEntity$str() {
        return constraintViolationForEntity;
    }
    @Override
    public final HibernateException constraintViolationForEntity(final EntityKey entityKey, final String message, final Exception cause) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), constraintViolationForEntity$str(), entityKey, message), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String constraintViolationOnFlush = "OGM001230: Constraint violation while flushing several entities (%s)";
    protected String constraintViolationOnFlush$str() {
        return constraintViolationOnFlush;
    }
    @Override
    public final HibernateException constraintViolationOnFlush(final String message, final Exception cause) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), constraintViolationOnFlush$str(), message), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateIndex = "OGM001231: Unable to create index %2$s on collection %1$s";
    protected String unableToCreateIndex$str() {
        return unableToCreateIndex;
    }
    @Override
    public final HibernateException unableToCreateIndex(final String collection, final String indexName, final Exception e) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToCreateIndex$str(), collection, indexName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateTextIndex = "OGM001232: Unable to create text index %2$s on collection %1$s. A text index named %3$s already exists and MongoDB only supports one text index per collection.";
    protected String unableToCreateTextIndex$str() {
        return unableToCreateTextIndex;
    }
    @Override
    public final HibernateException unableToCreateTextIndex(final String collection, final String newIndexName, final String existingIndexName) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToCreateTextIndex$str(), collection, newIndexName, existingIndexName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void indexNameIsEmpty(final String collection) {
        super.log.logf(FQCN, ERROR, null, indexNameIsEmpty$str(), collection);
    }
    private static final String indexNameIsEmpty = "OGM001233: Cannot create an index with an empty name for collection %1$s. Please provide a name for all the indexes.";
    protected String indexNameIsEmpty$str() {
        return indexNameIsEmpty;
    }
    @Override
    public final void noValidKeysForIndex(final String collection, final String indexName) {
        super.log.logf(FQCN, ERROR, null, noValidKeysForIndex$str(), collection, indexName);
    }
    private static final String noValidKeysForIndex = "OGM001234: No valid keys found for the index %2$s of collection %1$s.";
    protected String noValidKeysForIndex$str() {
        return noValidKeysForIndex;
    }
    @Override
    public final void indexOptionReferencingNonExistingIndex(final String collection, final String forIndex) {
        super.log.logf(FQCN, WARN, null, indexOptionReferencingNonExistingIndex$str(), collection, forIndex);
    }
    private static final String indexOptionReferencingNonExistingIndex = "OGM001235: Index option for index %2$s of collection %1$s are referencing a non existing index.";
    protected String indexOptionReferencingNonExistingIndex$str() {
        return indexOptionReferencingNonExistingIndex;
    }
    private static final String invalidOptionsFormatForIndex = "OGM001236: The options for index %2$s of collection %1$s are not a valid JSON object.";
    protected String invalidOptionsFormatForIndex$str() {
        return invalidOptionsFormatForIndex;
    }
    @Override
    public final HibernateException invalidOptionsFormatForIndex(final String collection, final String indexName, final Exception e) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), invalidOptionsFormatForIndex$str(), collection, indexName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidGeoJsonType = "OGM001237: Invalid GeoJSON type %1$s. Expecting %2$s.";
    protected String invalidGeoJsonType$str() {
        return invalidGeoJsonType;
    }
    @Override
    public final HibernateException invalidGeoJsonType(final String actualType, final String expectedType) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), invalidGeoJsonType$str(), actualType, expectedType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void version(final String arg0) {
        super.log.logf(FQCN, INFO, null, version$str(), arg0);
    }
    private static final String version = "OGM000001: Hibernate OGM %1$s";
    protected String version$str() {
        return version;
    }
    @Override
    public final void persistenceXmlNotFoundInClassPath(final String arg0) {
        super.log.logf(FQCN, WARN, null, persistenceXmlNotFoundInClassPath$str(), arg0);
    }
    private static final String persistenceXmlNotFoundInClassPath = "OGM000002: Could not find any META-INF/persistence.xml file in the classpath. Unable to build Persistence Unit %1$s";
    protected String persistenceXmlNotFoundInClassPath$str() {
        return persistenceXmlNotFoundInClassPath;
    }
    private static final String cannotInstantiateGridDialect = "OGM000011: Cannot instantiate GridDialect class [%1$s]";
    protected String cannotInstantiateGridDialect$str() {
        return cannotInstantiateGridDialect;
    }
    @Override
    public final HibernateException cannotInstantiateGridDialect(final Class<?> arg0, final Exception arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotInstantiateGridDialect$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String gridDialectHasNoProperConstructor = "OGM000014: %1$s has no constructor accepting org.hibernate.ogm.datastore.spi.DatastoreProvider";
    protected String gridDialectHasNoProperConstructor$str() {
        return gridDialectHasNoProperConstructor;
    }
    @Override
    public final HibernateException gridDialectHasNoProperConstructor(final Class<?> arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), gridDialectHasNoProperConstructor$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedDatastoreProvider = "OGM000015: Expected DatastoreProvider %2$s but found %1$s";
    protected String unexpectedDatastoreProvider$str() {
        return unexpectedDatastoreProvider;
    }
    @Override
    public final HibernateException unexpectedDatastoreProvider(final Class<?> arg0, final Class<?> arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unexpectedDatastoreProvider$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg1)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void useDatastoreProvider(final Class<?> arg0) {
        super.log.logf(FQCN, INFO, null, useDatastoreProvider$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0));
    }
    private static final String useDatastoreProvider = "OGM000016: NoSQL Datastore provider: %1$s";
    protected String useDatastoreProvider$str() {
        return useDatastoreProvider;
    }
    @Override
    public final void useGridDialect(final Class<?> arg0) {
        super.log.logf(FQCN, INFO, null, useGridDialect$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0));
    }
    private static final String useGridDialect = "OGM000017: Grid Dialect: %1$s";
    protected String useGridDialect$str() {
        return useGridDialect;
    }
    private static final String jtaTransactionBeginFailed = "OGM000018: JTA transaction begin failed";
    protected String jtaTransactionBeginFailed$str() {
        return jtaTransactionBeginFailed;
    }
    @Override
    public final TransactionException jtaTransactionBeginFailed(final Exception arg0) {
        final TransactionException result = new TransactionException(String.format(getLoggingLocale(), jtaTransactionBeginFailed$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jtaCommitFailed = "OGM000019: JTA transaction commit failed";
    protected String jtaCommitFailed$str() {
        return jtaCommitFailed;
    }
    @Override
    public final TransactionException jtaCommitFailed(final Exception arg0) {
        final TransactionException result = new TransactionException(String.format(getLoggingLocale(), jtaCommitFailed$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jtaRollbackFailed = "OGM000020: JTA transaction rollback failed";
    protected String jtaRollbackFailed$str() {
        return jtaRollbackFailed;
    }
    @Override
    public final TransactionException jtaRollbackFailed(final Exception arg0) {
        final TransactionException result = new TransactionException(String.format(getLoggingLocale(), jtaRollbackFailed$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToMarkTransactionForRollback = "OGM000021: Unable to mark JTA transaction for rollback";
    protected String unableToMarkTransactionForRollback$str() {
        return unableToMarkTransactionForRollback;
    }
    @Override
    public final TransactionException unableToMarkTransactionForRollback(final Exception arg0) {
        final TransactionException result = new TransactionException(String.format(getLoggingLocale(), unableToMarkTransactionForRollback$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jtaCouldNotDetermineStatus = "OGM000022: Could not determine transaction status";
    protected String jtaCouldNotDetermineStatus$str() {
        return jtaCouldNotDetermineStatus;
    }
    @Override
    public final TransactionException jtaCouldNotDetermineStatus(final SystemException arg0) {
        final TransactionException result = new TransactionException(String.format(getLoggingLocale(), jtaCouldNotDetermineStatus$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToSetTimeout = "OGM000023: Unable to set transaction timeout to '%1$s'";
    protected String unableToSetTimeout$str() {
        return unableToSetTimeout;
    }
    @Override
    public final TransactionException unableToSetTimeout(final SystemException arg0, final int arg1) {
        final TransactionException result = new TransactionException(String.format(getLoggingLocale(), unableToSetTimeout$str(), arg1), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String querySyntaxException = "OGM000024: Syntax error in query: [%1$s]";
    protected String querySyntaxException$str() {
        return querySyntaxException;
    }
    @Override
    public final HibernateException querySyntaxException(final Exception arg0, final String arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), querySyntaxException$str(), arg1), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void interruptedBatchIndexing() {
        super.log.logf(FQCN, ERROR, null, interruptedBatchIndexing$str());
    }
    private static final String interruptedBatchIndexing = "OGM000025: Batch indexing was interrupted";
    protected String interruptedBatchIndexing$str() {
        return interruptedBatchIndexing;
    }
    private static final String illegalDiscrimantorType = "OGM000026: Illegal discriminator type: '%1$s'";
    protected String illegalDiscrimantorType$str() {
        return illegalDiscrimantorType;
    }
    @Override
    public final HibernateException illegalDiscrimantorType(final String arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), illegalDiscrimantorType$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToConvertStringToDiscriminator = "OGM000027: Could not convert string to discriminator object";
    protected String unableToConvertStringToDiscriminator$str() {
        return unableToConvertStringToDiscriminator;
    }
    @Override
    public final HibernateException unableToConvertStringToDiscriminator(final Exception arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToConvertStringToDiscriminator$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void createdQuery(final String arg0, final Object arg1) {
        super.log.logf(FQCN, DEBUG, null, createdQuery$str(), arg0, arg1);
    }
    private static final String createdQuery = "OGM000028: Created query object '%2$s' from HQL/JP-QL query '%1$s'.";
    protected String createdQuery$str() {
        return createdQuery;
    }
    @Override
    public final void unsupportedIndexerConfigurationOption(final String arg0) {
        super.log.logf(FQCN, WARN, null, unsupportedIndexerConfigurationOption$str(), arg0);
    }
    private static final String unsupportedIndexerConfigurationOption = "OGM000031: OgmMassIndexer doesn't support the configuration option '%s'. Its setting will be ignored.";
    protected String unsupportedIndexerConfigurationOption$str() {
        return unsupportedIndexerConfigurationOption;
    }
    private static final String mappingSubtypeNotInterface = "OGM000032: Unable to support mapping subtypes that are not interfaces: %1$s";
    protected String mappingSubtypeNotInterface$str() {
        return mappingSubtypeNotInterface;
    }
    @Override
    public final HibernateException mappingSubtypeNotInterface(final Class<?> arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), mappingSubtypeNotInterface$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateNewProxyInstance = "OGM000033: Unable to create new proxy instance";
    protected String cannotCreateNewProxyInstance$str() {
        return cannotCreateNewProxyInstance;
    }
    @Override
    public final HibernateException cannotCreateNewProxyInstance(final Exception arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotCreateNewProxyInstance$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotConvertAnnotation = "OGM000034: Annotation cannot be converted using %1$s";
    protected String cannotConvertAnnotation$str() {
        return cannotConvertAnnotation;
    }
    @Override
    public final HibernateException cannotConvertAnnotation(final Class<? extends org.hibernate.ogm.options.spi.AnnotationConverter<?>> arg0, final Exception arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotConvertAnnotation$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadContext = "OGM000036: Unable to load %1$s method from %2$s ";
    protected String unableToLoadContext$str() {
        return unableToLoadContext;
    }
    @Override
    public final HibernateException unableToLoadContext(final String arg0, final Class<?> arg1, final Exception arg2) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToLoadContext$str(), arg0, new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg1)), arg2);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateGlobalContextProxy = "OGM000037: Unable to create global context proxy for type %1$s";
    protected String cannotCreateGlobalContextProxy$str() {
        return cannotCreateGlobalContextProxy;
    }
    @Override
    public final HibernateException cannotCreateGlobalContextProxy(final Class<?> arg0, final Exception arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotCreateGlobalContextProxy$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateEntityContextProxy = "OGM000038: Unable to create entity context proxy for type %1$s";
    protected String cannotCreateEntityContextProxy$str() {
        return cannotCreateEntityContextProxy;
    }
    @Override
    public final HibernateException cannotCreateEntityContextProxy(final Class<?> arg0, final Exception arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotCreateEntityContextProxy$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreatePropertyContextProxy = "OGM000039: Unable to create property context proxy for type %1$s";
    protected String cannotCreatePropertyContextProxy$str() {
        return cannotCreatePropertyContextProxy;
    }
    @Override
    public final HibernateException cannotCreatePropertyContextProxy(final Class<?> arg0, final Exception arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotCreatePropertyContextProxy$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String getPropertyDoesNotExistException = "OGM000041: The given propery %1$s#%2$s with element type %3$s does not exist.";
    protected String getPropertyDoesNotExistException$str() {
        return getPropertyDoesNotExistException;
    }
    @Override
    public final HibernateException getPropertyDoesNotExistException(final String arg0, final String arg1, final ElementType arg2) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), getPropertyDoesNotExistException$str(), arg0, arg1, arg2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String getUnsupportedElementTypeException = "OGM000042: The given element type %1$s is neither FIELD nor METHOD.";
    protected String getUnsupportedElementTypeException$str() {
        return getUnsupportedElementTypeException;
    }
    @Override
    public final HibernateException getUnsupportedElementTypeException(final ElementType arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), getUnsupportedElementTypeException$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInstantiateType = "OGM000043: Cannot instantiate type %1$s. Does it define a default constructor?";
    protected String unableToInstantiateType$str() {
        return unableToInstantiateType;
    }
    @Override
    public final HibernateException unableToInstantiateType(final Class<?> arg0, final Exception arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToInstantiateType$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadClass = "OGM000044: Cannot load class %2$s specified via configuration property '%1$s'";
    protected String unableToLoadClass$str() {
        return unableToLoadClass;
    }
    @Override
    public final HibernateException unableToLoadClass(final String arg0, final String arg1, final Exception arg2) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToLoadClass$str(), arg0, arg1), arg2);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedClassType = "OGM000045: Type %2$s specified via configuration property '%1$s' is not a sub-type of expected type %3$s";
    protected String unexpectedClassType$str() {
        return unexpectedClassType;
    }
    @Override
    public final HibernateException unexpectedClassType(final String arg0, final Class<?> arg1, final Class<?> arg2) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unexpectedClassType$str(), arg0, new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg1), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg2)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedInstanceType = "OGM000046: Object %2$s of type %3$s specified via configuration property '%1$s' is not of the expected type %4$s";
    protected String unexpectedInstanceType$str() {
        return unexpectedInstanceType;
    }
    @Override
    public final HibernateException unexpectedInstanceType(final String arg0, final String arg1, final Class<?> arg2, final Class<?> arg3) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unexpectedInstanceType$str(), arg0, arg1, new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg2), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg3)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ambigiousOptionConfiguration = "OGM000047: Either an option configurator may be specified via configuration property '%1$s' or OgmConfiguration#configureOptions() may be called, but not both at the same time.";
    protected String ambigiousOptionConfiguration$str() {
        return ambigiousOptionConfiguration;
    }
    @Override
    public final HibernateException ambigiousOptionConfiguration(final String arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), ambigiousOptionConfiguration$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownAssociationStorageStrategy = "OGM000048: Unknown association storage strategy: [%s]. Supported values are: %s";
    protected String unknownAssociationStorageStrategy$str() {
        return unknownAssociationStorageStrategy;
    }
    @Override
    public final HibernateException unknownAssociationStorageStrategy(final String arg0, final String arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unknownAssociationStorageStrategy$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalPortValue = "OGM000049: The value set for the configuration property 'hibernate.ogm.datastore.port' must be a number between 1 and 65535. Found '%s'.";
    protected String illegalPortValue$str() {
        return illegalPortValue;
    }
    @Override
    public final HibernateException illegalPortValue(final int arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), illegalPortValue$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAnInteger = "OGM000050: The value set for the configuration property '%1$s' must be an integer number. Found '%2$s'.";
    protected String notAnInteger$str() {
        return notAnInteger;
    }
    @Override
    public final HibernateException notAnInteger(final String arg0, final String arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), notAnInteger$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownEnumerationValue = "OGM000051: Unknown value given for configuration property '%1$s'; Found '%2$s', but supported values are: %3$s";
    protected String unknownEnumerationValue$str() {
        return unknownEnumerationValue;
    }
    @Override
    public final HibernateException unknownEnumerationValue(final String arg0, final String arg1, final String arg2) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unknownEnumerationValue$str(), arg0, arg1, arg2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingConfigurationProperty = "OGM000052: Missing value for property '%s'";
    protected String missingConfigurationProperty$str() {
        return missingConfigurationProperty;
    }
    @Override
    public final HibernateException missingConfigurationProperty(final String arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), missingConfigurationProperty$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedPropertyType = "OGM000053: Value of unsupported type given for configuration property '%1$s': '%2$s'";
    protected String unsupportedPropertyType$str() {
        return unsupportedPropertyType;
    }
    @Override
    public final HibernateException unsupportedPropertyType(final String arg0, final String arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unsupportedPropertyType$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String closedOperationQueue = "OGM000054: It is not possible to add or poll operations from a closed queue";
    protected String closedOperationQueue$str() {
        return closedOperationQueue;
    }
    @Override
    public final HibernateException closedOperationQueue() {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), closedOperationQueue$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidConfigurationUrl = "OGM000055: Invalid URL given for configuration property '%1$s': %2$s; The specified resource could not be found.";
    protected String invalidConfigurationUrl$str() {
        return invalidConfigurationUrl;
    }
    @Override
    public final HibernateException invalidConfigurationUrl(final String arg0, final String arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), invalidConfigurationUrl$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotRetrieveEntityForRetrievalOfGeneratedProperties = "OGM000056: Unable to load record for retrieval of generated properties; Entity type: %1$s, id: %2$s";
    protected String couldNotRetrieveEntityForRetrievalOfGeneratedProperties$str() {
        return couldNotRetrieveEntityForRetrievalOfGeneratedProperties;
    }
    @Override
    public final HibernateException couldNotRetrieveEntityForRetrievalOfGeneratedProperties(final String arg0, final Serializable arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), couldNotRetrieveEntityForRetrievalOfGeneratedProperties$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mustNotBeNull = "OGM000057: '%s' must not be null";
    protected String mustNotBeNull$str() {
        return mustNotBeNull;
    }
    @Override
    public final IllegalArgumentException mustNotBeNull(final String arg0) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mustNotBeNull$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parameterMustNotBeNull = "OGM000058: Parameter '%s' must not be null";
    protected String parameterMustNotBeNull$str() {
        return parameterMustNotBeNull;
    }
    @Override
    public final IllegalArgumentException parameterMustNotBeNull(final String arg0) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), parameterMustNotBeNull$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToFindGridType = "OGM000059: Unable to find a GridType for %s";
    protected String unableToFindGridType$str() {
        return unableToFindGridType;
    }
    @Override
    public final HibernateException unableToFindGridType(final String arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToFindGridType$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void dialectDoesNotSupportSequences(final Class<?> arg0, final String arg1) {
        super.log.logf(FQCN, WARN, null, dialectDoesNotSupportSequences$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0), arg1);
    }
    private static final String dialectDoesNotSupportSequences = "OGM000060: Sequence id generator used for entity '%2$s' is not supported by grid dialect %1$s, falling back to table-based id generation. Consider to use @TableGenerator rather than @SequenceGenerator.";
    protected String dialectDoesNotSupportSequences$str() {
        return dialectDoesNotSupportSequences;
    }
    @Override
    public final void catalogOptionNotSupportedForTableGenerator(final String arg0) {
        super.log.logf(FQCN, WARN, null, catalogOptionNotSupportedForTableGenerator$str(), arg0);
    }
    private static final String catalogOptionNotSupportedForTableGenerator = "OGM000061: The option '@TableGenerator#catalog()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    protected String catalogOptionNotSupportedForTableGenerator$str() {
        return catalogOptionNotSupportedForTableGenerator;
    }
    @Override
    public final void schemaOptionNotSupportedForTableGenerator(final String arg0) {
        super.log.logf(FQCN, WARN, null, schemaOptionNotSupportedForTableGenerator$str(), arg0);
    }
    private static final String schemaOptionNotSupportedForTableGenerator = "OGM000062: The option '@TableGenerator#schema()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    protected String schemaOptionNotSupportedForTableGenerator$str() {
        return schemaOptionNotSupportedForTableGenerator;
    }
    @Override
    public final void catalogOptionNotSupportedForSequenceGenerator(final String arg0) {
        super.log.logf(FQCN, WARN, null, catalogOptionNotSupportedForSequenceGenerator$str(), arg0);
    }
    private static final String catalogOptionNotSupportedForSequenceGenerator = "OGM000063: The option '@SequenceGenerator#catalog()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    protected String catalogOptionNotSupportedForSequenceGenerator$str() {
        return catalogOptionNotSupportedForSequenceGenerator;
    }
    @Override
    public final void schemaOptionNotSupportedForSequenceGenerator(final String arg0) {
        super.log.logf(FQCN, WARN, null, schemaOptionNotSupportedForSequenceGenerator$str(), arg0);
    }
    private static final String schemaOptionNotSupportedForSequenceGenerator = "OGM000064: The option '@SequenceGenerator#schema()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    protected String schemaOptionNotSupportedForSequenceGenerator$str() {
        return schemaOptionNotSupportedForSequenceGenerator;
    }
    private static final String getIdentityGenerationStrategyNotSupportedException = "OGM000065: Id generation strategy IDENTITY configured for entity %1$s is not supported by the current grid dialect.";
    protected String getIdentityGenerationStrategyNotSupportedException$str() {
        return getIdentityGenerationStrategyNotSupportedException;
    }
    @Override
    public final HibernateException getIdentityGenerationStrategyNotSupportedException(final String arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), getIdentityGenerationStrategyNotSupportedException$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void usingNonAtomicOptimisticLocking(final String arg0) {
        super.log.logf(FQCN, WARN, null, usingNonAtomicOptimisticLocking$str(), arg0);
    }
    private static final String usingNonAtomicOptimisticLocking = "OGM000066: Entity type %s uses an optimistic locking strategy which is not supported by the current grid dialect in an atomic manner. There will be two datastore round-trips for version checking and updating the data.";
    protected String usingNonAtomicOptimisticLocking$str() {
        return usingNonAtomicOptimisticLocking;
    }
    private static final String mustNotInsertSameEntityTwice = "OGM000067: Trying to insert an already existing entity: %s";
    protected String mustNotInsertSameEntityTwice$str() {
        return mustNotInsertSameEntityTwice;
    }
    @Override
    public final EntityAlreadyExistsException mustNotInsertSameEntityTwice(final String arg0, final Exception arg1) {
        final EntityAlreadyExistsException result = new EntityAlreadyExistsException(String.format(getLoggingLocale(), mustNotInsertSameEntityTwice$str(), arg0), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotConfigureProperty = "OGM000068: Could not configure property %1$s#%2$s";
    protected String couldNotConfigureProperty$str() {
        return couldNotConfigureProperty;
    }
    @Override
    public final HibernateException couldNotConfigureProperty(final String arg0, final String arg1, final Exception arg2) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), couldNotConfigureProperty$str(), arg0, arg1), arg2);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedLockMode = "OGM000069: Grid dialect %1$s does not support lock mode %2$s";
    protected String unsupportedLockMode$str() {
        return unsupportedLockMode;
    }
    @Override
    public final HibernateException unsupportedLockMode(final Class<? extends org.hibernate.ogm.dialect.spi.GridDialect> arg0, final LockMode arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unsupportedLockMode$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0), arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void noValidDatastoreProviderShortName(final String arg0, final String arg1) {
        super.log.logf(FQCN, WARN, null, noValidDatastoreProviderShortName$str(), arg0, arg1);
    }
    private static final String noValidDatastoreProviderShortName = "OGM000070: '%1$s' is no valid datastore provider short name. Valid values are: %2$s";
    protected String noValidDatastoreProviderShortName$str() {
        return noValidDatastoreProviderShortName;
    }
    private static final String unableToStartDatastoreProvider = "OGM000071: Unable to start datastore provider";
    protected String unableToStartDatastoreProvider$str() {
        return unableToStartDatastoreProvider;
    }
    @Override
    public final ServiceException unableToStartDatastoreProvider(final Exception arg0) {
        final ServiceException result = new ServiceException(String.format(getLoggingLocale(), unableToStartDatastoreProvider$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToConfigureDatastoreProvider = "OGM000072: Unable to configure datastore provider";
    protected String unableToConfigureDatastoreProvider$str() {
        return unableToConfigureDatastoreProvider;
    }
    @Override
    public final ServiceException unableToConfigureDatastoreProvider(final Exception arg0) {
        final ServiceException result = new ServiceException(String.format(getLoggingLocale(), unableToConfigureDatastoreProvider$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotLoadLuceneParserBackend = "OGM000073: Couldn't load the Lucene-based query parser backend. Make sure the dependency org.hibernate.hql:hibernate-hql-lucene is part of the classpath.";
    protected String cannotLoadLuceneParserBackend$str() {
        return cannotLoadLuceneParserBackend;
    }
    @Override
    public final HibernateException cannotLoadLuceneParserBackend(final Exception arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotLoadLuceneParserBackend$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unableToCloseSessionButSwallowingError(final Exception arg0) {
        super.log.logf(FQCN, INFO, arg0, unableToCloseSessionButSwallowingError$str());
    }
    private static final String unableToCloseSessionButSwallowingError = "OGM000074: Could not close session; swallowing exception as transaction completed";
    protected String unableToCloseSessionButSwallowingError$str() {
        return unableToCloseSessionButSwallowingError;
    }
    @Override
    public final void jbossTransactionManagerDetected() {
        super.log.logf(FQCN, INFO, null, jbossTransactionManagerDetected$str());
    }
    private static final String jbossTransactionManagerDetected = "OGM000075: JBoss Transaction Manager (com.arjuna.ats.jta.TransactionManager) detected on classpath. Using JBossStandAloneJtaPlatform as JTAPlatform implementation";
    protected String jbossTransactionManagerDetected$str() {
        return jbossTransactionManagerDetected;
    }
    @Override
    public final void noJtaPlatformDetected() {
        super.log.logf(FQCN, INFO, null, noJtaPlatformDetected$str());
    }
    private static final String noJtaPlatformDetected = "OGM000076: No explicit or implicit defined JTAPlatform. Using NoJtaPlatform";
    protected String noJtaPlatformDetected$str() {
        return noJtaPlatformDetected;
    }
    private static final String parameterSringMustNotBeEmpty = "OGM000077: Parameter '%s' must not be an empty string";
    protected String parameterSringMustNotBeEmpty$str() {
        return parameterSringMustNotBeEmpty;
    }
    @Override
    public final IllegalArgumentException parameterSringMustNotBeEmpty(final String arg0) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), parameterSringMustNotBeEmpty$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String getUnknownAliasException = "OGM000078: Unrecognized alias in query:  %s";
    protected String getUnknownAliasException$str() {
        return getUnknownAliasException;
    }
    @Override
    public final HibernateException getUnknownAliasException(final String arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), getUnknownAliasException$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToParseHost = "OGM000079: Unable to parse hibernate.ogm.datastore.host %s\nProperty should be a comma separated list of host:port\ne.g. www.example.com, www2.example.com:123, 192.0.2.1, 192.0.2.2:123, 2001:db8::ff00:42:8329, [2001:db8::ff00:42:8329]:123";
    protected String unableToParseHost$str() {
        return unableToParseHost;
    }
    @Override
    public final HibernateException unableToParseHost(final String arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToParseHost$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorOnEntityBatchLoad = "OGM000080: Could not load an entity batch: %s";
    protected String errorOnEntityBatchLoad$str() {
        return errorOnEntityBatchLoad;
    }
    @Override
    public final HibernateException errorOnEntityBatchLoad(final String arg0, final Exception arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), errorOnEntityBatchLoad$str(), arg0), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notALong = "OGM000081: The value set for the configuration property '%1$s' must be a long number. Found '%2$s'.";
    protected String notALong$str() {
        return notALong;
    }
    @Override
    public final HibernateException notALong(final String arg0, final String arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), notALong$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String entityTupleNotFound = "OGM000082: The entity at the inverse side of the association '%1$s' cannot be found in the session: %2$s";
    protected String entityTupleNotFound$str() {
        return entityTupleNotFound;
    }
    @Override
    public final HibernateException entityTupleNotFound(final String arg0, final EntityKey arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), entityTupleNotFound$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failureWhenUsingAttributeConverter = "OGM000083: Failure when using JPA AttributeConverter [%1$s]. Is the datastore type of the converter a supported type for your datastore?";
    protected String failureWhenUsingAttributeConverter$str() {
        return failureWhenUsingAttributeConverter;
    }
    @Override
    public final PersistenceException failureWhenUsingAttributeConverter(final Class<?> arg0, final Exception arg1) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), failureWhenUsingAttributeConverter$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotFindTypeForAttributeConverter = "OGM000084: Unable to find basic type support for [%2$s] when using JPA AttributeConverter [%1$s].Is the datastore type of the converter a supported type for your datastore?";
    protected String cannotFindTypeForAttributeConverter$str() {
        return cannotFindTypeForAttributeConverter;
    }
    @Override
    public final PersistenceException cannotFindTypeForAttributeConverter(final Class<?> arg0, final Class<?> arg1) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), cannotFindTypeForAttributeConverter$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg1)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotFindEntityEntryForEntity = "OGM000085: Unable to find an entity entry for the entity '%1$s'";
    protected String cannotFindEntityEntryForEntity$str() {
        return cannotFindEntityEntryForEntity;
    }
    @Override
    public final PersistenceException cannotFindEntityEntryForEntity(final Object arg0) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), cannotFindEntityEntryForEntity$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionIdIsNotAvailable = "OGM000086: Transaction identifier not available";
    protected String transactionIdIsNotAvailable$str() {
        return transactionIdIsNotAvailable;
    }
    @Override
    public final HibernateException transactionIdIsNotAvailable() {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), transactionIdIsNotAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tupleContextNotAvailable = "OGM000087: The tuple context is not available, probably because we are dealing with more than a single entity type";
    protected String tupleContextNotAvailable$str() {
        return tupleContextNotAvailable;
    }
    @Override
    public final HibernateException tupleContextNotAvailable() {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), tupleContextNotAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void usingDeprecatedDatastoreProviderName(final String arg0, final String arg1) {
        super.log.logf(FQCN, WARN, null, usingDeprecatedDatastoreProviderName$str(), arg0, arg1);
    }
    private static final String usingDeprecatedDatastoreProviderName = "OGM000088: Configuration is referring to deprecated datastore provider name '%1$s'. Please use the new form '%2$s' instead.";
    protected String usingDeprecatedDatastoreProviderName$str() {
        return usingDeprecatedDatastoreProviderName;
    }
    private static final String queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass = "OGM000089: %1$s does not support queries on polymorphic entities using TABLE_PER_CLASS inheritance strategy. You should try using SINGLE_TABLE instead. Entities: %2$s";
    protected String queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass$str() {
        return queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass;
    }
    @Override
    public final HibernateException queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass(final String arg0, final Collection<String> arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
