/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.dialect.impl;

import java.util.regex.Pattern;
import org.bson.Document;

public class MongoHelpers {
    private static final Pattern DOT_SEPARATOR_PATTERN = Pattern.compile("\\.");

    public static void setValue(Document entity, String column, Object value) {
        if (!column.contains(".")) {
            entity.put(column, value);
        } else {
            String[] path = DOT_SEPARATOR_PATTERN.split(column);
            Object field = entity;
            int size = path.length;
            for (int index = 0; index < size; ++index) {
                Document parent = field;
                String node = path[index];
                if ((field = parent.get((Object)node)) != null) continue;
                field = index == size - 1 ? value : new Document();
                parent.put(node, field);
            }
        }
    }

    public static void resetValue(Document entity, String column) {
        if (!column.contains(".")) {
            entity.remove((Object)column);
        } else {
            String[] path = DOT_SEPARATOR_PATTERN.split(column);
            Object field = entity;
            int size = path.length;
            for (int index = 0; index < size; ++index) {
                Document parent = field;
                String node = path[index];
                if ((field = parent.get((Object)node)) == null && index < size - 1) {
                    return;
                }
                if (index != size - 1) continue;
                parent.remove((Object)node);
            }
        }
    }

    public static boolean hasField(Document entity, String dotPath) {
        return MongoHelpers.getValueOrNull(entity, dotPath) != null;
    }

    public static <T> T getValueOrNull(Document entity, String dotPath, Class<T> type) {
        Object value = MongoHelpers.getValueOrNull(entity, dotPath);
        return type.isInstance(value) ? (T)type.cast(value) : null;
    }

    public static Object getValueOrNull(Document entity, String dotPath) {
        if (!dotPath.contains(".")) {
            return entity.get((Object)dotPath);
        }
        String[] path = DOT_SEPARATOR_PATTERN.split(dotPath);
        int size = path.length;
        for (int index = 0; index < size - 1; ++index) {
            Object next = entity.get((Object)path[index]);
            if (next == null || !(next instanceof Document)) {
                return null;
            }
            entity = (Document)next;
        }
        String field = path[size - 1];
        return entity.get((Object)field);
    }

    public static String flatten(String left, String right) {
        return left == null || left.isEmpty() ? right : left + "." + right;
    }
}

