/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.nativequery.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bson.Document;
import org.bson.json.JsonParseException;
import org.hibernate.ogm.datastore.mongodb.query.impl.MongoDBQueryDescriptor;
import org.hibernate.ogm.datastore.mongodb.query.parsing.nativequery.impl.NativeQueryParseException;
import org.hibernate.ogm.util.impl.StringHelper;

public class MongoDBQueryDescriptorBuilder {
    private String collection;
    private MongoDBQueryDescriptor.Operation operation;
    private boolean isCliQuery;
    private String invalidJsonParameter;
    private boolean areParametersValid;
    private String operationName;
    private boolean isQueryValid;
    private String criteria;
    private String projection;
    private String orderBy;
    private String distinctFieldName;
    private String mapFunction;
    private String reduceFunction;
    private String updateOrInsert;
    private String options;
    private Set<Integer> parsed = new HashSet<Integer>();
    private List<Document> pipeline = new ArrayList<Document>();
    private Deque<StackedOperation> stack = new ArrayDeque<StackedOperation>();

    public boolean setCollection(String collection) {
        this.collection = collection.trim();
        return true;
    }

    public boolean setOperation(MongoDBQueryDescriptor.Operation operation) {
        this.operation = operation;
        return true;
    }

    public boolean isCliQuery() {
        return this.isCliQuery;
    }

    public boolean setCliQuery(boolean isCliQuery) {
        this.isCliQuery = isCliQuery;
        return true;
    }

    public boolean setInvalidJsonParameter(String invalidJsonParameter) {
        this.invalidJsonParameter = invalidJsonParameter;
        return true;
    }

    public boolean setParametersValid(boolean areParametersValid) {
        this.areParametersValid = areParametersValid;
        return true;
    }

    public boolean setOperationName(String operationName) {
        this.operationName = operationName;
        return true;
    }

    public boolean setQueryValid(boolean isQueryValid) {
        this.isQueryValid = isQueryValid;
        return true;
    }

    public boolean setCriteria(String criteria) {
        this.criteria = criteria;
        return true;
    }

    public boolean setProjection(String projection) {
        this.projection = projection;
        return true;
    }

    public boolean setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return true;
    }

    public boolean setOptions(String options) {
        this.options = options;
        return true;
    }

    public boolean setUpdateOrInsert(String updateOrInsert) {
        this.updateOrInsert = updateOrInsert;
        return true;
    }

    public boolean setDistinctFieldName(String fieldName) {
        this.distinctFieldName = fieldName.trim();
        return true;
    }

    public boolean setMapFunction(String mapFunction) {
        this.mapFunction = mapFunction;
        return true;
    }

    public boolean setReduceFunction(String reduceFunction) {
        this.reduceFunction = reduceFunction;
        return true;
    }

    public MongoDBQueryDescriptor build() throws NativeQueryParseException {
        if (!this.isQueryValid) {
            if (this.isCliQuery) {
                if (this.collection == null) {
                    throw new NativeQueryParseException("Cli query should match the format db.collection.operation(<arguments>)");
                }
                if (this.operation == null && this.operationName == null) {
                    throw new NativeQueryParseException("Cli query should match the format db.collection.operation(<arguments>)");
                }
                if (this.operation == null) {
                    throw new NativeQueryParseException("Operation '" + this.operationName + "' is unsupported");
                }
                if (this.invalidJsonParameter != null) {
                    try {
                        Document.parse((String)this.invalidJsonParameter);
                    }
                    catch (JsonParseException e) {
                        throw new NativeQueryParseException((Exception)((Object)e));
                    }
                }
                if (!this.areParametersValid) {
                    throw new NativeQueryParseException("Parameters are invalid for " + this.operationName);
                }
                throw new NativeQueryParseException("Missing ')'");
            }
            try {
                Document.parse((String)this.invalidJsonParameter);
            }
            catch (JsonParseException e) {
                throw new NativeQueryParseException((Exception)((Object)e));
            }
        }
        if (this.operation != MongoDBQueryDescriptor.Operation.AGGREGATE_PIPELINE) {
            MongoDBQueryDescriptor descriptor = null;
            if (this.operation == MongoDBQueryDescriptor.Operation.INSERTMANY) {
                List documents = (List)MongoDBQueryDescriptorBuilder.parseAsObject(this.updateOrInsert);
                descriptor = new MongoDBQueryDescriptor(this.collection, this.operation, this.parse(this.criteria), this.parse(this.projection), this.parse(this.orderBy), this.parse(this.options), null, documents, null, null, null, null, null);
            } else {
                Object anyDocs;
                descriptor = this.operation == MongoDBQueryDescriptor.Operation.INSERT ? ((anyDocs = MongoDBQueryDescriptorBuilder.parseAsObject(this.updateOrInsert)) instanceof List ? new MongoDBQueryDescriptor(this.collection, this.operation, this.parse(this.criteria), this.parse(this.projection), this.parse(this.orderBy), this.parse(this.options), null, (List)anyDocs, null, null, null, null, null) : new MongoDBQueryDescriptor(this.collection, this.operation, this.parse(this.criteria), this.parse(this.projection), this.parse(this.orderBy), this.parse(this.options), (Document)anyDocs, null, null, null, null, null, null)) : new MongoDBQueryDescriptor(this.collection, this.operation, this.parse(this.criteria), this.parse(this.projection), this.parse(this.orderBy), this.parse(this.options), this.parse(this.updateOrInsert), null, null, this.distinctFieldName, this.mapFunction, this.reduceFunction, null);
            }
            return descriptor;
        }
        return new MongoDBQueryDescriptor(this.collection, this.operation, this.pipeline);
    }

    private Document parse(String json) {
        return (Document)MongoDBQueryDescriptorBuilder.parseAsObject(json);
    }

    private static Object parseAsObject(String json) {
        if (StringHelper.isNullOrEmptyString((Object)json)) {
            return null;
        }
        Document object = Document.parse((String)("{ 'json': " + json + "}"));
        return object.get((Object)"json");
    }

    private static Document operation(StackedOperation operation, String value) {
        Document stage = new Document();
        stage.put(MongoDBQueryDescriptorBuilder.normalize(operation), MongoDBQueryDescriptorBuilder.parseAsObject(value));
        return stage;
    }

    public boolean addPipeline(StackedOperation operation, String value) {
        if (!this.parsed.contains(operation.getIndex())) {
            this.parsed.add(operation.getIndex());
            this.pipeline.add(MongoDBQueryDescriptorBuilder.operation(operation, value));
        }
        return true;
    }

    private static String normalize(StackedOperation operation) {
        return operation.getOperation().replaceAll("'", "").replaceAll("\"", "").trim();
    }

    public boolean push(int index, String match) {
        this.stack.push(new StackedOperation(index, match));
        return true;
    }

    public StackedOperation pop() {
        return this.stack.pop();
    }

    private static class StackedOperation {
        private final int index;
        private final String operation;

        public StackedOperation(int index, String operation) {
            this.index = index;
            this.operation = operation;
        }

        public int getIndex() {
            return this.index;
        }

        public String getOperation() {
            return this.operation;
        }
    }

    public static class PipelineOperation {
        private final String command;
        private final String value;

        public PipelineOperation(String command, String value) {
            this.command = command;
            this.value = value;
        }

        public String getCommand() {
            return this.command;
        }

        public String getValue() {
            return this.value;
        }
    }
}

