/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.impl;

import java.util.concurrent.TimeUnit;
import org.hibernate.HibernateException;
import org.hibernate.annotations.Immutable;
import org.hibernate.ogm.cfg.impl.HostParser;
import org.hibernate.ogm.cfg.spi.Hosts;
import org.hibernate.ogm.datastore.redis.logging.impl.Log;
import org.hibernate.ogm.datastore.redis.logging.impl.LoggerFactory;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.ogm.util.configurationreader.spi.PropertyValidator;

@Immutable
public class RedisConfiguration {
    private static final String DEFAULT_HOST = "localhost";
    private static final long DEFAULT_TIMEOUT = TimeUnit.MILLISECONDS.toMillis(5000L);
    private static final int DEFAULT_PORT = 6379;
    private static final int DEFAULT_DATABASE = 0;
    private static final Log log = LoggerFactory.getLogger();
    private static final PropertyValidator<Integer> DATABASE_VALIDATOR = new PropertyValidator<Integer>(){

        public void validate(Integer value) throws HibernateException {
            if (value == null) {
                return;
            }
            if (value < 0 || value > 15) {
                throw log.illegalDatabaseValue(value);
            }
        }
    };
    private final Hosts hosts;
    private final int databaseNumber;
    private final String password;
    private final long timeout;
    private final boolean ssl;

    public RedisConfiguration(ConfigurationPropertyReader propertyReader) {
        String host = (String)propertyReader.property("hibernate.ogm.datastore.host", String.class).withDefault((Object)DEFAULT_HOST).getValue();
        this.hosts = HostParser.parse((String)host, null, (Integer)6379);
        this.databaseNumber = (Integer)propertyReader.property("hibernate.ogm.datastore.database", Integer.class).withValidator(DATABASE_VALIDATOR).withDefault((Object)0).getValue();
        this.password = (String)propertyReader.property("hibernate.ogm.datastore.password", String.class).getValue();
        this.timeout = ((Integer)propertyReader.property("hibernate.ogm.redis.connection_timeout", Integer.class).withDefault((Object)((int)DEFAULT_TIMEOUT)).getValue()).intValue();
        this.ssl = (Boolean)propertyReader.property("hibernate.ogm.redis.ssl", Boolean.TYPE).withDefault((Object)false).getValue();
    }

    public Hosts getHosts() {
        return this.hosts;
    }

    public int getDatabaseNumber() {
        return this.databaseNumber;
    }

    public String getPassword() {
        return this.password;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isSsl() {
        return this.ssl;
    }
}

