/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis;

import com.lambdaworks.redis.KeyScanCursor;
import com.lambdaworks.redis.ScanArgs;
import com.lambdaworks.redis.cluster.api.sync.RedisClusterCommands;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.document.impl.DotPatternMapHelpers;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.document.options.spi.AssociationStorageOption;
import org.hibernate.ogm.datastore.map.impl.MapHelpers;
import org.hibernate.ogm.datastore.redis.AbstractRedisDialect;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisAssociation;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisAssociationSnapshot;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisTupleSnapshot;
import org.hibernate.ogm.datastore.redis.dialect.value.Association;
import org.hibernate.ogm.datastore.redis.dialect.value.Entity;
import org.hibernate.ogm.datastore.redis.impl.RedisDatastoreProvider;
import org.hibernate.ogm.datastore.redis.impl.json.JsonEntityStorageStrategy;
import org.hibernate.ogm.dialect.multiget.spi.MultigetGridDialect;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKind;
import org.hibernate.ogm.model.key.spi.AssociationType;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleOperation;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.options.spi.OptionsContext;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.type.Type;

public class RedisJsonDialect
extends AbstractRedisDialect
implements MultigetGridDialect {
    protected final JsonEntityStorageStrategy entityStorageStrategy;

    public RedisJsonDialect(RedisDatastoreProvider provider) {
        super(provider.getConnection(), provider.isCluster());
        this.entityStorageStrategy = new JsonEntityStorageStrategy(this.strategy, (RedisClusterCommands<String, String>)this.connection);
    }

    public GridType overrideType(Type type) {
        return this.strategy.overrideType(type);
    }

    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        Entity entity = this.entityStorageStrategy.getEntity(this.entityId(key));
        if (entity != null) {
            return new Tuple((TupleSnapshot)new RedisTupleSnapshot(entity.getProperties()));
        }
        return null;
    }

    public void insertOrUpdateTuple(EntityKey key, Tuple tuple, TupleContext tupleContext) {
        Map<String, Object> map = ((RedisTupleSnapshot)tuple.getSnapshot()).getMap();
        MapHelpers.applyTupleOpsOnMap((Tuple)tuple, map);
        this.storeEntity(key, map, tupleContext.getOptionsContext(), (Set<TupleOperation>)tuple.getOperations());
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata keyMetadata, AssociationTypeContext associationTypeContext) {
        AssociationStorageType associationStorage = this.getAssociationStorageType(associationTypeContext);
        return keyMetadata.getAssociationType() == AssociationType.ONE_TO_ONE || keyMetadata.getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION || associationStorage == AssociationStorageType.IN_ENTITY;
    }

    private AssociationStorageType getAssociationStorageType(AssociationTypeContext associationTypeContext) {
        return (AssociationStorageType)associationTypeContext.getOptionsContext().getUnique(AssociationStorageOption.class);
    }

    public org.hibernate.ogm.model.spi.Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        RedisAssociation redisAssociation = null;
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            Entity owningEntity = this.getEmbeddingEntity(key);
            if (owningEntity != null && DotPatternMapHelpers.hasField(owningEntity.getPropertiesAsHierarchy(), (String)key.getMetadata().getCollectionRole())) {
                redisAssociation = RedisAssociation.fromEmbeddedAssociation(owningEntity, key.getMetadata());
            }
        } else {
            Association association = this.getAssociation(key);
            if (association != null) {
                redisAssociation = RedisAssociation.fromAssociationDocument(association);
            }
        }
        return redisAssociation != null ? new org.hibernate.ogm.model.spi.Association((AssociationSnapshot)new RedisAssociationSnapshot(redisAssociation, key)) : null;
    }

    public org.hibernate.ogm.model.spi.Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        RedisAssociation redisAssociation;
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            Entity owningEntity = this.getEmbeddingEntity(key);
            if (owningEntity == null) {
                owningEntity = this.storeEntity(key.getEntityKey(), new Entity(), associationContext);
            }
            redisAssociation = RedisAssociation.fromEmbeddedAssociation(owningEntity, key.getMetadata());
        } else {
            Association association = new Association();
            redisAssociation = RedisAssociation.fromAssociationDocument(association);
        }
        return new org.hibernate.ogm.model.spi.Association((AssociationSnapshot)new RedisAssociationSnapshot(redisAssociation, key));
    }

    private Entity getEmbeddingEntity(AssociationKey key) {
        return this.entityStorageStrategy.getEntity(this.entityId(key.getEntityKey()));
    }

    public void insertOrUpdateAssociation(AssociationKey associationKey, org.hibernate.ogm.model.spi.Association association, AssociationContext associationContext) {
        Object rows = this.getAssociationRows(association, associationKey, associationContext);
        RedisAssociation redisAssociation = ((RedisAssociationSnapshot)association.getSnapshot()).getRedisAssociation();
        redisAssociation.setRows(rows);
        if (this.isStoredInEntityStructure(associationKey.getMetadata(), associationContext.getAssociationTypeContext())) {
            this.storeEntity(associationKey.getEntityKey(), (Entity)redisAssociation.getOwningDocument(), associationContext);
        } else {
            Long currentTtl = this.connection.pttl((Object)this.entityId(associationKey.getEntityKey()));
            this.storeAssociation(associationKey, (Association)redisAssociation.getOwningDocument());
            this.setAssociationTTL(associationKey, associationContext, currentTtl);
        }
    }

    protected Object getAssociationRows(org.hibernate.ogm.model.spi.Association association, AssociationKey key, AssociationContext associationContext) {
        boolean organizeByRowKey = DotPatternMapHelpers.organizeAssociationMapByRowKey((org.hibernate.ogm.model.spi.Association)association, (AssociationKey)key, (AssociationContext)associationContext);
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext()) && organizeByRowKey) {
            String rowKeyColumn = organizeByRowKey ? key.getMetadata().getRowKeyIndexColumnNames()[0] : null;
            HashMap rows = new HashMap();
            for (RowKey rowKey : association.getKeys()) {
                Map row = (Map)RedisJsonDialect.getAssociationRow(association.get(rowKey), key);
                String rowKeyValue = (String)row.remove(rowKeyColumn);
                if (row.keySet().size() == 1) {
                    rows.put(rowKeyValue, row.values().iterator().next());
                    continue;
                }
                rows.put(rowKeyValue, row);
            }
            return rows;
        }
        ArrayList<Object> rows = new ArrayList<Object>(association.size());
        for (RowKey rowKey : association.getKeys()) {
            rows.add(RedisJsonDialect.getAssociationRow(association.get(rowKey), key));
        }
        return rows;
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            Entity owningEntity = this.getEmbeddingEntity(key);
            if (owningEntity != null) {
                owningEntity.removeAssociation(key.getMetadata().getCollectionRole());
                this.storeEntity(key.getEntityKey(), owningEntity, associationContext);
            }
        } else {
            this.removeAssociation(key);
        }
    }

    public void forEachTuple(ModelConsumer consumer, EntityKeyMetadata ... entityKeyMetadatas) {
        for (EntityKeyMetadata entityKeyMetadata : entityKeyMetadatas) {
            KeyScanCursor<String> cursor = null;
            String prefix = entityKeyMetadata.getTable() + ":";
            ScanArgs scanArgs = ScanArgs.Builder.matches((String)(prefix + "*"));
            do {
                cursor = this.scan(cursor, scanArgs);
                for (String key : cursor.getKeys()) {
                    Entity document = this.entityStorageStrategy.getEntity(key);
                    this.addKeyValuesFromKeyName(entityKeyMetadata, prefix, key, document);
                    consumer.consume(new Tuple((TupleSnapshot)new RedisTupleSnapshot(document.getProperties())));
                }
            } while (!cursor.isFinished());
        }
    }

    private void storeEntity(EntityKey key, Map<String, Object> map, OptionsContext optionsContext, Set<TupleOperation> operations) {
        Entity entityDocument = new Entity();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (key.getMetadata().isKeyColumn(entry.getKey())) continue;
            entityDocument.set(entry.getKey(), entry.getValue());
        }
        this.storeEntity(key, entityDocument, optionsContext, operations);
    }

    private void storeEntity(EntityKey key, Entity document, OptionsContext optionsContext, Set<TupleOperation> operations) {
        Long currentTtl = this.connection.pttl((Object)this.entityId(key));
        this.entityStorageStrategy.storeEntity(this.entityId(key), document, operations);
        this.setEntityTTL(key, currentTtl, this.getTTL(optionsContext));
    }

    private Entity storeEntity(EntityKey key, Entity entity, AssociationContext associationContext) {
        Long currentTtl = this.connection.pttl((Object)this.entityId(key));
        this.entityStorageStrategy.storeEntity(this.entityId(key), entity, null);
        this.setEntityTTL(key, currentTtl, this.getTTL(associationContext));
        return entity;
    }

    public JsonEntityStorageStrategy getEntityStorageStrategy() {
        return this.entityStorageStrategy;
    }

    public List<Tuple> getTuples(EntityKey[] keys, TupleContext tupleContext) {
        if (keys.length == 0) {
            return Collections.emptyList();
        }
        String[] ids = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            ids[i] = this.entityId(keys[i]);
        }
        Iterable<Entity> entities = this.entityStorageStrategy.getEntities(ids);
        ArrayList<Tuple> tuples = new ArrayList<Tuple>(keys.length);
        int i = 0;
        for (Entity entity : entities) {
            if (entity != null) {
                EntityKey key = keys[i];
                this.addIdToEntity(entity, key.getColumnNames(), key.getColumnValues());
                tuples.add(new Tuple((TupleSnapshot)new RedisTupleSnapshot(entity.getProperties())));
            } else {
                tuples.add(null);
            }
            ++i;
        }
        return tuples;
    }
}

