/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.dialect.model.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.document.association.spi.AssociationRow;
import org.hibernate.ogm.datastore.document.association.spi.StructureOptimizerAssociationRowFactory;
import org.hibernate.ogm.datastore.document.impl.DotPatternMapHelpers;

public class RedisAssociationRowFactory
extends StructureOptimizerAssociationRowFactory<Map<String, Object>> {
    public static final RedisAssociationRowFactory INSTANCE = new RedisAssociationRowFactory();

    private RedisAssociationRowFactory() {
        super(Map.class);
    }

    protected Map<String, Object> getSingleColumnRow(String columnName, Object value) {
        return Collections.singletonMap(columnName, value);
    }

    protected AssociationRow.AssociationRowAccessor<Map<String, Object>> getAssociationRowAccessor(String[] prefixedColumns, String prefix) {
        return prefix != null ? new RedisAssociationRowAccessor(prefixedColumns, prefix) : RedisAssociationRowAccessor.INSTANCE;
    }

    private static class RedisAssociationRowAccessor
    implements AssociationRow.AssociationRowAccessor<Map<String, Object>> {
        private static final RedisAssociationRowAccessor INSTANCE = new RedisAssociationRowAccessor();
        private final String prefix;
        private final List<String> prefixedColumns;

        public RedisAssociationRowAccessor() {
            this(null, null);
        }

        public RedisAssociationRowAccessor(String[] prefixedColumns, String prefix) {
            this.prefix = prefix;
            this.prefixedColumns = prefix != null ? Arrays.asList(prefixedColumns) : Collections.emptyList();
        }

        private String unprefix(String prefixedColumn) {
            return prefixedColumn.substring(this.prefix.length() + 1);
        }

        public Set<String> getColumnNames(Map<String, Object> row) {
            HashSet<String> columnNames = new HashSet<String>(row.keySet());
            this.addColumnNames(row, columnNames, "");
            for (String prefixedColumn : this.prefixedColumns) {
                String unprefixedColumn = this.unprefix(prefixedColumn);
                if (!columnNames.contains(unprefixedColumn)) continue;
                columnNames.remove(unprefixedColumn);
                columnNames.add(prefixedColumn);
            }
            return columnNames;
        }

        private void addColumnNames(Map<String, Object> row, Set<String> columnNames, String prefix) {
            for (String field : row.keySet()) {
                Object sub = row.get(field);
                if (sub instanceof Map) {
                    this.addColumnNames((Map)sub, columnNames, DotPatternMapHelpers.flatten((String)prefix, (String)field));
                    continue;
                }
                columnNames.add(DotPatternMapHelpers.flatten((String)prefix, (String)field));
            }
        }

        public Object get(Map<String, Object> row, String column) {
            if (this.prefixedColumns.contains(column)) {
                column = this.unprefix(column);
            }
            if (row.containsKey(column)) {
                return row.get(column);
            }
            return DotPatternMapHelpers.getValueOrNull(row, (String)column);
        }
    }
}

