/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import org.hibernate.LockMode;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.community.dialect.TimesTenSqlAstTranslator;
import org.hibernate.community.dialect.pagination.TimesTenLimitHandler;
import org.hibernate.community.dialect.sequence.SequenceInformationExtractorTimesTenDatabaseImpl;
import org.hibernate.community.dialect.sequence.TimesTenSequenceSupport;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadUpdateLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteUpdateLockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.lock.UpdateLockingStrategy;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class TimesTenDialect
extends Dialect {
    public TimesTenDialect() {
        super((DatabaseVersion)SimpleDatabaseVersion.ZERO_VERSION);
    }

    public TimesTenDialect(DialectResolutionInfo info) {
        super(info);
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -6: 
            case 16: {
                return "tt_tinyint";
            }
            case 5: {
                return "tt_smallint";
            }
            case 4: {
                return "tt_integer";
            }
            case -5: {
                return "tt_bigint";
            }
            case 2: 
            case 3: {
                return "number($p,$s)";
            }
            case 91: {
                return "tt_date";
            }
            case 92: {
                return "tt_time";
            }
            case 2014: {
                return "timestamp($p)";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    public int getDefaultStatementBatchSize() {
        return 15;
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        if (jdbcTypeCode == -7) {
            return jdbcTypeRegistry.getDescriptor(16);
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    public int getDefaultDecimalPrecision() {
        return 40;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.trim2();
        functionFactory.soundex();
        functionFactory.trunc();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.ceiling_ceil();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.substring_substr();
        functionFactory.leftRight_substr();
        functionFactory.char_chr();
        functionFactory.rownumRowid();
        functionFactory.sysdate();
        functionFactory.addMonths();
        functionFactory.monthsBetween();
        functionContributions.getFunctionRegistry().registerBinaryTernaryPattern("locate", functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER), "instr(?2,?1)", "instr(?2,?1,?3)", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, functionContributions.getTypeConfiguration()).setArgumentListSignature("(pattern, string[, start])");
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new TimesTenSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "timestampadd(sql_tsi_frac_second,?2,?3)";
            }
        }
        return "timestampadd(sql_tsi_?1,?2,?3)";
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "timestampdiff(sql_tsi_frac_second,?2,?3)";
            }
        }
        return "timestampdiff(sql_tsi_?1,?2,?3)";
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public String getAddColumnString() {
        return "add";
    }

    public SequenceSupport getSequenceSupport() {
        return TimesTenSequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return "select name from sys.sequences";
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorTimesTenDatabaseImpl.INSTANCE;
    }

    public boolean supportsNoWait() {
        return true;
    }

    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.COLUMN;
    }

    public String getForUpdateString(String aliases) {
        return " for update of " + aliases;
    }

    public String getForUpdateNowaitString() {
        return " for update nowait";
    }

    public String getWriteLockString(int timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    public String getWriteLockString(String aliases, int timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    public String getReadLockString(int timeout) {
        return this.getWriteLockString(timeout);
    }

    public String getReadLockString(String aliases, int timeout) {
        return this.getWriteLockString(aliases, timeout);
    }

    private String withTimeout(String lockString, int timeout) {
        switch (timeout) {
            case 0: {
                return this.supportsNoWait() ? lockString + " nowait" : lockString;
            }
            case -2: 
            case -1: {
                return lockString;
            }
        }
        return this.supportsWait() ? lockString + " wait " + Math.round((float)timeout / 1000.0f) : lockString;
    }

    public boolean supportsColumnCheck() {
        return false;
    }

    public boolean supportsTableCheck() {
        return false;
    }

    public boolean supportsOffsetInSubquery() {
        return true;
    }

    public LimitHandler getLimitHandler() {
        return TimesTenLimitHandler.INSTANCE;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getCurrentTimestampSelectString() {
        return "select sysdate from sys.dual";
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableMutationStrategy(TemporaryTable.createIdTable((EntityMappingType)rootEntityDescriptor, name -> "HT_" + name, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable((EntityMappingType)rootEntityDescriptor, name -> "HTE_" + name, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.GLOBAL;
    }

    public String getTemporaryTableCreateOptions() {
        return "on commit delete rows";
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        switch (lockMode) {
            case OPTIMISTIC: {
                return new OptimisticLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC_FORCE_INCREMENT: {
                return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_READ: {
                return new PessimisticReadUpdateLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_WRITE: {
                return new PessimisticWriteUpdateLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_FORCE_INCREMENT: {
                return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
        }
        if (lockMode.greaterThan(LockMode.READ)) {
            return new UpdateLockingStrategy(lockable, lockMode);
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }

    public int getMaxAliasLength() {
        return 20;
    }

    public int getMaxIdentifierLength() {
        return 30;
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        switch (sqlType) {
            case 1: 
            case 12: {
                return "to_char(null)";
            }
            case 91: 
            case 92: 
            case 93: 
            case 2014: {
                return "to_date(null)";
            }
        }
        return "to_number(null)";
    }
}

