/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.hibernate.envers.boot.model.AttributeContainer;
import org.hibernate.envers.boot.registry.classloading.ClassLoaderAccessHelper;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.internal.metadata.AbstractMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.EntityMappingData;
import org.hibernate.envers.configuration.internal.metadata.ValueMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.reader.ComponentAuditingData;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.mapper.CompositeMapperBuilder;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.internal.EmbeddableCompositeUserTypeInstantiator;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorPojoIndirecting;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.usertype.CompositeUserType;

public final class ComponentMetadataGenerator
extends AbstractMetadataGenerator {
    private final ValueMetadataGenerator valueGenerator;

    ComponentMetadataGenerator(EnversMetadataBuildingContext metadataBuildingContext, ValueMetadataGenerator valueGenerator) {
        super(metadataBuildingContext);
        this.valueGenerator = valueGenerator;
    }

    public void addComponent(AttributeContainer attributeContainer, PropertyAuditingData propertyAuditingData, Value value, CompositeMapperBuilder mapper, String entityName, EntityMappingData mappingData, boolean firstPass) {
        Object instantiator;
        Component propComponent = (Component)value;
        if (propComponent.getCustomInstantiator() != null) {
            instantiator = !this.getMetadataBuildingContext().getBuildingOptions().isAllowExtensionsInCdi() ? (EmbeddableInstantiator)FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(propComponent.getCustomInstantiator()) : (EmbeddableInstantiator)this.getMetadataBuildingContext().getBootstrapContext().getManagedBeanRegistry().getBean(propComponent.getCustomInstantiator()).getBeanInstance();
        } else if (propComponent.getTypeName() != null) {
            Class userTypeClass = this.getMetadataBuildingContext().getBootstrapContext().getClassLoaderAccess().classForName(propComponent.getTypeName());
            if (!this.getMetadataBuildingContext().getBuildingOptions().isAllowExtensionsInCdi()) {
                compositeUserType = (CompositeUserType)FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(userTypeClass);
                instantiator = new EmbeddableCompositeUserTypeInstantiator(compositeUserType);
            } else {
                compositeUserType = (CompositeUserType)this.getMetadataBuildingContext().getBootstrapContext().getManagedBeanRegistry().getBean(userTypeClass).getBeanInstance();
                instantiator = new EmbeddableCompositeUserTypeInstantiator(compositeUserType);
            }
        } else {
            instantiator = propComponent.getInstantiator() != null ? EmbeddableInstantiatorPojoIndirecting.of((String[])propComponent.getPropertyNames(), (Constructor)propComponent.getInstantiator(), (String[])propComponent.getInstantiatorPropertyNames()) : null;
        }
        CompositeMapperBuilder componentMapper = mapper.addComponent(propertyAuditingData.resolvePropertyData(), ClassLoaderAccessHelper.loadClass(this.getMetadataBuildingContext(), this.getClassNameForComponent(propComponent)), (EmbeddableInstantiator)instantiator);
        ComponentAuditingData componentAuditingData = (ComponentAuditingData)propertyAuditingData;
        propComponent.sortProperties();
        for (Property property : propComponent.getProperties()) {
            PropertyAuditingData componentPropertyAuditingData = componentAuditingData.getPropertyAuditingData(property.getName());
            if (componentPropertyAuditingData == null) continue;
            this.valueGenerator.addValue(attributeContainer, property.getValue(), property.getPropertyAccessStrategy(), componentMapper, entityName, mappingData, componentPropertyAuditingData, property.isInsertable(), firstPass, false);
        }
        if (!firstPass) {
            EntityConfiguration owningEntityConfiguration = this.getAuditedEntityConfigurations().get(entityName);
            owningEntityConfiguration.addToOneComponent(propertyAuditingData.getName(), componentAuditingData);
        }
    }

    private String getClassNameForComponent(Component component) {
        return component.isDynamic() ? Map.class.getCanonicalName() : component.getComponentClassName();
    }
}

