/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.service.ServiceRegistry;

public abstract class AbstractMapper {
    protected <T> T getValueFromObject(PropertyData propertyData, Object object, ServiceRegistry serviceRegistry) {
        Getter getter = ReflectionTools.getGetter(object.getClass(), propertyData, serviceRegistry);
        return (T)getter.get(object);
    }

    protected <T> T getValueFromObject(String propertyName, String accessType, Object object, ServiceRegistry serviceRegistry) {
        Getter getter = ReflectionTools.getGetter(object.getClass(), propertyName, accessType, serviceRegistry);
        return (T)getter.get(object);
    }

    protected void setValueOnObject(PropertyData propertyData, Object object, Object value, ServiceRegistry serviceRegistry) {
        Setter setter = ReflectionTools.getSetter(object.getClass(), propertyData, serviceRegistry);
        setter.set(object, value);
    }

    protected void getAndSetValue(PropertyData propertyData, Object source, Object destination, ServiceRegistry serviceRegistry) {
        Getter getter = ReflectionTools.getGetter(source.getClass(), propertyData, serviceRegistry);
        Setter setter = ReflectionTools.getSetter(destination.getClass(), propertyData, serviceRegistry);
        setter.set(destination, getter.get(source));
    }

    protected <T> T newObjectInstance(Class<T> clazz, Object ... args) {
        try {
            Constructor constructor = ReflectHelper.getDefaultConstructor(clazz);
            if (constructor == null) {
                throw new AuditException("Failed to locate default constructor for class: " + clazz.getName());
            }
            return constructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new AuditException(e);
        }
    }
}

