/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata.reader;

import jakarta.persistence.ElementCollection;
import jakarta.persistence.Lob;
import jakarta.persistence.MapKey;
import jakarta.persistence.MapKeyEnumerated;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.AuditMappedBy;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.envers.CollectionAuditTable;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.RelationTargetNotFoundAction;
import org.hibernate.envers.boot.EnversMappingException;
import org.hibernate.envers.boot.internal.ModifiedColumnNameResolver;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.internal.ModelsHelper;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditJoinTableData;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditOverrideData;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditedPropertiesHolder;
import org.hibernate.envers.configuration.internal.metadata.reader.ComponentAuditedPropertiesReader;
import org.hibernate.envers.configuration.internal.metadata.reader.ComponentAuditingData;
import org.hibernate.envers.configuration.internal.metadata.reader.PersistentPropertiesSource;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.tools.MappingTools;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.envers.internal.tools.Tools;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.ModelsContext;

public class AuditedPropertiesReader {
    private static final AuditJoinTableData DEFAULT_AUDIT_JOIN_TABLE = new AuditJoinTableData();
    public static final String NO_PREFIX = "";
    private final PersistentPropertiesSource persistentPropertiesSource;
    private final AuditedPropertiesHolder auditedPropertiesHolder;
    private final EnversMetadataBuildingContext metadataBuildingContext;
    private final String propertyNamePrefix;
    private final Map<String, String> propertyAccessedPersistentProperties;
    private final Set<String> fieldAccessedPersistentProperties;
    private final Map<String, String> propertiesGroupMapping;
    private final Set<MemberDetails> overriddenAuditedProperties;
    private final Set<MemberDetails> overriddenNotAuditedProperties;
    private final Map<MemberDetails, AuditJoinTable> overriddenAuditedPropertiesJoinTables;
    private final Set<ClassDetails> overriddenAuditedClasses;
    private final Set<ClassDetails> overriddenNotAuditedClasses;
    private static final Audited DEFAULT_AUDITED = new Audited(){

        @Override
        public RelationTargetAuditMode targetAuditMode() {
            return RelationTargetAuditMode.AUDITED;
        }

        @Override
        public RelationTargetNotFoundAction targetNotFoundAction() {
            return RelationTargetNotFoundAction.DEFAULT;
        }

        @Override
        public Class[] auditParents() {
            return new Class[0];
        }

        @Override
        public boolean withModifiedFlag() {
            return false;
        }

        @Override
        public String modifiedColumnName() {
            return AuditedPropertiesReader.NO_PREFIX;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.getClass();
        }
    };

    public AuditedPropertiesReader(EnversMetadataBuildingContext metadataBuildingContext, PersistentPropertiesSource persistentPropertiesSource, AuditedPropertiesHolder auditedPropertiesHolder) {
        this(metadataBuildingContext, persistentPropertiesSource, auditedPropertiesHolder, NO_PREFIX);
    }

    public AuditedPropertiesReader(EnversMetadataBuildingContext metadataBuildingContext, PersistentPropertiesSource persistentPropertiesSource, AuditedPropertiesHolder auditedPropertiesHolder, String propertyNamePrefix) {
        this.persistentPropertiesSource = persistentPropertiesSource;
        this.auditedPropertiesHolder = auditedPropertiesHolder;
        this.metadataBuildingContext = metadataBuildingContext;
        this.propertyNamePrefix = propertyNamePrefix;
        this.propertyAccessedPersistentProperties = Tools.newHashMap();
        this.fieldAccessedPersistentProperties = Tools.newHashSet();
        this.propertiesGroupMapping = Tools.newHashMap();
        this.overriddenAuditedProperties = Tools.newHashSet();
        this.overriddenNotAuditedProperties = Tools.newHashSet();
        this.overriddenAuditedPropertiesJoinTables = Tools.newHashMap();
        this.overriddenAuditedClasses = Tools.newHashSet();
        this.overriddenNotAuditedClasses = Tools.newHashSet();
    }

    public void read() {
        this.read(null);
    }

    public void read(Audited allClassAudited) {
        this.readPersistentPropertiesAccess();
        if (this.persistentPropertiesSource.isDynamicComponent()) {
            this.addPropertiesFromDynamicComponent(this.persistentPropertiesSource);
        } else {
            ClassDetails classDetails = this.persistentPropertiesSource.getClassDetails();
            if (this.persistentPropertiesSource.hasCompositeUserType()) {
                Value propertyValue;
                Property property;
                for (String propertyName : this.fieldAccessedPersistentProperties) {
                    property = this.persistentPropertiesSource.getProperty(propertyName);
                    propertyValue = property.getValue();
                    if (propertyValue instanceof Component) {
                        this.addFromComponentProperty(property, "field", (Component)propertyValue, allClassAudited);
                        continue;
                    }
                    this.addFromNotComponentProperty(property, "field", allClassAudited);
                }
                for (String propertyName : this.propertyAccessedPersistentProperties.keySet()) {
                    property = this.persistentPropertiesSource.getProperty(propertyName);
                    propertyValue = property.getValue();
                    if (propertyValue instanceof Component) {
                        this.addFromComponentProperty(property, "property", (Component)propertyValue, allClassAudited);
                        continue;
                    }
                    this.addFromNotComponentProperty(property, "property", allClassAudited);
                }
            } else {
                this.readAuditOverrides(classDetails);
                this.addPropertiesFromClass(classDetails);
            }
        }
    }

    private void readAuditOverrides(ClassDetails classDetails) {
        Audited allClassAudited = (Audited)classDetails.getDirectAnnotationUsage(Audited.class);
        if (allClassAudited != null && allClassAudited.auditParents().length > 0) {
            for (Class c : allClassAudited.auditParents()) {
                ClassDetails parentClass = this.metadataBuildingContext.getClassDetailsRegistry().resolveClassDetails(c.getName());
                this.checkSuperclass(classDetails, parentClass);
                if (this.overriddenNotAuditedClasses.contains(parentClass)) continue;
                this.overriddenAuditedClasses.add(parentClass);
            }
        }
        List<AuditOverride> auditOverrides = this.computeAuditOverrides(classDetails);
        for (AuditOverride auditOverride : auditOverrides) {
            if (auditOverride.forClass() == Void.TYPE) continue;
            ClassDetails overrideClass = this.metadataBuildingContext.getClassDetailsRegistry().resolveClassDetails(auditOverride.forClass().getName());
            this.checkSuperclass(classDetails, overrideClass);
            String propertyName = auditOverride.name();
            if (!StringTools.isEmpty(propertyName)) {
                MemberDetails property = this.getProperty(overrideClass, propertyName);
                if (auditOverride.isAudited()) {
                    if (this.overriddenNotAuditedProperties.contains(property)) continue;
                    this.overriddenAuditedProperties.add(property);
                    this.overriddenAuditedPropertiesJoinTables.put(property, auditOverride.auditJoinTable());
                    continue;
                }
                if (this.overriddenAuditedProperties.contains(property)) continue;
                this.overriddenNotAuditedProperties.add(property);
                continue;
            }
            if (auditOverride.isAudited()) {
                if (this.overriddenNotAuditedClasses.contains(overrideClass)) continue;
                this.overriddenAuditedClasses.add(overrideClass);
                continue;
            }
            if (this.overriddenAuditedClasses.contains(overrideClass)) continue;
            this.overriddenNotAuditedClasses.add(overrideClass);
        }
        ClassDetails superclass = classDetails.getSuperClass();
        if (!classDetails.isInterface() && !Object.class.getName().equals(superclass.getName())) {
            this.readAuditOverrides(superclass);
        }
    }

    private List<AuditOverride> computeAuditOverrides(ClassDetails classDetails) {
        AuditOverrides auditOverrides = (AuditOverrides)classDetails.getDirectAnnotationUsage(AuditOverrides.class);
        AuditOverride auditOverride = (AuditOverride)classDetails.getDirectAnnotationUsage(AuditOverride.class);
        if (auditOverrides == null && auditOverride != null) {
            return Arrays.asList(auditOverride);
        }
        if (auditOverrides != null && auditOverride == null) {
            return Arrays.asList(auditOverrides.value());
        }
        if (auditOverrides != null && auditOverride != null) {
            throw new EnversMappingException("@AuditOverrides annotation should encapsulate all @AuditOverride declarations. Please revise Envers annotations applied to class " + classDetails.getName() + ".");
        }
        return Collections.emptyList();
    }

    private void checkSuperclass(ClassDetails child, ClassDetails parent) {
        if (!child.isImplementor(parent.toJavaClass())) {
            throw new EnversMappingException("Class " + parent.getName() + " is not assignable from " + child.getName() + ". Please revise Envers annotations applied to " + child.getName() + " type.");
        }
    }

    private MemberDetails getProperty(ClassDetails classDetails, String propertyName) {
        MemberDetails member = ModelsHelper.getMember(classDetails, propertyName);
        if (member == null) {
            throw new EnversMappingException("Property '" + propertyName + "' not found in class " + classDetails.getName() + ". Please revise Envers annotations applied to class " + String.valueOf(this.persistentPropertiesSource.getClassDetails()) + ".");
        }
        return member;
    }

    private void readPersistentPropertiesAccess() {
        Iterator<Property> propertyIter = this.persistentPropertiesSource.getPropertyIterator();
        while (propertyIter.hasNext()) {
            Property property = propertyIter.next();
            this.addPersistentProperty(property);
            if (!"embedded".equals(property.getPropertyAccessorName()) || "_identifierMapper".equals(property.getName())) continue;
            this.createPropertiesGroupMapping(property);
        }
    }

    private void addPersistentProperty(Property property) {
        if ("field".equals(property.getPropertyAccessorName())) {
            this.fieldAccessedPersistentProperties.add(property.getName());
        } else {
            this.propertyAccessedPersistentProperties.put(property.getName(), property.getPropertyAccessorName());
        }
    }

    private void createPropertiesGroupMapping(Property property) {
        Component component = (Component)property.getValue();
        for (Property componentProperty : component.getProperties()) {
            this.propertiesGroupMapping.put(componentProperty.getName(), property.getName());
        }
    }

    private Audited computeAuditConfiguration(ClassDetails classDetails) {
        Audited allClassAudited = (Audited)classDetails.getDirectAnnotationUsage(Audited.class);
        if (allClassAudited == null && this.overriddenAuditedClasses.contains(classDetails)) {
            allClassAudited = (Audited)this.persistentPropertiesSource.getClassDetails().getDirectAnnotationUsage(Audited.class);
            if (allClassAudited == null) {
                allClassAudited = DEFAULT_AUDITED;
            }
        } else if (allClassAudited != null && this.overriddenNotAuditedClasses.contains(classDetails)) {
            return null;
        }
        return allClassAudited;
    }

    private void addPropertiesFromDynamicComponent(PersistentPropertiesSource propertiesSource) {
        Audited audited = this.computeAuditConfiguration(propertiesSource.getClassDetails());
        if (!this.fieldAccessedPersistentProperties.isEmpty()) {
            throw new EnversMappingException("Audited dynamic component cannot have properties with access=\"field\" for properties: " + String.valueOf(this.fieldAccessedPersistentProperties) + ". \n Change properties access=\"property\", to make it work)");
        }
        for (Map.Entry<String, String> entry : this.propertyAccessedPersistentProperties.entrySet()) {
            String property = entry.getKey();
            String accessType = entry.getValue();
            if (this.auditedPropertiesHolder.contains(property)) continue;
            Value propertyValue = this.persistentPropertiesSource.getProperty(property).getValue();
            ModelsContext modelsContext = this.metadataBuildingContext.getModelsContext();
            FieldDetails fieldDetails = ModelsHelper.dynamicFieldDetails(propertiesSource, property, modelsContext);
            if (propertyValue instanceof Component) {
                this.addFromComponentProperty((MemberDetails)fieldDetails, accessType, (Component)propertyValue, audited);
                continue;
            }
            this.addFromNotComponentProperty((MemberDetails)fieldDetails, accessType, audited);
        }
    }

    private void addPropertiesFromClass(ClassDetails classDetails) {
        Audited allClassAudited = this.computeAuditConfiguration(classDetails);
        classDetails.forEachField((i, field) -> this.addFromProperty((MemberDetails)field, it -> "field", this.fieldAccessedPersistentProperties, allClassAudited));
        classDetails.forEachMethod((i, method) -> this.addFromProperty((MemberDetails)method, this.propertyAccessedPersistentProperties::get, this.propertyAccessedPersistentProperties.keySet(), allClassAudited));
        if (this.isClassHierarchyTraversalNeeded(allClassAudited)) {
            ClassDetails superclass = classDetails.getSuperClass();
            if (!classDetails.isInterface() && !"java.lang.Object".equals(superclass.getName())) {
                this.addPropertiesFromClass(superclass);
            }
        }
    }

    protected boolean isClassHierarchyTraversalNeeded(Audited allClassAudited) {
        return allClassAudited != null || !this.auditedPropertiesHolder.isEmpty();
    }

    private void addFromProperty(MemberDetails memberDetails, Function<String, String> accessTypeProvider, Set<String> persistentProperties, Audited allClassAudited) {
        String embeddedName;
        if (!memberDetails.isPersistable() || memberDetails.hasDirectAnnotationUsage(Transient.class)) {
            return;
        }
        String attributeName = memberDetails.resolveAttributeName();
        String accessType = accessTypeProvider.apply(attributeName);
        if (persistentProperties.contains(attributeName) && !this.auditedPropertiesHolder.contains(attributeName)) {
            Value propertyValue = this.persistentPropertiesSource.getProperty(attributeName).getValue();
            if (propertyValue instanceof Component) {
                this.addFromComponentProperty(memberDetails, accessType, (Component)propertyValue, allClassAudited);
            } else {
                this.addFromNotComponentProperty(memberDetails, accessType, allClassAudited);
            }
        } else if (this.propertiesGroupMapping.containsKey(attributeName) && !this.auditedPropertiesHolder.contains(embeddedName = this.propertiesGroupMapping.get(attributeName))) {
            Value propertyValue = this.persistentPropertiesSource.getProperty(embeddedName).getValue();
            this.addFromPropertiesGroup(embeddedName, memberDetails, accessType, (Component)propertyValue, allClassAudited);
        }
    }

    private void addFromPropertiesGroup(String embeddedName, MemberDetails memberDetails, String accessType, Component propertyValue, Audited allClassAudited) {
        ComponentAuditingData componentData = new ComponentAuditingData();
        boolean isAudited = this.fillPropertyData(memberDetails, (PropertyAuditingData)componentData, accessType, allClassAudited);
        if (isAudited) {
            componentData.setName(embeddedName);
            componentData.setBeanName(null);
            PersistentPropertiesSource componentPropertiesSource = PersistentPropertiesSource.forComponent(this.metadataBuildingContext, propertyValue);
            AuditedPropertiesReader audPropReader = new AuditedPropertiesReader(this.metadataBuildingContext, componentPropertiesSource, componentData, this.propertyNamePrefix + MappingTools.createComponentPrefix(embeddedName));
            audPropReader.read();
            this.auditedPropertiesHolder.addPropertyAuditingData(embeddedName, componentData);
        }
    }

    private void addFromComponentProperty(MemberDetails memberDetails, String accessType, Component propertyValue, Audited allClassAudited) {
        PersistentPropertiesSource componentPropertiesSource;
        ComponentAuditingData componentData = new ComponentAuditingData();
        boolean isAudited = this.fillPropertyData(memberDetails, (PropertyAuditingData)componentData, accessType, allClassAudited);
        if (propertyValue.isDynamic()) {
            ClassDetails mapClassDetails = this.metadataBuildingContext.getClassDetailsRegistry().getClassDetails(Map.class.getName());
            componentPropertiesSource = PersistentPropertiesSource.forComponent(propertyValue, mapClassDetails, true);
        } else {
            componentPropertiesSource = PersistentPropertiesSource.forComponent(this.metadataBuildingContext, propertyValue);
        }
        ComponentAuditedPropertiesReader audPropReader = new ComponentAuditedPropertiesReader(this.metadataBuildingContext, componentPropertiesSource, componentData, this.propertyNamePrefix + MappingTools.createComponentPrefix(memberDetails.resolveAttributeName()));
        audPropReader.read(allClassAudited);
        if (isAudited) {
            this.auditedPropertiesHolder.addPropertyAuditingData(memberDetails.resolveAttributeName(), componentData);
        }
    }

    private void addFromNotComponentProperty(MemberDetails memberDetails, String accessType, Audited allClassAudited) {
        PropertyAuditingData propertyData = new PropertyAuditingData();
        boolean isAudited = this.fillPropertyData(memberDetails, propertyData, accessType, allClassAudited);
        if (isAudited) {
            this.auditedPropertiesHolder.addPropertyAuditingData(memberDetails.resolveAttributeName(), propertyData);
        }
    }

    private boolean fillPropertyData(MemberDetails memberDetails, PropertyAuditingData propertyData, String accessType, Audited allClassAudited) {
        String modifiedFlagsSuffix;
        Version jpaVer;
        NotAudited unVer = (NotAudited)memberDetails.getDirectAnnotationUsage(NotAudited.class);
        if (unVer != null && !this.overriddenAuditedProperties.contains(memberDetails) || this.overriddenNotAuditedProperties.contains(memberDetails)) {
            return false;
        }
        if (this.metadataBuildingContext.getConfiguration().isDoNotAuditOptimisticLockingField() && (jpaVer = (Version)memberDetails.getDirectAnnotationUsage(Version.class)) != null) {
            return false;
        }
        String propertyName = this.propertyNamePrefix + memberDetails.resolveAttributeName();
        if (!this.checkAudited(memberDetails, propertyData, propertyName, allClassAudited, modifiedFlagsSuffix = this.metadataBuildingContext.getConfiguration().getModifiedFlagsSuffix())) {
            return false;
        }
        this.validateLobMappingSupport(memberDetails);
        propertyData.setName(propertyName);
        propertyData.setBeanName(memberDetails.resolveAttributeName());
        propertyData.setAccessType(accessType);
        this.addPropertyJoinTables(memberDetails, propertyData);
        this.addPropertyCollectionAuditTable(memberDetails, propertyData);
        this.addPropertyAuditingOverrides(memberDetails, propertyData);
        if (!this.processPropertyAuditingOverrides(memberDetails, propertyData)) {
            return false;
        }
        this.addPropertyMapKey(memberDetails, propertyData);
        this.setPropertyAuditMappedBy(memberDetails, propertyData);
        this.setPropertyRelationMappedBy(memberDetails, propertyData);
        return true;
    }

    private void addFromComponentProperty(Property property, String accessType, Component propertyValue, Audited allClassAudited) {
        PersistentPropertiesSource componentPropertiesSource;
        ComponentAuditingData componentData = new ComponentAuditingData();
        boolean isAudited = this.fillPropertyData(property, (PropertyAuditingData)componentData, accessType, allClassAudited);
        if (propertyValue.isDynamic()) {
            ClassDetails mapClassDetails = this.metadataBuildingContext.getClassDetailsRegistry().getClassDetails(Map.class.getName());
            componentPropertiesSource = PersistentPropertiesSource.forComponent(propertyValue, mapClassDetails, true);
        } else {
            componentPropertiesSource = PersistentPropertiesSource.forComponent(this.metadataBuildingContext, propertyValue);
        }
        ComponentAuditedPropertiesReader audPropReader = new ComponentAuditedPropertiesReader(this.metadataBuildingContext, componentPropertiesSource, componentData, this.propertyNamePrefix + MappingTools.createComponentPrefix(property.getName()));
        audPropReader.read(allClassAudited);
        if (isAudited) {
            this.auditedPropertiesHolder.addPropertyAuditingData(property.getName(), componentData);
        }
    }

    private void addFromNotComponentProperty(Property property, String accessType, Audited allClassAudited) {
        PropertyAuditingData propertyData = new PropertyAuditingData();
        boolean isAudited = this.fillPropertyData(property, propertyData, accessType, allClassAudited);
        if (isAudited) {
            this.auditedPropertiesHolder.addPropertyAuditingData(property.getName(), propertyData);
        }
    }

    private boolean fillPropertyData(Property property, PropertyAuditingData propertyData, String accessType, Audited allClassAudited) {
        String modifiedFlagsSuffix;
        String propertyName = this.propertyNamePrefix + property.getName();
        if (!this.checkAudited(property, propertyData, propertyName, allClassAudited, modifiedFlagsSuffix = this.metadataBuildingContext.getConfiguration().getModifiedFlagsSuffix())) {
            return false;
        }
        propertyData.setName(propertyName);
        propertyData.setBeanName(property.getName());
        propertyData.setAccessType(accessType);
        propertyData.setJoinTable(DEFAULT_AUDIT_JOIN_TABLE);
        return this.processPropertyAuditingOverrides(property, propertyData);
    }

    private void validateLobMappingSupport(MemberDetails memberDetails) {
        try {
            if (memberDetails.hasDirectAnnotationUsage(ElementCollection.class) && memberDetails.hasDirectAnnotationUsage(Lob.class) && !memberDetails.getType().isImplementor(Map.class)) {
                throw new EnversMappingException("@ElementCollection combined with @Lob is only supported for Map collection types.");
            }
        }
        catch (EnversMappingException e) {
            throw new HibernateException(String.format(Locale.ENGLISH, "Invalid mapping in [%s] for property [%s]", memberDetails.getDeclaringType().getName(), memberDetails.resolveAttributeName()), (Throwable)((Object)e));
        }
    }

    protected boolean checkAudited(MemberDetails memberDetails, PropertyAuditingData propertyData, String propertyName, Audited allClassAudited, String modifiedFlagSuffix) {
        Audited aud;
        Audited audited = aud = memberDetails.hasDirectAnnotationUsage(Audited.class) ? (Audited)memberDetails.getDirectAnnotationUsage(Audited.class) : allClassAudited;
        if (aud == null && this.overriddenAuditedProperties.contains(memberDetails) && !this.overriddenNotAuditedProperties.contains(memberDetails)) {
            aud = DEFAULT_AUDITED;
        }
        if (aud != null) {
            propertyData.setRelationTargetAuditMode(aud.targetAuditMode());
            propertyData.setRelationTargetNotFoundAction(this.getRelationNotFoundAction(memberDetails, allClassAudited));
            propertyData.setUsingModifiedFlag(this.checkUsingModifiedFlag(aud));
            propertyData.setModifiedFlagName(ModifiedColumnNameResolver.getName(propertyName, modifiedFlagSuffix));
            if (!StringTools.isEmpty(aud.modifiedColumnName())) {
                propertyData.setExplicitModifiedFlagName(aud.modifiedColumnName());
            }
            return true;
        }
        return false;
    }

    protected boolean checkAudited(Property property, PropertyAuditingData propertyData, String propertyName, Audited allClassAudited, String modifiedFlagSuffix) {
        if (allClassAudited != null) {
            propertyData.setRelationTargetAuditMode(allClassAudited.targetAuditMode());
            propertyData.setRelationTargetNotFoundAction(allClassAudited == null ? RelationTargetNotFoundAction.DEFAULT : allClassAudited.targetNotFoundAction());
            propertyData.setUsingModifiedFlag(this.checkUsingModifiedFlag(allClassAudited));
            propertyData.setModifiedFlagName(ModifiedColumnNameResolver.getName(propertyName, modifiedFlagSuffix));
            if (!StringTools.isEmpty(allClassAudited.modifiedColumnName())) {
                propertyData.setExplicitModifiedFlagName(allClassAudited.modifiedColumnName());
            }
            return true;
        }
        return false;
    }

    protected boolean checkUsingModifiedFlag(Audited aud) {
        if (this.metadataBuildingContext.getConfiguration().hasSettingForUseModifiedFlag()) {
            return this.metadataBuildingContext.getConfiguration().isModifiedFlagsEnabled() || aud.withModifiedFlag();
        }
        return aud.withModifiedFlag();
    }

    private void setPropertyRelationMappedBy(MemberDetails memberDetails, PropertyAuditingData propertyData) {
        OneToMany oneToMany = (OneToMany)memberDetails.getDirectAnnotationUsage(OneToMany.class);
        if (oneToMany != null && StringHelper.isNotEmpty((String)oneToMany.mappedBy())) {
            propertyData.setRelationMappedBy(oneToMany.mappedBy());
        }
    }

    private void setPropertyAuditMappedBy(MemberDetails memberDetails, PropertyAuditingData propertyData) {
        AuditMappedBy auditMappedBy = (AuditMappedBy)memberDetails.getDirectAnnotationUsage(AuditMappedBy.class);
        if (auditMappedBy != null) {
            propertyData.setAuditMappedBy(auditMappedBy.mappedBy());
            if (StringHelper.isNotEmpty((String)auditMappedBy.positionMappedBy())) {
                propertyData.setPositionMappedBy(auditMappedBy.positionMappedBy());
            }
        }
    }

    private void addPropertyMapKey(MemberDetails memberDetails, PropertyAuditingData propertyData) {
        MapKey mapKey = (MapKey)memberDetails.getDirectAnnotationUsage(MapKey.class);
        if (mapKey != null) {
            propertyData.setMapKey(mapKey.name());
        } else {
            MapKeyEnumerated mapKeyEnumerated = (MapKeyEnumerated)memberDetails.getDirectAnnotationUsage(MapKeyEnumerated.class);
            if (mapKeyEnumerated != null) {
                propertyData.setMapKeyEnumType(mapKeyEnumerated.value());
            }
        }
    }

    private void addPropertyJoinTables(MemberDetails memberDetails, PropertyAuditingData propertyData) {
        AuditJoinTable overrideJoinTable = this.overriddenAuditedPropertiesJoinTables.get(memberDetails);
        if (overrideJoinTable != null) {
            propertyData.setJoinTable(new AuditJoinTableData(overrideJoinTable));
        } else {
            AuditJoinTable propertyJoinTable = (AuditJoinTable)memberDetails.getDirectAnnotationUsage(AuditJoinTable.class);
            if (propertyJoinTable != null) {
                propertyData.setJoinTable(new AuditJoinTableData(propertyJoinTable));
            } else {
                propertyData.setJoinTable(DEFAULT_AUDIT_JOIN_TABLE);
            }
        }
    }

    private void addPropertyCollectionAuditTable(MemberDetails memberDetails, PropertyAuditingData propertyAuditingData) {
        CollectionAuditTable collectionAuditTableAnn = (CollectionAuditTable)memberDetails.getDirectAnnotationUsage(CollectionAuditTable.class);
        if (collectionAuditTableAnn != null) {
            propertyAuditingData.setCollectionAuditTable(collectionAuditTableAnn);
        }
    }

    private void addPropertyAuditingOverrides(MemberDetails memberDetails, PropertyAuditingData propertyData) {
        AuditOverrides annotationOverrides;
        AuditOverride annotationOverride = (AuditOverride)memberDetails.getDirectAnnotationUsage(AuditOverride.class);
        if (annotationOverride != null) {
            propertyData.addAuditingOverride(annotationOverride);
        }
        if ((annotationOverrides = (AuditOverrides)memberDetails.getDirectAnnotationUsage(AuditOverrides.class)) != null) {
            propertyData.addAuditingOverrides(annotationOverrides);
        }
    }

    private boolean processPropertyAuditingOverrides(MemberDetails memberDetails, PropertyAuditingData propertyData) {
        for (AuditOverrideData override : this.auditedPropertiesHolder.getAuditingOverrides()) {
            if (!memberDetails.resolveAttributeName().equals(override.getName())) continue;
            if (!override.isAudited()) {
                return false;
            }
            if (override.getAuditJoinTableData() == null) continue;
            propertyData.setJoinTable(override.getAuditJoinTableData());
        }
        return true;
    }

    private boolean processPropertyAuditingOverrides(Property property, PropertyAuditingData propertyData) {
        for (AuditOverrideData override : this.auditedPropertiesHolder.getAuditingOverrides()) {
            if (!property.getName().equals(override.getName())) continue;
            if (!override.isAudited()) {
                return false;
            }
            if (override.getAuditJoinTableData() == null) continue;
            propertyData.setJoinTable(override.getAuditJoinTableData());
        }
        return true;
    }

    protected boolean isOverriddenNotAudited(MemberDetails memberDetails) {
        return this.overriddenNotAuditedProperties.contains(memberDetails);
    }

    protected boolean isOverriddenNotAudited(ClassDetails classDetails) {
        return this.overriddenNotAuditedClasses.contains(classDetails);
    }

    protected boolean isOverriddenAudited(MemberDetails memberDetails) {
        return this.overriddenAuditedProperties.contains(memberDetails);
    }

    protected boolean isOverriddenAudited(ClassDetails classDetails) {
        return this.overriddenAuditedClasses.contains(classDetails);
    }

    private RelationTargetNotFoundAction getRelationNotFoundAction(MemberDetails memberDetails, Audited classAudited) {
        Audited propertyAudited = (Audited)memberDetails.getDirectAnnotationUsage(Audited.class);
        if (classAudited == null) {
            if (propertyAudited == null) {
                return RelationTargetNotFoundAction.DEFAULT;
            }
            return propertyAudited.targetNotFoundAction();
        }
        RelationTargetNotFoundAction action = classAudited.targetNotFoundAction();
        if (propertyAudited != null && !propertyAudited.targetNotFoundAction().equals((Object)RelationTargetNotFoundAction.DEFAULT)) {
            action = propertyAudited.targetNotFoundAction();
        }
        return action;
    }
}

