/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.hibernate.jpamodelgen.model.MetaEntity;
import org.hibernate.jpamodelgen.util.AccessType;
import org.hibernate.jpamodelgen.util.AccessTypeInformation;

public final class Context {
    private static final String DEFAULT_PERSISTENCE_XML_LOCATION = "/META-INF/persistence.xml";
    private final Map<String, MetaEntity> metaEntities = new HashMap<String, MetaEntity>();
    private final Map<String, MetaEntity> metaEmbeddables = new HashMap<String, MetaEntity>();
    private final Map<String, AccessTypeInformation> accessTypeInformation = new HashMap<String, AccessTypeInformation>();
    private final ProcessingEnvironment pe;
    private final boolean logDebug;
    private final boolean lazyXmlParsing;
    private final String persistenceXmlLocation;
    private final List<String> ormXmlFiles;
    private final String generatedAnnotation;
    private Boolean fullyXmlConfigured;
    private boolean addGeneratedAnnotation = true;
    private boolean addGenerationDate;
    private boolean addSuppressWarningsAnnotation;
    private AccessType persistenceUnitDefaultAccessType;
    private final Collection<String> generatedModelClasses = new HashSet<String>();

    /*
     * WARNING - void declaration
     */
    public Context(ProcessingEnvironment pe) {
        Object tmp;
        this.pe = pe;
        if (pe.getOptions().get("persistenceXml") != null) {
            tmp = pe.getOptions().get("persistenceXml");
            if (!((String)tmp).startsWith("/")) {
                tmp = "/" + (String)tmp;
            }
            this.persistenceXmlLocation = tmp;
        } else {
            this.persistenceXmlLocation = DEFAULT_PERSISTENCE_XML_LOCATION;
        }
        if (pe.getOptions().get("ormXml") != null) {
            tmp = pe.getOptions().get("ormXml");
            this.ormXmlFiles = new ArrayList<String>();
            for (String string : ((String)tmp).split(",")) {
                void var6_6;
                if (!string.startsWith("/")) {
                    String string2 = "/" + string;
                }
                this.ormXmlFiles.add((String)var6_6);
            }
        } else {
            this.ormXmlFiles = Collections.emptyList();
        }
        this.lazyXmlParsing = Boolean.parseBoolean(pe.getOptions().get("lazyXmlParsing"));
        this.logDebug = Boolean.parseBoolean(pe.getOptions().get("debug"));
        String j = "j";
        TypeElement java8AndBelowGeneratedAnnotation = pe.getElementUtils().getTypeElement(j + "avax.annotation.Generated");
        this.generatedAnnotation = java8AndBelowGeneratedAnnotation != null ? java8AndBelowGeneratedAnnotation.getQualifiedName().toString() : "javax.annotation.processing.Generated";
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.pe;
    }

    public boolean addGeneratedAnnotation() {
        return this.addGeneratedAnnotation;
    }

    public String getGeneratedAnnotationFqcn() {
        return this.generatedAnnotation;
    }

    public void setAddGeneratedAnnotation(boolean addGeneratedAnnotation) {
        this.addGeneratedAnnotation = addGeneratedAnnotation;
    }

    public boolean addGeneratedDate() {
        return this.addGenerationDate;
    }

    public void setAddGenerationDate(boolean addGenerationDate) {
        this.addGenerationDate = addGenerationDate;
    }

    public boolean isAddSuppressWarningsAnnotation() {
        return this.addSuppressWarningsAnnotation;
    }

    public void setAddSuppressWarningsAnnotation(boolean addSuppressWarningsAnnotation) {
        this.addSuppressWarningsAnnotation = addSuppressWarningsAnnotation;
    }

    public Elements getElementUtils() {
        return this.pe.getElementUtils();
    }

    public Types getTypeUtils() {
        return this.pe.getTypeUtils();
    }

    public String getPersistenceXmlLocation() {
        return this.persistenceXmlLocation;
    }

    public List<String> getOrmXmlFiles() {
        return this.ormXmlFiles;
    }

    public boolean containsMetaEntity(String fqcn) {
        return this.metaEntities.containsKey(fqcn);
    }

    public MetaEntity getMetaEntity(String fqcn) {
        return this.metaEntities.get(fqcn);
    }

    public Collection<MetaEntity> getMetaEntities() {
        return this.metaEntities.values();
    }

    public void addMetaEntity(String fqcn, MetaEntity metaEntity) {
        this.metaEntities.put(fqcn, metaEntity);
    }

    public boolean containsMetaEmbeddable(String fqcn) {
        return this.metaEmbeddables.containsKey(fqcn);
    }

    public MetaEntity getMetaEmbeddable(String fqcn) {
        return this.metaEmbeddables.get(fqcn);
    }

    public void addMetaEmbeddable(String fqcn, MetaEntity metaEntity) {
        this.metaEmbeddables.put(fqcn, metaEntity);
    }

    public Collection<MetaEntity> getMetaEmbeddables() {
        return this.metaEmbeddables.values();
    }

    public void addAccessTypeInformation(String fqcn, AccessTypeInformation info) {
        this.accessTypeInformation.put(fqcn, info);
    }

    public AccessTypeInformation getAccessTypeInfo(String fqcn) {
        return this.accessTypeInformation.get(fqcn);
    }

    public TypeElement getTypeElementForFullyQualifiedName(String fqcn) {
        Elements elementUtils = this.pe.getElementUtils();
        return elementUtils.getTypeElement(fqcn);
    }

    void markGenerated(String name) {
        this.generatedModelClasses.add(name);
    }

    boolean isAlreadyGenerated(String name) {
        return this.generatedModelClasses.contains(name);
    }

    public void logMessage(Diagnostic.Kind type, String message) {
        if (!this.logDebug && type.equals((Object)Diagnostic.Kind.OTHER)) {
            return;
        }
        this.pe.getMessager().printMessage(type, message);
    }

    public boolean isFullyXmlConfigured() {
        return this.fullyXmlConfigured != null && this.fullyXmlConfigured != false;
    }

    public void mappingDocumentFullyXmlConfigured(boolean fullyXmlConfigured) {
        this.fullyXmlConfigured = this.fullyXmlConfigured == null ? Boolean.valueOf(fullyXmlConfigured) : Boolean.valueOf(this.fullyXmlConfigured != false && fullyXmlConfigured);
    }

    public AccessType getPersistenceUnitDefaultAccessType() {
        return this.persistenceUnitDefaultAccessType;
    }

    public void setPersistenceUnitDefaultAccessType(AccessType persistenceUnitDefaultAccessType) {
        this.persistenceUnitDefaultAccessType = persistenceUnitDefaultAccessType;
    }

    public boolean doLazyXmlParsing() {
        return this.lazyXmlParsing;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Context");
        sb.append("{accessTypeInformation=").append(this.accessTypeInformation);
        sb.append(", logDebug=").append(this.logDebug);
        sb.append(", lazyXmlParsing=").append(this.lazyXmlParsing);
        sb.append(", fullyXmlConfigured=").append(this.fullyXmlConfigured);
        sb.append(", ormXmlFiles=").append(this.ormXmlFiles);
        sb.append(", persistenceXmlLocation='").append(this.persistenceXmlLocation).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

