/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.db2;

import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.db.db2.Db2ClobDecoder;
import org.geolatte.geom.codec.db.db2.Db2ClobEncoder;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class DB2GeometryType
implements JdbcType {
    private final Integer srid;

    public DB2GeometryType(Integer srid) {
        this.srid = srid;
    }

    public int getJdbcTypeCode() {
        return 2005;
    }

    public int getDefaultSqlTypeCode() {
        return 3200;
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, this.toText(value, options));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, (Object)this.toText(value, options));
            }

            private String toText(X value, WrapperOptions options) {
                Geometry geometry = (Geometry)this.getJavaType().unwrap(value, Geometry.class, options);
                Db2ClobEncoder encoder = new Db2ClobEncoder();
                String encoded = encoder.encode(geometry);
                return encoded;
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(DB2GeometryType.this.toGeometry(rs.getObject(paramIndex)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(DB2GeometryType.this.toGeometry(statement.getObject(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(DB2GeometryType.this.toGeometry(statement.getObject(name)), options);
            }
        };
    }

    public Geometry<?> toGeometry(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Clob) {
            Db2ClobDecoder decoder = new Db2ClobDecoder(this.srid);
            return decoder.decode((Clob)object);
        }
        throw new IllegalStateException("Object of type " + object.getClass().getCanonicalName() + " not handled by DB2 as spatial value");
    }
}

