/*
 * Decompiled with CFR 0.152.
 */
package org.hibersap.ejb.interceptor;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibersap.HibersapException;
import org.hibersap.ejb.util.ReflectionUtil;
import org.hibersap.session.Session;
import org.hibersap.session.SessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibersapSessionInterceptor {
    private static final String HIBERSAP_SESSION_PREFIX = "hibersap.session.";
    private static final Log LOGGER = LogFactory.getLog(HibersapSessionInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object injectSessionsIntoEjb(InvocationContext ctx) throws Exception {
        Set<Field> sessionFields = ReflectionUtil.getHibersapSessionFields(ctx.getTarget());
        HashMap<Session, String> sessionsCreated = new HashMap<Session, String>();
        try {
            for (Field sessionField : sessionFields) {
                String jndiName = ReflectionUtil.getSessionManagerJndiName(sessionField);
                String key = HIBERSAP_SESSION_PREFIX + jndiName;
                Session session = (Session)ctx.getContextData().get(key);
                if (session == null) {
                    LOGGER.debug((Object)("Erzeuge Hibersap-Session f\ufffdr SessionManager " + jndiName));
                    session = this.openSession(jndiName);
                    sessionsCreated.put(session, jndiName);
                    ctx.getContextData().put(key, session);
                }
                ReflectionUtil.injectSessionIntoTarget(ctx.getTarget(), sessionField, session);
            }
            Object object = ctx.proceed();
            return object;
        }
        finally {
            this.closeSessions(sessionsCreated, ctx.getContextData());
        }
    }

    private void closeSessions(Map<Session, String> sessions, Map<String, Object> contextData) {
        HashSet<String> sessionManagerNamesWithError = new HashSet<String>();
        for (Session session : sessions.keySet()) {
            String jndiName = sessions.get(session);
            try {
                contextData.remove(HIBERSAP_SESSION_PREFIX + jndiName);
                if (session == null || session.isClosed()) continue;
                LOGGER.debug((Object)("Schlie\ufffde Hibersap-Session f\ufffdr SessionManager " + jndiName));
                session.close();
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)("Error closing Hibersap Session for SessionManager with JNDI name " + jndiName), (Throwable)e);
                sessionManagerNamesWithError.add(jndiName);
            }
        }
        if (!sessionManagerNamesWithError.isEmpty()) {
            throw new HibersapException(String.format("Error closing Session(s) for the SessionManager(s): %s. The corresponding SAP connection may not be released! For individual reasons see error logs.", sessionManagerNamesWithError));
        }
    }

    private Session openSession(String sessionManagerJndiName) {
        SessionManager sessionManager = this.lookupSessionManager(sessionManagerJndiName);
        return sessionManager.openSession();
    }

    private SessionManager lookupSessionManager(String jndiName) {
        InitialContext context = null;
        try {
            context = new InitialContext();
            Object object = context.lookup(jndiName);
            if (object == null) {
                throw new HibersapException(String.format("Lookup for JNDI name '%s' returned null. Expected to find an instance of %s", jndiName, SessionManager.class.getName()));
            }
            if (!SessionManager.class.isAssignableFrom(object.getClass())) {
                throw new HibersapException(String.format("Object bound under JNDI name '%s' is not a %s but an instance of %s", jndiName, SessionManager.class.getName(), object.getClass().getName()));
            }
            SessionManager sessionManager = (SessionManager)object;
            return sessionManager;
        }
        catch (NamingException e) {
            throw new HibersapException("Error creating InitialContext", (Throwable)e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    LOGGER.warn((Object)"Error closing InitialContext", (Throwable)e);
                }
            }
        }
    }
}

