/*
 * Decompiled with CFR 0.152.
 */
package org.hibersap.ejb.util;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibersap.HibersapException;
import org.hibersap.session.SessionManager;

public final class JndiUtil {
    private static final Log LOG = LogFactory.getLog(JndiUtil.class);

    private JndiUtil() {
    }

    @PostConstruct
    public static void rebindSessionManager(SessionManager sessionManager, String jndiName) {
        LOG.info((Object)("Binding Hibersap SessionManager '" + sessionManager.getConfig().getName() + "' to JNDI name '" + jndiName + "'"));
        try {
            InitialContext ctx = new InitialContext();
            ctx.rebind(jndiName, (Object)sessionManager);
        }
        catch (NamingException e) {
            throw new HibersapException("Failed binding Hibersap SessionManager to JNDI name [" + jndiName + "]", (Throwable)e);
        }
    }

    @PreDestroy
    public static void unbindSessionManager(String jndiName) {
        LOG.info((Object)("Unbinding Hibersap SessionManager from JNDI name '" + jndiName + "'"));
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(jndiName);
        }
        catch (NamingException e) {
            LOG.warn((Object)("Failed to unbind Hibersap SessionManager binding for JNDI name [" + jndiName + "]"), (Throwable)e);
        }
    }
}

