/*
 * Decompiled with CFR 0.152.
 */
package org.hibersap.ejb.util;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.hibersap.InternalHiberSapException;
import org.hibersap.ejb.interceptor.HibersapSession;
import org.hibersap.session.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static Set<Field> getHibersapSessionFields(Object target) {
        Field[] declaredFields;
        HashSet<Field> fields = new HashSet<Field>();
        for (Field declaredField : declaredFields = target.getClass().getDeclaredFields()) {
            if (declaredField.getAnnotation(HibersapSession.class) == null) continue;
            fields.add(declaredField);
        }
        return fields;
    }

    public static String getSessionManagerJndiName(Field sessionField) {
        HibersapSession annotation = sessionField.getAnnotation(HibersapSession.class);
        if (annotation == null) {
            throw new InternalHiberSapException(String.format("The field %s.%s is not annotated with @%s", sessionField.getDeclaringClass().getName(), sessionField.getName(), HibersapSession.class.getSimpleName()));
        }
        return annotation.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void injectSessionIntoTarget(Object target, Field field, Session session) {
        if (!Session.class.isAssignableFrom(field.getType())) {
            throw new InternalHiberSapException(String.format("Annotation @%s can only be used on a field of type or subtype of %s. Can not set %s field %s.%s to %s", HibersapSession.class.getSimpleName(), Session.class, field.getType(), target.getClass().getName(), field.getName(), session));
        }
        boolean accessible = field.isAccessible();
        Field field2 = field;
        synchronized (field2) {
            field.setAccessible(true);
            try {
                field.set(target, session);
            }
            catch (IllegalAccessException e) {
                throw new InternalHiberSapException(String.format("Error injecting Hibersap Session %s into %s.%s", session, target.getClass().getName(), field.getName()), (Throwable)e);
            }
            finally {
                field.setAccessible(accessible);
            }
        }
    }
}

