/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import javax.resource.spi.ConnectionRequestInfo;
import org.hornetq.ra.HornetQRALogger;
import org.hornetq.ra.HornetQRAProperties;
import org.hornetq.ra.HornetQRaUtils;

public class HornetQRAConnectionRequestInfo
implements ConnectionRequestInfo {
    private static boolean trace = HornetQRALogger.LOGGER.isTraceEnabled();
    private String userName;
    private String password;
    private String clientID;
    private final int type;
    private final boolean transacted;
    private final int acknowledgeMode;

    public HornetQRAConnectionRequestInfo(HornetQRAProperties prop, int type) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("constructor(" + prop + ")");
        }
        this.userName = prop.getUserName();
        this.password = prop.getPassword();
        this.clientID = prop.getClientID();
        this.type = type;
        this.transacted = true;
        this.acknowledgeMode = 1;
    }

    public HornetQRAConnectionRequestInfo(int type) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("constructor(" + type + ")");
        }
        this.type = type;
        this.transacted = true;
        this.acknowledgeMode = 1;
    }

    public HornetQRAConnectionRequestInfo(boolean transacted, int acknowledgeMode, int type) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("constructor(" + transacted + ", " + acknowledgeMode + ", " + type + ")");
        }
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.type = type;
    }

    public void setDefaults(HornetQRAProperties prop) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setDefaults(" + prop + ")");
        }
        if (this.userName == null) {
            this.userName = prop.getUserName();
        }
        if (this.password == null) {
            this.password = prop.getPassword();
        }
        if (this.clientID == null) {
            this.clientID = prop.getClientID();
        }
    }

    public String getUserName() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getUserName()");
        }
        return this.userName;
    }

    public void setUserName(String userName) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setUserName(" + userName + ")");
        }
        this.userName = userName;
    }

    public String getPassword() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getPassword()");
        }
        return this.password;
    }

    public void setPassword(String password) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setPassword(****)");
        }
        this.password = password;
    }

    public String getClientID() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getClientID()");
        }
        return this.clientID;
    }

    public void setClientID(String clientID) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setClientID(" + clientID + ")");
        }
        this.clientID = clientID;
    }

    public int getType() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getType()");
        }
        return this.type;
    }

    public boolean isTransacted() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("isTransacted() " + this.transacted);
        }
        return this.transacted;
    }

    public int getAcknowledgeMode() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getAcknowledgeMode()");
        }
        return this.acknowledgeMode;
    }

    public boolean equals(Object obj) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("equals(" + obj + ")");
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof HornetQRAConnectionRequestInfo) {
            HornetQRAConnectionRequestInfo you = (HornetQRAConnectionRequestInfo)obj;
            return HornetQRaUtils.compare(this.userName, you.getUserName()) && HornetQRaUtils.compare(this.password, you.getPassword()) && HornetQRaUtils.compare(this.clientID, you.getClientID()) && this.type == you.getType() && this.transacted == you.isTransacted() && this.acknowledgeMode == you.getAcknowledgeMode();
        }
        return false;
    }

    public int hashCode() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("hashCode()");
        }
        int hash = 7;
        hash += 31 * hash + (this.userName != null ? this.userName.hashCode() : 0);
        hash += 31 * hash + (this.password != null ? this.password.hashCode() : 0);
        hash += 31 * hash + Integer.valueOf(this.type).hashCode();
        hash += 31 * hash + (this.transacted ? 1 : 0);
        hash += 31 * hash + Integer.valueOf(this.acknowledgeMode).hashCode();
        return hash;
    }

    public String toString() {
        return "HornetQRAConnectionRequestInfo[type=" + this.type + ", transacted=" + this.transacted + ", acknowledgeMode=" + this.acknowledgeMode + ", clientID=" + this.clientID + ", userName=" + this.userName + ", password=" + this.password + "]";
    }
}

