/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.hornetq.ra.HornetQRALogger;
import org.hornetq.ra.HornetQRASession;

public class HornetQRAMessageProducer
implements MessageProducer {
    private static boolean trace = HornetQRALogger.LOGGER.isTraceEnabled();
    protected MessageProducer producer;
    protected HornetQRASession session;

    public HornetQRAMessageProducer(MessageProducer producer, HornetQRASession session) {
        this.producer = producer;
        this.session = session;
        if (trace) {
            HornetQRALogger.LOGGER.trace("new HornetQMessageProducer " + this + " producer=" + producer + " session=" + session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("close " + this);
        }
        try {
            this.closeProducer();
        }
        finally {
            this.session.removeProducer(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                HornetQRALogger.LOGGER.trace("send " + this + " destination=" + destination + " message=" + message + " deliveryMode=" + deliveryMode + " priority=" + priority + " ttl=" + timeToLive);
            }
            this.checkState();
            this.producer.send(destination, message, deliveryMode, priority, timeToLive);
            if (trace) {
                HornetQRALogger.LOGGER.trace("sent " + this + " result=" + message);
            }
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                HornetQRALogger.LOGGER.trace("send " + this + " destination=" + destination + " message=" + message);
            }
            this.checkState();
            this.producer.send(destination, message);
            if (trace) {
                HornetQRALogger.LOGGER.trace("sent " + this + " result=" + message);
            }
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                HornetQRALogger.LOGGER.trace("send " + this + " message=" + message + " deliveryMode=" + deliveryMode + " priority=" + priority + " ttl=" + timeToLive);
            }
            this.checkState();
            this.producer.send(message, deliveryMode, priority, timeToLive);
            if (trace) {
                HornetQRALogger.LOGGER.trace("sent " + this + " result=" + message);
            }
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                HornetQRALogger.LOGGER.trace("send " + this + " message=" + message);
            }
            this.checkState();
            this.producer.send(message);
            if (trace) {
                HornetQRALogger.LOGGER.trace("sent " + this + " result=" + message);
            }
        }
        finally {
            this.session.unlock();
        }
    }

    public int getDeliveryMode() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getDeliveryMode()");
        }
        return this.producer.getDeliveryMode();
    }

    public Destination getDestination() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getDestination()");
        }
        return this.producer.getDestination();
    }

    public boolean getDisableMessageID() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getDisableMessageID()");
        }
        return this.producer.getDisableMessageID();
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getDisableMessageTimestamp()");
        }
        return this.producer.getDisableMessageTimestamp();
    }

    public int getPriority() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getPriority()");
        }
        return this.producer.getPriority();
    }

    public long getTimeToLive() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getTimeToLive()");
        }
        return this.producer.getTimeToLive();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setDeliveryMode(" + deliveryMode + ")");
        }
        this.producer.setDeliveryMode(deliveryMode);
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setDisableMessageID(" + value + ")");
        }
        this.producer.setDisableMessageID(value);
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setDisableMessageTimestamp(" + value + ")");
        }
        this.producer.setDisableMessageTimestamp(value);
    }

    public void setPriority(int defaultPriority) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setPriority(" + defaultPriority + ")");
        }
        this.producer.setPriority(defaultPriority);
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setTimeToLive(" + timeToLive + ")");
        }
        this.producer.setTimeToLive(timeToLive);
    }

    void checkState() throws JMSException {
        this.session.checkState();
    }

    void closeProducer() throws JMSException {
        this.producer.close();
    }
}

