/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra.inflow;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.HornetQNonExistentQueueException;
import org.hornetq.api.core.HornetQNotConnectedException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.jms.HornetQJMSClient;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.server.recovery.XARecoveryConfig;
import org.hornetq.ra.HornetQRALogger;
import org.hornetq.ra.HornetQRaUtils;
import org.hornetq.ra.HornetQResourceAdapter;
import org.hornetq.ra.inflow.HornetQActivationSpec;
import org.hornetq.ra.inflow.HornetQMessageHandler;
import org.hornetq.utils.SensitiveDataCodec;

public class HornetQActivation {
    private static boolean trace = HornetQRALogger.LOGGER.isTraceEnabled();
    public static final Method ONMESSAGE;
    private final HornetQResourceAdapter ra;
    private final HornetQActivationSpec spec;
    private final MessageEndpointFactory endpointFactory;
    private final AtomicBoolean deliveryActive = new AtomicBoolean(false);
    private boolean isTopic = false;
    private boolean isDeliveryTransacted;
    private HornetQDestination destination;
    private SimpleString topicTemporaryQueue;
    private final List<HornetQMessageHandler> handlers = new ArrayList<HornetQMessageHandler>();
    private HornetQConnectionFactory factory;
    private final AtomicBoolean inFailure = new AtomicBoolean(false);
    private XARecoveryConfig resourceRecovery;

    public HornetQActivation(HornetQResourceAdapter ra, MessageEndpointFactory endpointFactory, HornetQActivationSpec spec) throws ResourceException {
        String pass;
        spec.validate();
        if (trace) {
            HornetQRALogger.LOGGER.trace("constructor(" + ra + ", " + endpointFactory + ", " + spec + ")");
        }
        if (ra.isUseMaskedPassword().booleanValue() && (pass = spec.getOwnPassword()) != null) {
            SensitiveDataCodec<String> codec = ra.getCodecInstance();
            try {
                spec.setPassword((String)codec.decode((Object)pass));
            }
            catch (Exception e) {
                throw new ResourceException((Throwable)e);
            }
        }
        this.ra = ra;
        this.endpointFactory = endpointFactory;
        this.spec = spec;
        try {
            this.isDeliveryTransacted = endpointFactory.isDeliveryTransacted(ONMESSAGE);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public HornetQActivationSpec getActivationSpec() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getActivationSpec()");
        }
        return this.spec;
    }

    public MessageEndpointFactory getMessageEndpointFactory() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getMessageEndpointFactory()");
        }
        return this.endpointFactory;
    }

    public boolean isDeliveryTransacted() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("isDeliveryTransacted()");
        }
        return this.isDeliveryTransacted;
    }

    public WorkManager getWorkManager() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getWorkManager()");
        }
        return this.ra.getWorkManager();
    }

    public boolean isTopic() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("isTopic()");
        }
        return this.isTopic;
    }

    public void start() throws ResourceException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("start()");
        }
        this.deliveryActive.set(true);
        this.ra.getWorkManager().scheduleWork((Work)new SetupActivation());
    }

    public SimpleString getTopicTemporaryQueue() {
        return this.topicTemporaryQueue;
    }

    public void setTopicTemporaryQueue(SimpleString topicTemporaryQueue) {
        this.topicTemporaryQueue = topicTemporaryQueue;
    }

    public void stop() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("stop()");
        }
        this.deliveryActive.set(false);
        this.teardown();
    }

    protected synchronized void setup() throws Exception {
        HornetQRALogger.LOGGER.debug("Setting up " + this.spec);
        this.setupCF();
        this.setupDestination();
        for (int i = 0; i < this.spec.getMaxSession(); ++i) {
            ClientSession session = null;
            try {
                ClientSessionFactory cf = this.factory.getServerLocator().createSessionFactory();
                session = this.setupSession(cf);
                HornetQMessageHandler handler = new HornetQMessageHandler(this, this.ra.getTM(), (ClientSessionInternal)session, cf, i);
                handler.setup();
                session.start();
                this.handlers.add(handler);
                continue;
            }
            catch (Exception e) {
                if (session != null) {
                    session.close();
                }
                throw e;
            }
        }
        HornetQRALogger.LOGGER.debug("Setup complete " + this);
    }

    protected synchronized void teardown() {
        HornetQRALogger.LOGGER.debug("Tearing down " + this.spec);
        if (this.resourceRecovery != null) {
            this.ra.getRecoveryManager().unRegister(this.resourceRecovery);
        }
        for (HornetQMessageHandler handler : this.handlers) {
            handler.interruptConsumer();
        }
        Thread threadTearDown = new Thread("TearDown/HornetQActivation"){

            @Override
            public void run() {
                for (HornetQMessageHandler handler : HornetQActivation.this.handlers) {
                    handler.teardown();
                }
            }
        };
        threadTearDown.start();
        try {
            threadTearDown.join(this.factory.getCallTimeout());
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (threadTearDown.isAlive()) {
            if (this.factory != null) {
                this.factory.close();
                this.factory = null;
            }
            threadTearDown.interrupt();
            try {
                threadTearDown.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (threadTearDown.isAlive()) {
                HornetQRALogger.LOGGER.warn("Thread " + threadTearDown + " couldn't be finished");
            }
        }
        if (this.spec.isHasBeenUpdated() && this.factory != null) {
            this.factory.close();
            this.factory = null;
        }
        HornetQRALogger.LOGGER.debug("Tearing down complete " + this);
    }

    protected void setupCF() throws Exception {
        if (this.spec.isHasBeenUpdated()) {
            this.factory = this.ra.createHornetQConnectionFactory(this.spec);
            this.resourceRecovery = this.ra.getRecoveryManager().register(this.factory, this.spec.getUser(), this.spec.getPassword());
        } else {
            this.factory = this.ra.getDefaultHornetQConnectionFactory();
        }
    }

    protected ClientSession setupSession(ClientSessionFactory cf) throws Exception {
        ClientSession result = null;
        try {
            String clientID;
            result = this.ra.createSession(cf, this.spec.getAcknowledgeModeInt(), this.spec.getUser(), this.spec.getPassword(), this.ra.getPreAcknowledge(), this.ra.getDupsOKBatchSize(), this.ra.getTransactionBatchSize(), this.isDeliveryTransacted, this.spec.isUseLocalTx(), this.spec.getTransactionTimeout());
            result.addMetaData("resource-adapter", "inbound");
            result.addMetaData("jms-session", "");
            String string = clientID = this.ra.getClientID() == null ? this.spec.getClientID() : this.ra.getClientID();
            if (clientID != null) {
                result.addMetaData("jms-client-id", clientID);
            }
            HornetQRALogger.LOGGER.debug("Using queue connection " + result);
            return result;
        }
        catch (Throwable t) {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception e) {
                HornetQRALogger.LOGGER.trace("Ignored error closing connection", e);
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new RuntimeException("Error configuring connection", t);
        }
    }

    public SimpleString getAddress() {
        return this.destination.getSimpleAddress();
    }

    protected void setupDestination() throws Exception {
        block14: {
            String destinationName = this.spec.getDestination();
            if (this.spec.isUseJNDI()) {
                String destinationTypeString;
                InitialContext ctx = this.spec.getParsedJndiParams() == null ? new InitialContext() : new InitialContext(this.spec.getParsedJndiParams());
                HornetQRALogger.LOGGER.debug("Using context " + ctx.getEnvironment() + " for " + this.spec);
                if (trace) {
                    HornetQRALogger.LOGGER.trace("setupDestination(" + ctx + ")");
                }
                if ((destinationTypeString = this.spec.getDestinationType()) != null && !destinationTypeString.trim().equals("")) {
                    Class<Topic> destinationType;
                    HornetQRALogger.LOGGER.debug("Destination type defined as " + destinationTypeString);
                    if (Topic.class.getName().equals(destinationTypeString)) {
                        destinationType = Topic.class;
                        this.isTopic = true;
                    } else {
                        destinationType = Queue.class;
                    }
                    HornetQRALogger.LOGGER.debug("Retrieving " + destinationType.getName() + " \"" + destinationName + "\" from JNDI");
                    try {
                        this.destination = (HornetQDestination)HornetQRaUtils.lookup(ctx, destinationName, destinationType);
                    }
                    catch (Exception e) {
                        if (destinationName == null) {
                            throw e;
                        }
                        String calculatedDestinationName = destinationName.substring(destinationName.lastIndexOf(47) + 1);
                        HornetQRALogger.LOGGER.debug("Unable to retrieve " + destinationName + " from JNDI. Creating a new " + destinationType.getName() + " named " + calculatedDestinationName + " to be used by the MDB.");
                        if (this.isTopic) {
                            this.destination = (HornetQDestination)HornetQJMSClient.createTopic((String)calculatedDestinationName);
                            break block14;
                        }
                        this.destination = (HornetQDestination)HornetQJMSClient.createQueue((String)calculatedDestinationName);
                    }
                } else {
                    HornetQRALogger.LOGGER.debug("Destination type not defined in MDB activation configuration.");
                    HornetQRALogger.LOGGER.debug("Retrieving " + Destination.class.getName() + " \"" + destinationName + "\" from JNDI");
                    this.destination = (HornetQDestination)HornetQRaUtils.lookup(ctx, destinationName, Destination.class);
                    if (this.destination instanceof Topic) {
                        this.isTopic = true;
                    }
                }
            } else {
                HornetQRALogger.LOGGER.instantiatingDestination(this.spec.getDestinationType(), this.spec.getDestination());
                if (Topic.class.getName().equals(this.spec.getDestinationType())) {
                    this.destination = (HornetQDestination)HornetQJMSClient.createTopic((String)this.spec.getDestination());
                    this.isTopic = true;
                } else {
                    this.destination = (HornetQDestination)HornetQJMSClient.createQueue((String)this.spec.getDestination());
                }
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(HornetQActivation.class.getName()).append('(');
        buffer.append("spec=").append(this.spec.getClass().getName());
        buffer.append(" mepf=").append(this.endpointFactory.getClass().getName());
        buffer.append(" active=").append(this.deliveryActive.get());
        if (this.spec.getDestination() != null) {
            buffer.append(" destination=").append(this.spec.getDestination());
        }
        buffer.append(" transacted=").append(this.isDeliveryTransacted);
        buffer.append(')');
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFailure(Throwable failure) {
        if (failure instanceof HornetQException && ((HornetQException)failure).getType() == HornetQExceptionType.QUEUE_DOES_NOT_EXIST) {
            HornetQRALogger.LOGGER.awaitingTopicQueueCreation(this.getActivationSpec().getDestination());
        } else if (failure instanceof HornetQException && ((HornetQException)failure).getType() == HornetQExceptionType.NOT_CONNECTED) {
            HornetQRALogger.LOGGER.awaitingJMSServerCreation();
        } else {
            HornetQRALogger.LOGGER.failureInActivation(failure, this.spec);
        }
        int setupAttempts = this.spec.getSetupAttempts();
        long setupInterval = this.spec.getSetupInterval();
        if (this.inFailure.getAndSet(true)) {
            return;
        }
        try {
            Throwable lastException = failure;
            for (int reconnectCount = 0; this.deliveryActive.get() && (setupAttempts == -1 || reconnectCount < setupAttempts); ++reconnectCount) {
                this.teardown();
                try {
                    Thread.sleep(setupInterval);
                }
                catch (InterruptedException e) {
                    HornetQRALogger.LOGGER.debug("Interrupted trying to reconnect " + this.spec, e);
                    break;
                }
                if (reconnectCount < 1) {
                    HornetQRALogger.LOGGER.attemptingReconnect(this.spec);
                }
                try {
                    this.setup();
                    HornetQRALogger.LOGGER.reconnected();
                    break;
                }
                catch (Throwable t) {
                    if (failure instanceof HornetQException && ((HornetQException)failure).getType() == HornetQExceptionType.QUEUE_DOES_NOT_EXIST) {
                        if (lastException != null && t instanceof HornetQNonExistentQueueException) continue;
                        lastException = t;
                        HornetQRALogger.LOGGER.awaitingTopicQueueCreation(this.getActivationSpec().getDestination());
                        continue;
                    }
                    if (failure instanceof HornetQException && ((HornetQException)failure).getType() == HornetQExceptionType.NOT_CONNECTED) {
                        if (lastException != null && t instanceof HornetQNotConnectedException) continue;
                        lastException = t;
                        HornetQRALogger.LOGGER.awaitingJMSServerCreation();
                        continue;
                    }
                    HornetQRALogger.LOGGER.errorReconnecting(t, this.spec);
                    continue;
                }
            }
        }
        finally {
            this.inFailure.set(false);
        }
    }

    public HornetQConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    static {
        try {
            ONMESSAGE = MessageListener.class.getMethod("onMessage", Message.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class SetupActivation
    implements Work {
        private SetupActivation() {
        }

        public void run() {
            try {
                HornetQActivation.this.setup();
            }
            catch (Throwable t) {
                HornetQActivation.this.handleFailure(t);
            }
        }

        public void release() {
        }
    }
}

