/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import javax.jms.Message;
import javax.jms.MessageListener;
import org.hornetq.core.logging.Logger;
import org.hornetq.ra.HornetQRAMessageConsumer;

public class HornetQRAMessageListener
implements MessageListener {
    private static final Logger log = Logger.getLogger(HornetQRAMessageListener.class);
    private static boolean trace = log.isTraceEnabled();
    private final MessageListener listener;
    private final HornetQRAMessageConsumer consumer;

    public HornetQRAMessageListener(MessageListener listener, HornetQRAMessageConsumer consumer) {
        if (trace) {
            log.trace((Object)("constructor(" + listener + ", " + consumer + ")"));
        }
        this.listener = listener;
        this.consumer = consumer;
    }

    public void onMessage(Message message) {
        if (trace) {
            log.trace((Object)("onMessage(" + message + ")"));
        }
        message = this.consumer.wrapMessage(message);
        this.listener.onMessage(message);
    }
}

