/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra.inflow;

import java.util.HashMap;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import org.hornetq.core.logging.Logger;
import org.hornetq.ra.ConnectionFactoryProperties;
import org.hornetq.ra.HornetQResourceAdapter;
import org.hornetq.ra.Util;

public class HornetQActivationSpec
extends ConnectionFactoryProperties
implements ActivationSpec {
    private static final int DEFAULT_MAX_SESSION = 15;
    private static final Logger log = Logger.getLogger(HornetQActivationSpec.class);
    private static boolean trace = log.isTraceEnabled();
    private Map<String, Object> connectionParameters = new HashMap<String, Object>();
    public String strConnectionParameters;
    private HornetQResourceAdapter ra;
    private String destination;
    private String destinationType;
    private String messageSelector;
    private int acknowledgeMode;
    private boolean subscriptionDurability;
    private String subscriptionName;
    private String user;
    private String password;
    private Integer maxSession;
    private Integer transactionTimeout;
    private boolean useJNDI = true;
    private Boolean localTx;

    public HornetQActivationSpec() {
        if (trace) {
            log.trace((Object)"constructor()");
        }
        this.ra = null;
        this.destination = null;
        this.destinationType = null;
        this.messageSelector = null;
        this.acknowledgeMode = 1;
        this.subscriptionDurability = false;
        this.subscriptionName = null;
        this.user = null;
        this.password = null;
        this.maxSession = 15;
        this.transactionTimeout = 0;
    }

    public ResourceAdapter getResourceAdapter() {
        if (trace) {
            log.trace((Object)"getResourceAdapter()");
        }
        return this.ra;
    }

    public boolean isUseJNDI() {
        return this.useJNDI;
    }

    public void setUseJNDI(boolean value) {
        this.useJNDI = value;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        if (trace) {
            log.trace((Object)("setResourceAdapter(" + ra + ")"));
        }
        if (ra == null || !(ra instanceof HornetQResourceAdapter)) {
            throw new ResourceException("Resource adapter is " + ra);
        }
        this.ra = (HornetQResourceAdapter)ra;
    }

    public String getDestination() {
        if (trace) {
            log.trace((Object)"getDestination()");
        }
        return this.destination;
    }

    public void setDestination(String value) {
        if (trace) {
            log.trace((Object)("setDestination(" + value + ")"));
        }
        this.destination = value;
    }

    public String getDestinationType() {
        if (trace) {
            log.trace((Object)"getDestinationType()");
        }
        return this.destinationType;
    }

    public void setDestinationType(String value) {
        if (trace) {
            log.trace((Object)("setDestinationType(" + value + ")"));
        }
        this.destinationType = value;
    }

    public String getMessageSelector() {
        if (trace) {
            log.trace((Object)"getMessageSelector()");
        }
        return this.messageSelector;
    }

    public void setMessageSelector(String value) {
        if (trace) {
            log.trace((Object)("setMessageSelector(" + value + ")"));
        }
        this.messageSelector = value;
    }

    public String getAcknowledgeMode() {
        if (trace) {
            log.trace((Object)"getAcknowledgeMode()");
        }
        if (3 == this.acknowledgeMode) {
            return "Dups-ok-acknowledge";
        }
        return "Auto-acknowledge";
    }

    public void setAcknowledgeMode(String value) {
        if (trace) {
            log.trace((Object)("setAcknowledgeMode(" + value + ")"));
        }
        if ("DUPS_OK_ACKNOWLEDGE".equalsIgnoreCase(value) || "Dups-ok-acknowledge".equalsIgnoreCase(value)) {
            this.acknowledgeMode = 3;
        } else if ("AUTO_ACKNOWLEDGE".equalsIgnoreCase(value) || "Auto-acknowledge".equalsIgnoreCase(value)) {
            this.acknowledgeMode = 1;
        } else {
            throw new IllegalArgumentException("Unsupported acknowledgement mode " + value);
        }
    }

    public int getAcknowledgeModeInt() {
        if (trace) {
            log.trace((Object)"getAcknowledgeMode()");
        }
        return this.acknowledgeMode;
    }

    public String getSubscriptionDurability() {
        if (trace) {
            log.trace((Object)"getSubscriptionDurability()");
        }
        if (this.subscriptionDurability) {
            return "Durable";
        }
        return "NonDurable";
    }

    public void setSubscriptionDurability(String value) {
        if (trace) {
            log.trace((Object)("setSubscriptionDurability(" + value + ")"));
        }
        this.subscriptionDurability = "Durable".equals(value);
    }

    public boolean isSubscriptionDurable() {
        if (trace) {
            log.trace((Object)"isSubscriptionDurable()");
        }
        return this.subscriptionDurability;
    }

    public String getSubscriptionName() {
        if (trace) {
            log.trace((Object)"getSubscriptionName()");
        }
        return this.subscriptionName;
    }

    public void setSubscriptionName(String value) {
        if (trace) {
            log.trace((Object)("setSubscriptionName(" + value + ")"));
        }
        this.subscriptionName = value;
    }

    public String getUser() {
        if (trace) {
            log.trace((Object)"getUser()");
        }
        if (this.user == null) {
            return this.ra.getUserName();
        }
        return this.user;
    }

    public void setUser(String value) {
        if (trace) {
            log.trace((Object)("setUser(" + value + ")"));
        }
        this.user = value;
    }

    public String getPassword() {
        if (trace) {
            log.trace((Object)"getPassword()");
        }
        if (this.password == null) {
            return this.ra.getPassword();
        }
        return this.password;
    }

    public void setPassword(String value) {
        if (trace) {
            log.trace((Object)("setPassword(" + value + ")"));
        }
        this.password = value;
    }

    public Integer getMaxSession() {
        if (trace) {
            log.trace((Object)"getMaxSession()");
        }
        if (this.maxSession == null) {
            return 15;
        }
        return this.maxSession;
    }

    public void setMaxSession(Integer value) {
        if (trace) {
            log.trace((Object)("setMaxSession(" + value + ")"));
        }
        this.maxSession = value;
    }

    public Integer getTransactionTimeout() {
        if (trace) {
            log.trace((Object)"getTransactionTimeout()");
        }
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(Integer value) {
        if (trace) {
            log.trace((Object)("setTransactionTimeout(" + value + ")"));
        }
        this.transactionTimeout = value;
    }

    public Boolean isUseLocalTx() {
        if (this.localTx == null) {
            return this.ra.getUseLocalTx();
        }
        return this.localTx;
    }

    public void setUseLocalTx(Boolean localTx) {
        this.localTx = localTx;
    }

    public void setTransactionManagerLocatorClass(String transactionManagerLocatorClass) {
        log.info((Object)"TransactionManagerLocatorClass property on the Activation Setup is deprecated and it has no use. Use the property on the HornetQ Resource Adapter if you need");
    }

    public String getTransactionManagerLocatorClass() {
        return null;
    }

    public String getTransactionManagerLocatorMethod() {
        return null;
    }

    public void setTransactionManagerLocatorMethod(String transactionManagerLocatorMethod) {
        log.info((Object)"setTransactionManagerLocatorMethod property on the Activation Setup is deprecated and it has no use. Use the property on the HornetQ Resource Adapter if you need");
    }

    public void validate() throws InvalidPropertyException {
        if (trace) {
            log.trace((Object)"validate()");
        }
        if (this.destination == null || this.destination.trim().equals("")) {
            throw new InvalidPropertyException("Destination is mandatory");
        }
    }

    public String getConnectionParameters() {
        return this.strConnectionParameters;
    }

    @Override
    public Map<String, Object> getParsedConnectionParameters() {
        return this.connectionParameters;
    }

    public void setConnectionParameters(String configuration) {
        this.strConnectionParameters = configuration;
        this.connectionParameters = Util.parseConfig(configuration);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(HornetQActivationSpec.class.getName()).append('(');
        buffer.append("ra=").append(this.ra);
        buffer.append(" destination=").append(this.destination);
        buffer.append(" destinationType=").append(this.destinationType);
        if (this.messageSelector != null) {
            buffer.append(" selector=").append(this.messageSelector);
        }
        buffer.append(" ack=").append(this.getAcknowledgeMode());
        buffer.append(" durable=").append(this.subscriptionDurability);
        buffer.append(" clientID=").append(this.getClientID());
        if (this.subscriptionName != null) {
            buffer.append(" subscription=").append(this.subscriptionName);
        }
        buffer.append(" user=").append(this.user);
        if (this.password != null) {
            buffer.append(" password=").append("****");
        }
        buffer.append(" maxSession=").append(this.maxSession);
        buffer.append(')');
        return buffer.toString();
    }

    public void setUseDLQ(boolean b) {
    }

    public void setDLQJNDIName(String name) {
    }

    public void setDLQHandler(String handler) {
    }

    public void setDLQMaxResent(int maxResent) {
    }

    public void setProviderAdapterJNDI(String jndi) {
    }

    public void setKeepAlive(boolean keepAlive) {
    }

    public void setKeepAliveMillis(long keepAliveMillis) {
    }

    public void setReconnectInterval(long interval) {
    }

    public void setMinSession(Integer value) {
    }

    public void setMaxMessages(Integer value) {
    }
}

