/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionInProgressException;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ManagedConnection;
import javax.transaction.xa.XAResource;
import org.hornetq.core.logging.Logger;
import org.hornetq.ra.HornetQRAConnectionRequestInfo;
import org.hornetq.ra.HornetQRAManagedConnection;
import org.hornetq.ra.HornetQRAMessageConsumer;
import org.hornetq.ra.HornetQRAMessageProducer;
import org.hornetq.ra.HornetQRAQueueReceiver;
import org.hornetq.ra.HornetQRAQueueSender;
import org.hornetq.ra.HornetQRASessionFactory;
import org.hornetq.ra.HornetQRATopicPublisher;
import org.hornetq.ra.HornetQRATopicSubscriber;

public class HornetQRASession
implements Session,
QueueSession,
TopicSession,
XASession,
XAQueueSession,
XATopicSession {
    private static final Logger log = Logger.getLogger(HornetQRASession.class);
    private static boolean trace = log.isTraceEnabled();
    private HornetQRAManagedConnection mc;
    private final HornetQRAConnectionRequestInfo cri;
    private HornetQRASessionFactory sf;
    private final Set consumers;
    private final Set producers;

    public HornetQRASession(HornetQRAManagedConnection mc, HornetQRAConnectionRequestInfo cri) {
        if (trace) {
            log.trace((Object)("constructor(" + mc + ", " + cri + ")"));
        }
        this.mc = mc;
        this.cri = cri;
        this.sf = null;
        this.consumers = new HashSet();
        this.producers = new HashSet();
    }

    public void setHornetQSessionFactory(HornetQRASessionFactory sf) {
        if (trace) {
            log.trace((Object)("setHornetQSessionFactory(" + sf + ")"));
        }
        this.sf = sf;
    }

    protected void lock() throws JMSException {
        HornetQRAManagedConnection mc;
        if (trace) {
            log.trace((Object)"lock()");
        }
        if ((mc = this.mc) == null) {
            throw new IllegalStateException("Connection is not associated with a managed connection. " + this);
        }
        mc.tryLock();
    }

    protected void unlock() {
        HornetQRAManagedConnection mc;
        if (trace) {
            log.trace((Object)"unlock()");
        }
        if ((mc = this.mc) != null) {
            mc.unlock();
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        Session session = this.getSessionInternal();
        if (trace) {
            log.trace((Object)("createBytesMessage" + session));
        }
        return session.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        Session session = this.getSessionInternal();
        if (trace) {
            log.trace((Object)("createMapMessage" + session));
        }
        return session.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        Session session = this.getSessionInternal();
        if (trace) {
            log.trace((Object)("createMessage" + session));
        }
        return session.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        Session session = this.getSessionInternal();
        if (trace) {
            log.trace((Object)("createObjectMessage" + session));
        }
        return session.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        Session session = this.getSessionInternal();
        if (trace) {
            log.trace((Object)("createObjectMessage(" + object + ")" + session));
        }
        return session.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        Session session = this.getSessionInternal();
        if (trace) {
            log.trace((Object)("createStreamMessage" + session));
        }
        return session.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        Session session = this.getSessionInternal();
        if (trace) {
            log.trace((Object)("createTextMessage" + session));
        }
        return session.createTextMessage();
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        Session session = this.getSessionInternal();
        if (trace) {
            log.trace((Object)("createTextMessage(" + string + ")" + session));
        }
        return session.createTextMessage(string);
    }

    public boolean getTransacted() throws JMSException {
        if (trace) {
            log.trace((Object)"getTransacted()");
        }
        this.getSessionInternal();
        return this.cri.isTransacted();
    }

    public MessageListener getMessageListener() throws JMSException {
        if (trace) {
            log.trace((Object)"getMessageListener()");
        }
        throw new IllegalStateException("Method not allowed");
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (trace) {
            log.trace((Object)("setMessageListener(" + listener + ")"));
        }
        throw new IllegalStateException("Method not allowed");
    }

    public void run() {
        if (trace) {
            log.trace((Object)"run()");
        }
        throw new Error("Method not allowed");
    }

    public void close() throws JMSException {
        if (trace) {
            log.trace((Object)"close()");
        }
        this.sf.closeSession(this);
        this.closeSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        if (this.cri.getType() == 3 || this.cri.getType() == 4 || this.cri.getType() == 5) {
            throw new TransactionInProgressException("XA connection");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (!this.cri.isTransacted()) {
                throw new IllegalStateException("Session is not transacted");
            }
            if (trace) {
                log.trace((Object)("Commit session " + this));
            }
            session.commit();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        if (this.cri.getType() == 3 || this.cri.getType() == 4 || this.cri.getType() == 5) {
            throw new TransactionInProgressException("XA connection");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (!this.cri.isTransacted()) {
                throw new IllegalStateException("Session is not transacted");
            }
            if (trace) {
                log.trace((Object)("Rollback session " + this));
            }
            session.rollback();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (this.cri.isTransacted()) {
                throw new IllegalStateException("Session is transacted");
            }
            if (trace) {
                log.trace((Object)("Recover session " + this));
            }
            session.recover();
        }
        finally {
            this.unlock();
        }
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (this.cri.getType() == 1 || this.cri.getType() == 4) {
            throw new IllegalStateException("Cannot create topic for javax.jms.QueueSession");
        }
        Session session = this.getSessionInternal();
        if (trace) {
            log.trace((Object)("createTopic " + session + " topicName=" + topicName));
        }
        Topic result = session.createTopic(topicName);
        if (trace) {
            log.trace((Object)("createdTopic " + session + " topic=" + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.lock();
        try {
            TopicSession session = this.getTopicSessionInternal();
            if (trace) {
                log.trace((Object)("createSubscriber " + session + " topic=" + topic));
            }
            TopicSubscriber result = session.createSubscriber(topic);
            result = new HornetQRATopicSubscriber(result, this);
            if (trace) {
                log.trace((Object)("createdSubscriber " + session + " HornetQTopicSubscriber=" + result));
            }
            this.addConsumer((MessageConsumer)result);
            TopicSubscriber topicSubscriber = result;
            return topicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.lock();
        try {
            TopicSession session = this.getTopicSessionInternal();
            if (trace) {
                log.trace((Object)("createSubscriber " + session + " topic=" + topic + " selector=" + messageSelector + " noLocal=" + noLocal));
            }
            TopicSubscriber result = session.createSubscriber(topic, messageSelector, noLocal);
            result = new HornetQRATopicSubscriber(result, this);
            if (trace) {
                log.trace((Object)("createdSubscriber " + session + " HornetQTopicSubscriber=" + result));
            }
            this.addConsumer((MessageConsumer)result);
            TopicSubscriber topicSubscriber = result;
            return topicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        if (this.cri.getType() == 1 || this.cri.getType() == 4) {
            throw new IllegalStateException("Cannot create durable subscriber from javax.jms.QueueSession");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (trace) {
                log.trace((Object)("createDurableSubscriber " + session + " topic=" + topic + " name=" + name));
            }
            TopicSubscriber result = session.createDurableSubscriber(topic, name);
            result = new HornetQRATopicSubscriber(result, this);
            if (trace) {
                log.trace((Object)("createdDurableSubscriber " + session + " HornetQTopicSubscriber=" + result));
            }
            this.addConsumer((MessageConsumer)result);
            TopicSubscriber topicSubscriber = result;
            return topicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (trace) {
                log.trace((Object)("createDurableSubscriber " + session + " topic=" + topic + " name=" + name + " selector=" + messageSelector + " noLocal=" + noLocal));
            }
            TopicSubscriber result = session.createDurableSubscriber(topic, name, messageSelector, noLocal);
            result = new HornetQRATopicSubscriber(result, this);
            if (trace) {
                log.trace((Object)("createdDurableSubscriber " + session + " HornetQTopicSubscriber=" + result));
            }
            this.addConsumer((MessageConsumer)result);
            TopicSubscriber topicSubscriber = result;
            return topicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.lock();
        try {
            TopicSession session = this.getTopicSessionInternal();
            if (trace) {
                log.trace((Object)("createPublisher " + session + " topic=" + topic));
            }
            TopicPublisher result = session.createPublisher(topic);
            result = new HornetQRATopicPublisher(result, this);
            if (trace) {
                log.trace((Object)("createdPublisher " + session + " publisher=" + result));
            }
            this.addProducer((MessageProducer)result);
            TopicPublisher topicPublisher = result;
            return topicPublisher;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.cri.getType() == 1 || this.cri.getType() == 4) {
            throw new IllegalStateException("Cannot create temporary topic for javax.jms.QueueSession");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (trace) {
                log.trace((Object)("createTemporaryTopic " + session));
            }
            TemporaryTopic temp = session.createTemporaryTopic();
            if (trace) {
                log.trace((Object)("createdTemporaryTopic " + session + " temp=" + temp));
            }
            this.sf.addTemporaryTopic(temp);
            TemporaryTopic temporaryTopic = temp;
            return temporaryTopic;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String name) throws JMSException {
        if (this.cri.getType() == 1 || this.cri.getType() == 4) {
            throw new IllegalStateException("Cannot unsubscribe for javax.jms.QueueSession");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (trace) {
                log.trace((Object)("unsubscribe " + session + " name=" + name));
            }
            session.unsubscribe(name);
        }
        finally {
            this.unlock();
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (this.cri.getType() == 2 || this.cri.getType() == 5) {
            throw new IllegalStateException("Cannot create browser for javax.jms.TopicSession");
        }
        Session session = this.getSessionInternal();
        if (trace) {
            log.trace((Object)("createBrowser " + session + " queue=" + queue));
        }
        QueueBrowser result = session.createBrowser(queue);
        if (trace) {
            log.trace((Object)("createdBrowser " + session + " browser=" + result));
        }
        return result;
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        if (this.cri.getType() == 2 || this.cri.getType() == 5) {
            throw new IllegalStateException("Cannot create browser for javax.jms.TopicSession");
        }
        Session session = this.getSessionInternal();
        if (trace) {
            log.trace((Object)("createBrowser " + session + " queue=" + queue + " selector=" + messageSelector));
        }
        QueueBrowser result = session.createBrowser(queue, messageSelector);
        if (trace) {
            log.trace((Object)("createdBrowser " + session + " browser=" + result));
        }
        return result;
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (this.cri.getType() == 2 || this.cri.getType() == 5) {
            throw new IllegalStateException("Cannot create browser or javax.jms.TopicSession");
        }
        Session session = this.getSessionInternal();
        if (trace) {
            log.trace((Object)("createQueue " + session + " queueName=" + queueName));
        }
        Queue result = session.createQueue(queueName);
        if (trace) {
            log.trace((Object)("createdQueue " + session + " queue=" + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.lock();
        try {
            QueueSession session = this.getQueueSessionInternal();
            if (trace) {
                log.trace((Object)("createReceiver " + session + " queue=" + queue));
            }
            QueueReceiver result = session.createReceiver(queue);
            result = new HornetQRAQueueReceiver(result, this);
            if (trace) {
                log.trace((Object)("createdReceiver " + session + " receiver=" + result));
            }
            this.addConsumer((MessageConsumer)result);
            QueueReceiver queueReceiver = result;
            return queueReceiver;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.lock();
        try {
            QueueSession session = this.getQueueSessionInternal();
            if (trace) {
                log.trace((Object)("createReceiver " + session + " queue=" + queue + " selector=" + messageSelector));
            }
            QueueReceiver result = session.createReceiver(queue, messageSelector);
            result = new HornetQRAQueueReceiver(result, this);
            if (trace) {
                log.trace((Object)("createdReceiver " + session + " receiver=" + result));
            }
            this.addConsumer((MessageConsumer)result);
            QueueReceiver queueReceiver = result;
            return queueReceiver;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueSender createSender(Queue queue) throws JMSException {
        this.lock();
        try {
            QueueSession session = this.getQueueSessionInternal();
            if (trace) {
                log.trace((Object)("createSender " + session + " queue=" + queue));
            }
            QueueSender result = session.createSender(queue);
            result = new HornetQRAQueueSender(result, this);
            if (trace) {
                log.trace((Object)("createdSender " + session + " sender=" + result));
            }
            this.addProducer((MessageProducer)result);
            QueueSender queueSender = result;
            return queueSender;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.cri.getType() == 2 || this.cri.getType() == 5) {
            throw new IllegalStateException("Cannot create temporary queue for javax.jms.TopicSession");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (trace) {
                log.trace((Object)("createTemporaryQueue " + session));
            }
            TemporaryQueue temp = session.createTemporaryQueue();
            if (trace) {
                log.trace((Object)("createdTemporaryQueue " + session + " temp=" + temp));
            }
            this.sf.addTemporaryQueue(temp);
            TemporaryQueue temporaryQueue = temp;
            return temporaryQueue;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (trace) {
                log.trace((Object)("createConsumer " + session + " dest=" + destination));
            }
            MessageConsumer result = session.createConsumer(destination);
            result = new HornetQRAMessageConsumer(result, this);
            if (trace) {
                log.trace((Object)("createdConsumer " + session + " consumer=" + result));
            }
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (trace) {
                log.trace((Object)("createConsumer " + session + " dest=" + destination + " messageSelector=" + messageSelector));
            }
            MessageConsumer result = session.createConsumer(destination, messageSelector);
            result = new HornetQRAMessageConsumer(result, this);
            if (trace) {
                log.trace((Object)("createdConsumer " + session + " consumer=" + result));
            }
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (trace) {
                log.trace((Object)("createConsumer " + session + " dest=" + destination + " messageSelector=" + messageSelector + " noLocal=" + noLocal));
            }
            MessageConsumer result = session.createConsumer(destination, messageSelector, noLocal);
            result = new HornetQRAMessageConsumer(result, this);
            if (trace) {
                log.trace((Object)("createdConsumer " + session + " consumer=" + result));
            }
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (trace) {
                log.trace((Object)("createProducer " + session + " dest=" + destination));
            }
            MessageProducer result = session.createProducer(destination);
            result = new HornetQRAMessageProducer(result, this);
            if (trace) {
                log.trace((Object)("createdProducer " + session + " producer=" + result));
            }
            this.addProducer(result);
            MessageProducer messageProducer = result;
            return messageProducer;
        }
        finally {
            this.unlock();
        }
    }

    public int getAcknowledgeMode() throws JMSException {
        if (trace) {
            log.trace((Object)"getAcknowledgeMode()");
        }
        this.getSessionInternal();
        return this.cri.getAcknowledgeMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResource getXAResource() {
        if (trace) {
            log.trace((Object)"getXAResource()");
        }
        if (this.cri.getType() == 0 || this.cri.getType() == 1 || this.cri.getType() == 2) {
            return null;
        }
        try {
            this.lock();
            XAResource xAResource = this.getXAResourceInternal();
            return xAResource;
        }
        catch (Throwable t) {
            XAResource xAResource = null;
            return xAResource;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession() throws JMSException {
        if (trace) {
            log.trace((Object)"getSession()");
        }
        if (this.cri.getType() == 0 || this.cri.getType() == 1 || this.cri.getType() == 2) {
            throw new IllegalStateException("Non XA connection");
        }
        this.lock();
        try {
            HornetQRASession hornetQRASession = this;
            return hornetQRASession;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueSession getQueueSession() throws JMSException {
        if (trace) {
            log.trace((Object)"getQueueSession()");
        }
        if (this.cri.getType() == 0 || this.cri.getType() == 1 || this.cri.getType() == 2) {
            throw new IllegalStateException("Non XA connection");
        }
        this.lock();
        try {
            HornetQRASession hornetQRASession = this;
            return hornetQRASession;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSession getTopicSession() throws JMSException {
        if (trace) {
            log.trace((Object)"getTopicSession()");
        }
        if (this.cri.getType() == 0 || this.cri.getType() == 1 || this.cri.getType() == 2) {
            throw new IllegalStateException("Non XA connection");
        }
        this.lock();
        try {
            HornetQRASession hornetQRASession = this;
            return hornetQRASession;
        }
        finally {
            this.unlock();
        }
    }

    void setManagedConnection(HornetQRAManagedConnection managedConnection) {
        if (trace) {
            log.trace((Object)("setManagedConnection(" + managedConnection + ")"));
        }
        if (this.mc != null) {
            this.mc.removeHandle(this);
        }
        this.mc = managedConnection;
    }

    void destroy() {
        if (trace) {
            log.trace((Object)"destroy()");
        }
        this.mc = null;
    }

    void start() throws JMSException {
        if (trace) {
            log.trace((Object)"start()");
        }
        if (this.mc != null) {
            this.mc.start();
        }
    }

    void stop() throws JMSException {
        if (trace) {
            log.trace((Object)"stop()");
        }
        if (this.mc != null) {
            this.mc.stop();
        }
    }

    void checkStrict() throws JMSException {
        if (trace) {
            log.trace((Object)"checkStrict()");
        }
        if (this.mc != null) {
            throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeSession() throws JMSException {
        if (this.mc != null) {
            Iterator i;
            log.trace((Object)"Closing session");
            try {
                this.mc.stop();
            }
            catch (Throwable t) {
                log.trace((Object)"Error stopping managed connection", t);
            }
            Set t = this.consumers;
            synchronized (t) {
                i = this.consumers.iterator();
                while (i.hasNext()) {
                    HornetQRAMessageConsumer consumer = (HornetQRAMessageConsumer)i.next();
                    try {
                        consumer.closeConsumer();
                    }
                    catch (Throwable t2) {
                        log.trace((Object)"Error closing consumer", t2);
                    }
                    i.remove();
                }
            }
            t = this.producers;
            synchronized (t) {
                i = this.producers.iterator();
                while (i.hasNext()) {
                    HornetQRAMessageProducer producer = (HornetQRAMessageProducer)i.next();
                    try {
                        producer.closeProducer();
                    }
                    catch (Throwable t3) {
                        log.trace((Object)"Error closing producer", t3);
                    }
                    i.remove();
                }
            }
            this.mc.removeHandle(this);
            ConnectionEvent ev = new ConnectionEvent((ManagedConnection)this.mc, 1);
            ev.setConnectionHandle((Object)this);
            this.mc.sendEvent(ev);
            this.mc = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConsumer(MessageConsumer consumer) {
        if (trace) {
            log.trace((Object)("addConsumer(" + consumer + ")"));
        }
        Set set = this.consumers;
        synchronized (set) {
            this.consumers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConsumer(MessageConsumer consumer) {
        if (trace) {
            log.trace((Object)("removeConsumer(" + consumer + ")"));
        }
        Set set = this.consumers;
        synchronized (set) {
            this.consumers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProducer(MessageProducer producer) {
        if (trace) {
            log.trace((Object)("addProducer(" + producer + ")"));
        }
        Set set = this.producers;
        synchronized (set) {
            this.producers.add(producer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProducer(MessageProducer producer) {
        if (trace) {
            log.trace((Object)("removeProducer(" + producer + ")"));
        }
        Set set = this.producers;
        synchronized (set) {
            this.producers.remove(producer);
        }
    }

    Session getSessionInternal() throws JMSException {
        if (this.mc == null) {
            throw new IllegalStateException("The session is closed");
        }
        Session session = this.mc.getSession();
        if (trace) {
            log.trace((Object)("getSessionInternal " + session + " for " + this));
        }
        return session;
    }

    XAResource getXAResourceInternal() throws JMSException {
        if (this.mc == null) {
            throw new IllegalStateException("The session is closed");
        }
        try {
            XAResource xares = this.mc.getXAResource();
            if (trace) {
                log.trace((Object)("getXAResourceInternal " + xares + " for " + this));
            }
            return xares;
        }
        catch (ResourceException e) {
            JMSException jmse = new JMSException("Unable to get XA Resource");
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    QueueSession getQueueSessionInternal() throws JMSException {
        Session s = this.getSessionInternal();
        if (!(s instanceof QueueSession)) {
            throw new InvalidDestinationException("Attempting to use QueueSession methods on: " + this);
        }
        return (QueueSession)s;
    }

    TopicSession getTopicSessionInternal() throws JMSException {
        Session s = this.getSessionInternal();
        if (!(s instanceof TopicSession)) {
            throw new InvalidDestinationException("Attempting to use TopicSession methods on: " + this);
        }
        return (TopicSession)s;
    }

    public void checkState() throws JMSException {
        this.mc.checkTransactionActive();
    }
}

