/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config.impl;

import java.util.Collections;
import java.util.Set;
import junit.framework.Assert;
import org.hornetq.api.core.BroadcastGroupConfiguration;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.UDPBroadcastGroupConfiguration;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.config.DivertConfiguration;
import org.hornetq.core.config.impl.ConfigurationImplTest;
import org.hornetq.core.config.impl.FileConfiguration;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.settings.impl.AddressSettings;

public class FileConfigurationTest
extends ConfigurationImplTest {
    @Override
    public void testDefaults() {
        Assert.assertEquals((String)"SomeNameForUseOnTheApplicationServer", (String)this.conf.getName());
        Assert.assertEquals((boolean)false, (boolean)this.conf.isPersistenceEnabled());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isFileDeploymentEnabled());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isClustered());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isFileDeploymentEnabled());
        Assert.assertEquals((int)12345, (int)this.conf.getScheduledThreadPoolMaxSize());
        Assert.assertEquals((int)54321, (int)this.conf.getThreadPoolMaxSize());
        Assert.assertEquals((boolean)false, (boolean)this.conf.isSecurityEnabled());
        Assert.assertEquals((long)5423L, (long)this.conf.getSecurityInvalidationInterval());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isWildcardRoutingEnabled());
        Assert.assertEquals((Object)new SimpleString("Giraffe"), (Object)this.conf.getManagementAddress());
        Assert.assertEquals((Object)new SimpleString("Whatever"), (Object)this.conf.getManagementNotificationAddress());
        Assert.assertEquals((String)"Frog", (String)this.conf.getClusterUser());
        Assert.assertEquals((String)"Wombat", (String)this.conf.getClusterPassword());
        Assert.assertEquals((boolean)false, (boolean)this.conf.isJMXManagementEnabled());
        Assert.assertEquals((String)"gro.qtenroh", (String)this.conf.getJMXDomain());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isMessageCounterEnabled());
        Assert.assertEquals((int)5, (int)this.conf.getMessageCounterMaxDayHistory());
        Assert.assertEquals((long)123456L, (long)this.conf.getMessageCounterSamplePeriod());
        Assert.assertEquals((long)12345L, (long)this.conf.getConnectionTTLOverride());
        Assert.assertEquals((long)98765L, (long)this.conf.getTransactionTimeout());
        Assert.assertEquals((long)56789L, (long)this.conf.getTransactionTimeoutScanPeriod());
        Assert.assertEquals((long)10111213L, (long)this.conf.getMessageExpiryScanPeriod());
        Assert.assertEquals((int)8, (int)this.conf.getMessageExpiryThreadPriority());
        Assert.assertEquals((int)127, (int)this.conf.getIDCacheSize());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isPersistIDCache());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isBackup());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isSharedStore());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isPersistDeliveryCountBeforeDelivery());
        Assert.assertEquals((String)"pagingdir", (String)this.conf.getPagingDirectory());
        Assert.assertEquals((String)"somedir", (String)this.conf.getBindingsDirectory());
        Assert.assertEquals((boolean)false, (boolean)this.conf.isCreateBindingsDir());
        Assert.assertEquals((String)"max concurrent io", (int)17, (int)this.conf.getPageMaxConcurrentIO());
        Assert.assertEquals((String)"somedir2", (String)this.conf.getJournalDirectory());
        Assert.assertEquals((boolean)false, (boolean)this.conf.isCreateJournalDir());
        Assert.assertEquals((Object)JournalType.NIO, (Object)this.conf.getJournalType());
        Assert.assertEquals((int)10000, (int)this.conf.getJournalBufferSize_NIO());
        Assert.assertEquals((int)1000, (int)this.conf.getJournalBufferTimeout_NIO());
        Assert.assertEquals((int)56546, (int)this.conf.getJournalMaxIO_NIO());
        Assert.assertEquals((boolean)false, (boolean)this.conf.isJournalSyncTransactional());
        Assert.assertEquals((boolean)true, (boolean)this.conf.isJournalSyncNonTransactional());
        Assert.assertEquals((int)12345678, (int)this.conf.getJournalFileSize());
        Assert.assertEquals((int)100, (int)this.conf.getJournalMinFiles());
        Assert.assertEquals((int)123, (int)this.conf.getJournalCompactMinFiles());
        Assert.assertEquals((int)33, (int)this.conf.getJournalCompactPercentage());
        Assert.assertEquals((String)"largemessagesdir", (String)this.conf.getLargeMessagesDirectory());
        Assert.assertEquals((int)95, (int)this.conf.getMemoryWarningThreshold());
        Assert.assertEquals((int)2, (int)this.conf.getIncomingInterceptorClassNames().size());
        Assert.assertTrue((boolean)this.conf.getIncomingInterceptorClassNames().contains("org.hornetq.tests.unit.core.config.impl.TestInterceptor1"));
        Assert.assertTrue((boolean)this.conf.getIncomingInterceptorClassNames().contains("org.hornetq.tests.unit.core.config.impl.TestInterceptor2"));
        Assert.assertEquals((int)2, (int)this.conf.getConnectorConfigurations().size());
        TransportConfiguration tc = (TransportConfiguration)this.conf.getConnectorConfigurations().get("connector1");
        Assert.assertNotNull((Object)tc);
        Assert.assertEquals((String)"org.hornetq.tests.unit.core.config.impl.TestConnectorFactory1", (String)tc.getFactoryClassName());
        Assert.assertEquals((Object)"v1", tc.getParams().get("a1"));
        Assert.assertEquals((Object)"123", tc.getParams().get("a2"));
        Assert.assertEquals((Object)"345", tc.getParams().get("a3"));
        Assert.assertEquals((Object)"v4", tc.getParams().get("a4"));
        tc = (TransportConfiguration)this.conf.getConnectorConfigurations().get("connector2");
        Assert.assertNotNull((Object)tc);
        Assert.assertEquals((String)"org.hornetq.tests.unit.core.config.impl.TestConnectorFactory2", (String)tc.getFactoryClassName());
        Assert.assertEquals((Object)"w1", tc.getParams().get("b1"));
        Assert.assertEquals((Object)"234", tc.getParams().get("b2"));
        Assert.assertEquals((int)2, (int)this.conf.getAcceptorConfigurations().size());
        for (TransportConfiguration ac : this.conf.getAcceptorConfigurations()) {
            if (ac.getFactoryClassName().equals("org.hornetq.tests.unit.core.config.impl.TestAcceptorFactory1")) {
                Assert.assertEquals((String)"org.hornetq.tests.unit.core.config.impl.TestAcceptorFactory1", (String)ac.getFactoryClassName());
                Assert.assertEquals((Object)"y1", ac.getParams().get("d1"));
                Assert.assertEquals((Object)"456", ac.getParams().get("d2"));
                continue;
            }
            Assert.assertEquals((String)"org.hornetq.tests.unit.core.config.impl.TestAcceptorFactory2", (String)ac.getFactoryClassName());
            Assert.assertEquals((Object)"z1", ac.getParams().get("e1"));
            Assert.assertEquals((Object)"567", ac.getParams().get("e2"));
        }
        Assert.assertEquals((int)2, (int)this.conf.getBroadcastGroupConfigurations().size());
        for (BroadcastGroupConfiguration bc : this.conf.getBroadcastGroupConfigurations()) {
            UDPBroadcastGroupConfiguration udpBc = (UDPBroadcastGroupConfiguration)bc.getEndpointFactoryConfiguration();
            if (bc.getName().equals("bg1")) {
                Assert.assertEquals((String)"bg1", (String)bc.getName());
                Assert.assertEquals((int)10999, (int)udpBc.getLocalBindPort());
                Assert.assertEquals((String)"192.168.0.120", (String)udpBc.getGroupAddress());
                Assert.assertEquals((int)11999, (int)udpBc.getGroupPort());
                Assert.assertEquals((long)12345L, (long)bc.getBroadcastPeriod());
                Assert.assertEquals((String)"connector1", (String)((String)bc.getConnectorInfos().get(0)));
                continue;
            }
            Assert.assertEquals((String)"bg2", (String)bc.getName());
            Assert.assertEquals((int)12999, (int)udpBc.getLocalBindPort());
            Assert.assertEquals((String)"192.168.0.121", (String)udpBc.getGroupAddress());
            Assert.assertEquals((int)13999, (int)udpBc.getGroupPort());
            Assert.assertEquals((long)23456L, (long)bc.getBroadcastPeriod());
            Assert.assertEquals((String)"connector2", (String)((String)bc.getConnectorInfos().get(0)));
        }
        Assert.assertEquals((int)2, (int)this.conf.getDiscoveryGroupConfigurations().size());
        DiscoveryGroupConfiguration dc = (DiscoveryGroupConfiguration)this.conf.getDiscoveryGroupConfigurations().get("dg1");
        Assert.assertEquals((String)"dg1", (String)dc.getName());
        Assert.assertEquals((String)"192.168.0.120", (String)((UDPBroadcastGroupConfiguration)dc.getBroadcastEndpointFactoryConfiguration()).getGroupAddress());
        FileConfigurationTest.assertEquals((String)"172.16.8.10", (String)((UDPBroadcastGroupConfiguration)dc.getBroadcastEndpointFactoryConfiguration()).getLocalBindAddress());
        Assert.assertEquals((int)11999, (int)((UDPBroadcastGroupConfiguration)dc.getBroadcastEndpointFactoryConfiguration()).getGroupPort());
        Assert.assertEquals((long)12345L, (long)dc.getRefreshTimeout());
        dc = (DiscoveryGroupConfiguration)this.conf.getDiscoveryGroupConfigurations().get("dg2");
        Assert.assertEquals((String)"dg2", (String)dc.getName());
        Assert.assertEquals((String)"192.168.0.121", (String)((UDPBroadcastGroupConfiguration)dc.getBroadcastEndpointFactoryConfiguration()).getGroupAddress());
        FileConfigurationTest.assertEquals((String)"172.16.8.11", (String)((UDPBroadcastGroupConfiguration)dc.getBroadcastEndpointFactoryConfiguration()).getLocalBindAddress());
        Assert.assertEquals((int)12999, (int)((UDPBroadcastGroupConfiguration)dc.getBroadcastEndpointFactoryConfiguration()).getGroupPort());
        Assert.assertEquals((long)23456L, (long)dc.getRefreshTimeout());
        Assert.assertEquals((int)2, (int)this.conf.getDivertConfigurations().size());
        for (DivertConfiguration dic : this.conf.getDivertConfigurations()) {
            if (dic.getName().equals("divert1")) {
                Assert.assertEquals((String)"divert1", (String)dic.getName());
                Assert.assertEquals((String)"routing-name1", (String)dic.getRoutingName());
                Assert.assertEquals((String)"address1", (String)dic.getAddress());
                Assert.assertEquals((String)"forwarding-address1", (String)dic.getForwardingAddress());
                Assert.assertEquals((String)"speed > 88", (String)dic.getFilterString());
                Assert.assertEquals((String)"org.foo.Transformer", (String)dic.getTransformerClassName());
                Assert.assertEquals((boolean)true, (boolean)dic.isExclusive());
                continue;
            }
            Assert.assertEquals((String)"divert2", (String)dic.getName());
            Assert.assertEquals((String)"routing-name2", (String)dic.getRoutingName());
            Assert.assertEquals((String)"address2", (String)dic.getAddress());
            Assert.assertEquals((String)"forwarding-address2", (String)dic.getForwardingAddress());
            Assert.assertEquals((String)"speed < 88", (String)dic.getFilterString());
            Assert.assertEquals((String)"org.foo.Transformer2", (String)dic.getTransformerClassName());
            Assert.assertEquals((boolean)false, (boolean)dic.isExclusive());
        }
        Assert.assertEquals((int)2, (int)this.conf.getBridgeConfigurations().size());
        for (BridgeConfiguration bc : this.conf.getBridgeConfigurations()) {
            if (bc.getName().equals("bridge1")) {
                Assert.assertEquals((String)"bridge1", (String)bc.getName());
                Assert.assertEquals((String)"queue1", (String)bc.getQueueName());
                Assert.assertEquals((String)"minLargeMessageSize", (int)4, (int)bc.getMinLargeMessageSize());
                FileConfigurationTest.assertEquals((String)"check-period", (long)31L, (long)bc.getClientFailureCheckPeriod());
                FileConfigurationTest.assertEquals((String)"connection time-to-live", (long)370L, (long)bc.getConnectionTTL());
                Assert.assertEquals((String)"bridge-forwarding-address1", (String)bc.getForwardingAddress());
                Assert.assertEquals((String)"sku > 1", (String)bc.getFilterString());
                Assert.assertEquals((String)"org.foo.BridgeTransformer", (String)bc.getTransformerClassName());
                Assert.assertEquals((long)3L, (long)bc.getRetryInterval());
                Assert.assertEquals((double)0.2, (double)bc.getRetryIntervalMultiplier(), (double)1.0E-4);
                FileConfigurationTest.assertEquals((String)"max retry interval", (long)10002L, (long)bc.getMaxRetryInterval());
                Assert.assertEquals((int)2, (int)bc.getReconnectAttempts());
                Assert.assertEquals((boolean)true, (boolean)bc.isUseDuplicateDetection());
                Assert.assertEquals((String)"connector1", (String)((String)bc.getStaticConnectors().get(0)));
                Assert.assertEquals(null, (String)bc.getDiscoveryGroupName());
                continue;
            }
            Assert.assertEquals((String)"bridge2", (String)bc.getName());
            Assert.assertEquals((String)"queue2", (String)bc.getQueueName());
            Assert.assertEquals((String)"bridge-forwarding-address2", (String)bc.getForwardingAddress());
            Assert.assertEquals(null, (String)bc.getFilterString());
            Assert.assertEquals(null, (String)bc.getTransformerClassName());
            Assert.assertEquals(null, (Object)bc.getStaticConnectors());
            Assert.assertEquals((String)"dg1", (String)bc.getDiscoveryGroupName());
        }
        Assert.assertEquals((int)2, (int)this.conf.getClusterConfigurations().size());
        Assert.assertEquals((String)"replication cluster name", (String)"cluster-connection1", (String)this.conf.getReplicationClustername());
        for (ClusterConnectionConfiguration ccc : this.conf.getClusterConfigurations()) {
            if (ccc.getName().equals("cluster-connection1")) {
                Assert.assertEquals((String)"cluster-connection1", (String)ccc.getName());
                Assert.assertEquals((String)"clusterConnectionConf minLargeMessageSize", (int)321, (int)ccc.getMinLargeMessageSize());
                FileConfigurationTest.assertEquals((String)"check-period", (long)331L, (long)ccc.getClientFailureCheckPeriod());
                FileConfigurationTest.assertEquals((String)"connection time-to-live", (long)3370L, (long)ccc.getConnectionTTL());
                Assert.assertEquals((String)"queues1", (String)ccc.getAddress());
                Assert.assertEquals((long)3L, (long)ccc.getRetryInterval());
                Assert.assertEquals((boolean)true, (boolean)ccc.isDuplicateDetection());
                Assert.assertEquals((boolean)false, (boolean)ccc.isForwardWhenNoConsumers());
                Assert.assertEquals((int)1, (int)ccc.getMaxHops());
                Assert.assertEquals((long)123L, (long)ccc.getCallTimeout());
                Assert.assertEquals((long)123L, (long)ccc.getCallFailoverTimeout());
                FileConfigurationTest.assertEquals((String)"multiplier", (double)0.25, (double)ccc.getRetryIntervalMultiplier(), (double)1.0E-5);
                FileConfigurationTest.assertEquals((String)"max retry interval", (long)10000L, (long)ccc.getMaxRetryInterval());
                FileConfigurationTest.assertEquals((int)72, (int)ccc.getReconnectAttempts());
                Assert.assertEquals((String)"connector1", (String)((String)ccc.getStaticConnectors().get(0)));
                Assert.assertEquals((String)"connector2", (String)((String)ccc.getStaticConnectors().get(1)));
                Assert.assertEquals(null, (String)ccc.getDiscoveryGroupName());
                continue;
            }
            Assert.assertEquals((String)"cluster-connection2", (String)ccc.getName());
            Assert.assertEquals((String)"queues2", (String)ccc.getAddress());
            Assert.assertEquals((long)4L, (long)ccc.getRetryInterval());
            Assert.assertEquals((long)456L, (long)ccc.getCallTimeout());
            Assert.assertEquals((long)456L, (long)ccc.getCallFailoverTimeout());
            Assert.assertEquals((boolean)false, (boolean)ccc.isDuplicateDetection());
            Assert.assertEquals((boolean)true, (boolean)ccc.isForwardWhenNoConsumers());
            Assert.assertEquals((int)2, (int)ccc.getMaxHops());
            Assert.assertEquals(Collections.emptyList(), (Object)ccc.getStaticConnectors());
            Assert.assertEquals((String)"dg1", (String)ccc.getDiscoveryGroupName());
        }
        FileConfigurationTest.assertEquals((int)2, (int)this.conf.getAddressesSettings().size());
        FileConfigurationTest.assertTrue((this.conf.getAddressesSettings().get("a1") != null ? 1 : 0) != 0);
        FileConfigurationTest.assertTrue((this.conf.getAddressesSettings().get("a2") != null ? 1 : 0) != 0);
        FileConfigurationTest.assertEquals((String)"a1.1", (String)((AddressSettings)this.conf.getAddressesSettings().get("a1")).getDeadLetterAddress().toString());
        FileConfigurationTest.assertEquals((String)"a1.2", (String)((AddressSettings)this.conf.getAddressesSettings().get("a1")).getExpiryAddress().toString());
        FileConfigurationTest.assertEquals((long)1L, (long)((AddressSettings)this.conf.getAddressesSettings().get("a1")).getRedeliveryDelay());
        FileConfigurationTest.assertEquals((long)81781728121878L, (long)((AddressSettings)this.conf.getAddressesSettings().get("a1")).getMaxSizeBytes());
        FileConfigurationTest.assertEquals((long)81738173872337L, (long)((AddressSettings)this.conf.getAddressesSettings().get("a1")).getPageSizeBytes());
        FileConfigurationTest.assertEquals((int)10, (int)((AddressSettings)this.conf.getAddressesSettings().get("a1")).getPageCacheMaxSize());
        FileConfigurationTest.assertEquals((int)4, (int)((AddressSettings)this.conf.getAddressesSettings().get("a1")).getMessageCounterHistoryDayLimit());
        FileConfigurationTest.assertEquals((String)"a2.1", (String)((AddressSettings)this.conf.getAddressesSettings().get("a2")).getDeadLetterAddress().toString());
        FileConfigurationTest.assertEquals((String)"a2.2", (String)((AddressSettings)this.conf.getAddressesSettings().get("a2")).getExpiryAddress().toString());
        FileConfigurationTest.assertEquals((long)5L, (long)((AddressSettings)this.conf.getAddressesSettings().get("a2")).getRedeliveryDelay());
        FileConfigurationTest.assertEquals((long)932489234928324L, (long)((AddressSettings)this.conf.getAddressesSettings().get("a2")).getMaxSizeBytes());
        FileConfigurationTest.assertEquals((long)7126716262626L, (long)((AddressSettings)this.conf.getAddressesSettings().get("a2")).getPageSizeBytes());
        FileConfigurationTest.assertEquals((int)20, (int)((AddressSettings)this.conf.getAddressesSettings().get("a2")).getPageCacheMaxSize());
        FileConfigurationTest.assertEquals((int)8, (int)((AddressSettings)this.conf.getAddressesSettings().get("a2")).getMessageCounterHistoryDayLimit());
        FileConfigurationTest.assertEquals((int)2, (int)this.conf.getQueueConfigurations().size());
        FileConfigurationTest.assertEquals((String)"queue1", (String)((CoreQueueConfiguration)this.conf.getQueueConfigurations().get(0)).getName());
        FileConfigurationTest.assertEquals((String)"address1", (String)((CoreQueueConfiguration)this.conf.getQueueConfigurations().get(0)).getAddress());
        FileConfigurationTest.assertEquals((String)"color='red'", (String)((CoreQueueConfiguration)this.conf.getQueueConfigurations().get(0)).getFilterString());
        FileConfigurationTest.assertEquals((boolean)false, (boolean)((CoreQueueConfiguration)this.conf.getQueueConfigurations().get(0)).isDurable());
        FileConfigurationTest.assertEquals((String)"queue2", (String)((CoreQueueConfiguration)this.conf.getQueueConfigurations().get(1)).getName());
        FileConfigurationTest.assertEquals((String)"address2", (String)((CoreQueueConfiguration)this.conf.getQueueConfigurations().get(1)).getAddress());
        FileConfigurationTest.assertEquals((String)"color='blue'", (String)((CoreQueueConfiguration)this.conf.getQueueConfigurations().get(1)).getFilterString());
        FileConfigurationTest.assertEquals((boolean)false, (boolean)((CoreQueueConfiguration)this.conf.getQueueConfigurations().get(1)).isDurable());
        FileConfigurationTest.assertEquals((int)2, (int)this.conf.getSecurityRoles().size());
        FileConfigurationTest.assertTrue((boolean)this.conf.getSecurityRoles().containsKey("a1"));
        FileConfigurationTest.assertTrue((boolean)this.conf.getSecurityRoles().containsKey("a2"));
        Role a1Role = ((Set)this.conf.getSecurityRoles().get("a1")).toArray(new Role[1])[0];
        FileConfigurationTest.assertFalse((boolean)a1Role.isSend());
        FileConfigurationTest.assertFalse((boolean)a1Role.isConsume());
        FileConfigurationTest.assertFalse((boolean)a1Role.isCreateDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a1Role.isDeleteDurableQueue());
        FileConfigurationTest.assertTrue((boolean)a1Role.isCreateNonDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a1Role.isDeleteNonDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a1Role.isManage());
        Role a2Role = ((Set)this.conf.getSecurityRoles().get("a2")).toArray(new Role[1])[0];
        FileConfigurationTest.assertFalse((boolean)a2Role.isSend());
        FileConfigurationTest.assertFalse((boolean)a2Role.isConsume());
        FileConfigurationTest.assertFalse((boolean)a2Role.isCreateDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a2Role.isDeleteDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a2Role.isCreateNonDurableQueue());
        FileConfigurationTest.assertTrue((boolean)a2Role.isDeleteNonDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a2Role.isManage());
    }

    public void testSetGetConfigurationURL() {
        String file = "ghuuhhu";
        FileConfiguration fc = new FileConfiguration();
        fc.setConfigurationUrl("ghuuhhu");
        Assert.assertEquals((String)"ghuuhhu", (String)fc.getConfigurationUrl());
    }

    @Override
    protected Configuration createConfiguration() throws Exception {
        FileConfiguration fc = new FileConfiguration("ConfigurationTest-full-config.xml");
        fc.start();
        return fc;
    }
}

