/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.filter.impl;

import java.util.HashSet;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.impl.Operator;

public class OperatorTest
extends TestCase {
    private static void assertSuccess(int op, Object arg1, Object expectedResult) throws Exception {
        OperatorTest.assertOperationSuccess(new Operator(op, arg1), expectedResult);
    }

    private static void assertSuccess(int op, Object arg1, Object arg2, Object expectedResult) throws Exception {
        OperatorTest.assertOperationSuccess(new Operator(op, arg1, arg2), expectedResult);
    }

    private static void assertSuccess(int op, Object arg1, Object arg2, Object arg3, Object expectedResult) throws Exception {
        OperatorTest.assertOperationSuccess(new Operator(op, arg1, arg2, arg3), expectedResult);
    }

    private static void assertOperationSuccess(Operator operator, Object expectedResult) throws Exception {
        Assert.assertEquals((Object)expectedResult, (Object)operator.apply());
    }

    private static void assertFailure(int op, Object arg1) throws Exception {
        OperatorTest.assertOperationFailure(new Operator(op, arg1));
    }

    private static void assertFailure(int op, Object arg1, Object arg2) throws Exception {
        OperatorTest.assertOperationFailure(new Operator(op, arg1, arg2));
    }

    private static void assertFailure(int op, Object arg1, Object arg2, Object arg3) throws Exception {
        OperatorTest.assertOperationFailure(new Operator(op, arg1, arg2, arg3));
    }

    private static void assertOperationFailure(Operator operator) {
        try {
            operator.apply();
            Assert.fail((String)"expected to throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void test_EQUAL() throws Exception {
        OperatorTest.assertSuccess(0, 1, 1, true);
        OperatorTest.assertSuccess(0, 1, 1.0, true);
        OperatorTest.assertSuccess(0, 1, null, null);
        OperatorTest.assertSuccess(0, 1.0, 1, true);
        OperatorTest.assertSuccess(0, 1.0, 1.0, true);
        OperatorTest.assertSuccess(0, 1.0, null, null);
        OperatorTest.assertSuccess(0, false, false, true);
        OperatorTest.assertSuccess(0, true, false, false);
        OperatorTest.assertSuccess(0, false, true, false);
        OperatorTest.assertSuccess(0, true, true, true);
        SimpleString foo = new SimpleString("foo");
        SimpleString foo2 = new SimpleString("foo");
        SimpleString bar = new SimpleString("bar");
        OperatorTest.assertSuccess(0, foo, foo, true);
        OperatorTest.assertSuccess(0, foo, foo2, true);
        OperatorTest.assertSuccess(0, foo, bar, false);
        OperatorTest.assertSuccess(0, foo, null, false);
        OperatorTest.assertSuccess(0, null, 1.0, false);
    }

    public void test_DIFFERENT() throws Exception {
        OperatorTest.assertSuccess(8, 2, 1, true);
        OperatorTest.assertSuccess(8, 2, 1.0, true);
        OperatorTest.assertSuccess(8, 2, null, null);
        OperatorTest.assertSuccess(8, 2.0, 1, true);
        OperatorTest.assertSuccess(8, 2.0, 1.0, true);
        OperatorTest.assertSuccess(8, 2.0, null, null);
        OperatorTest.assertSuccess(8, false, false, false);
        OperatorTest.assertSuccess(8, true, false, true);
        OperatorTest.assertSuccess(8, false, true, true);
        OperatorTest.assertSuccess(8, true, true, false);
        SimpleString foo = new SimpleString("foo");
        SimpleString foo2 = new SimpleString("foo");
        SimpleString bar = new SimpleString("bar");
        OperatorTest.assertSuccess(8, foo, foo, false);
        OperatorTest.assertSuccess(8, foo, foo2, false);
        OperatorTest.assertSuccess(8, foo, bar, true);
        OperatorTest.assertSuccess(8, foo, null, null);
        OperatorTest.assertSuccess(8, null, 1.0, true);
        OperatorTest.assertSuccess(8, null, null, false);
    }

    public void test_IS_NULL() throws Exception {
        OperatorTest.assertSuccess(20, null, true);
        OperatorTest.assertSuccess(20, 1, false);
    }

    public void test_IS_NOT_NULL() throws Exception {
        OperatorTest.assertSuccess(21, null, false);
        OperatorTest.assertSuccess(21, 1, true);
    }

    public void test_ADD() throws Exception {
        OperatorTest.assertSuccess(9, 1, 1, 2L);
        OperatorTest.assertSuccess(9, 1.0, 1, 2.0);
        OperatorTest.assertSuccess(9, 1, 1.0, 2.0);
        OperatorTest.assertSuccess(9, 1.0, 1.0, 2.0);
        OperatorTest.assertFailure(9, true, 1.0);
        OperatorTest.assertFailure(9, 1, true);
    }

    public void test_SUB() throws Exception {
        OperatorTest.assertSuccess(10, 2, 1, 1L);
        OperatorTest.assertSuccess(10, 2.0, 1, 1.0);
        OperatorTest.assertSuccess(10, 2, 1.0, 1.0);
        OperatorTest.assertSuccess(10, 2.0, 1.0, 1.0);
        OperatorTest.assertFailure(10, true, 1.0);
        OperatorTest.assertFailure(10, 1, true);
    }

    public void test_MUL() throws Exception {
        OperatorTest.assertSuccess(12, 2, 1, 2L);
        OperatorTest.assertSuccess(12, 2.0, 1, 2.0);
        OperatorTest.assertSuccess(12, 2, 1.0, 2.0);
        OperatorTest.assertSuccess(12, 2.0, 1.0, 2.0);
        OperatorTest.assertSuccess(12, 2, null, null);
        OperatorTest.assertSuccess(12, null, 1.0, null);
        OperatorTest.assertFailure(12, true, 1.0);
        OperatorTest.assertFailure(12, 1, true);
    }

    public void test_DIV() throws Exception {
        OperatorTest.assertSuccess(13, 2, 2, 1L);
        OperatorTest.assertSuccess(13, 2.0, 2, 1.0);
        OperatorTest.assertSuccess(13, 2, 2.0, 1.0);
        OperatorTest.assertSuccess(13, 2.0, 2.0, 1.0);
        OperatorTest.assertSuccess(13, 2, null, null);
        OperatorTest.assertSuccess(13, null, 1.0, null);
        OperatorTest.assertFailure(13, true, 1.0);
        OperatorTest.assertFailure(13, 1, true);
    }

    public void test_NEG() throws Exception {
        OperatorTest.assertSuccess(11, 1, -1L);
        OperatorTest.assertSuccess(11, -1.0, 1.0);
        OperatorTest.assertFailure(11, true);
    }

    public void test_AND() throws Exception {
        OperatorTest.assertSuccess(2, null, null, null);
        OperatorTest.assertSuccess(2, null, false, false);
        OperatorTest.assertSuccess(2, null, true, null);
        OperatorTest.assertSuccess(2, false, null, false);
        OperatorTest.assertSuccess(2, false, false, false);
        OperatorTest.assertSuccess(2, false, true, false);
        OperatorTest.assertSuccess(2, true, null, null);
        OperatorTest.assertSuccess(2, true, false, false);
        OperatorTest.assertSuccess(2, true, true, true);
        OperatorTest.assertFailure(2, 1.0, true);
        OperatorTest.assertFailure(2, true, 1.0);
        OperatorTest.assertFailure(2, null, 1.0);
    }

    public void test_OR() throws Exception {
        OperatorTest.assertSuccess(3, null, null, null);
        OperatorTest.assertSuccess(3, null, false, null);
        OperatorTest.assertSuccess(3, null, true, true);
        OperatorTest.assertSuccess(3, false, null, null);
        OperatorTest.assertSuccess(3, false, false, false);
        OperatorTest.assertSuccess(3, false, true, true);
        OperatorTest.assertSuccess(3, true, null, true);
        OperatorTest.assertSuccess(3, true, false, true);
        OperatorTest.assertSuccess(3, true, true, true);
        OperatorTest.assertFailure(3, 1.0, true);
        OperatorTest.assertFailure(3, false, 1.0);
        OperatorTest.assertFailure(3, null, 1.0);
    }

    public void test_NOT() throws Exception {
        OperatorTest.assertSuccess(1, null, null);
        OperatorTest.assertSuccess(1, false, true);
        OperatorTest.assertSuccess(1, true, false);
        OperatorTest.assertFailure(1, 1.0);
    }

    public void test_GT() throws Exception {
        OperatorTest.assertSuccess(4, 2, 1, true);
        OperatorTest.assertSuccess(4, 2.0, 1, true);
        OperatorTest.assertSuccess(4, 2, 1.0, true);
        OperatorTest.assertSuccess(4, 2.0, 1.0, true);
        OperatorTest.assertSuccess(4, 2.0, true, false);
        OperatorTest.assertSuccess(4, 2, null, null);
        OperatorTest.assertSuccess(4, true, 1.0, false);
        OperatorTest.assertSuccess(4, null, 1, null);
        OperatorTest.assertSuccess(4, true, true, false);
        OperatorTest.assertSuccess(4, null, null, null);
    }

    public void test_GE() throws Exception {
        OperatorTest.assertSuccess(5, 1, 1, true);
        OperatorTest.assertSuccess(5, 1.0, 1, true);
        OperatorTest.assertSuccess(5, 1, 1.0, true);
        OperatorTest.assertSuccess(5, 1.0, 1.0, true);
        OperatorTest.assertSuccess(5, 2.0, true, false);
        OperatorTest.assertSuccess(5, 2, null, null);
        OperatorTest.assertSuccess(5, true, 1.0, false);
        OperatorTest.assertSuccess(5, null, 1, null);
        OperatorTest.assertSuccess(5, true, true, false);
        OperatorTest.assertSuccess(5, null, null, null);
    }

    public void test_LT() throws Exception {
        OperatorTest.assertSuccess(6, 1, 2, true);
        OperatorTest.assertSuccess(6, 1.0, 2, true);
        OperatorTest.assertSuccess(6, 1, 2.0, true);
        OperatorTest.assertSuccess(6, 1.0, 2.0, true);
        OperatorTest.assertSuccess(6, 1.0, true, false);
        OperatorTest.assertSuccess(6, 1, null, null);
        OperatorTest.assertSuccess(6, true, 2.0, false);
        OperatorTest.assertSuccess(6, null, 2, null);
        OperatorTest.assertSuccess(6, true, true, false);
        OperatorTest.assertSuccess(6, null, null, null);
    }

    public void test_LE() throws Exception {
        OperatorTest.assertSuccess(7, 1, 1, true);
        OperatorTest.assertSuccess(7, 1.0, 1, true);
        OperatorTest.assertSuccess(7, 1, 1.0, true);
        OperatorTest.assertSuccess(7, 1.0, 1.0, true);
        OperatorTest.assertSuccess(7, 1.0, true, false);
        OperatorTest.assertSuccess(7, 1, null, null);
        OperatorTest.assertSuccess(7, true, 1.0, false);
        OperatorTest.assertSuccess(7, null, 1, null);
        OperatorTest.assertSuccess(7, true, true, false);
        OperatorTest.assertSuccess(7, null, null, null);
    }

    public void test_BETWEEN() throws Exception {
        OperatorTest.assertSuccess(14, 2, 1, 3, true);
        OperatorTest.assertSuccess(14, 2.0, 1.0, 3.0, true);
        OperatorTest.assertSuccess(14, true, 1, 3, false);
        OperatorTest.assertSuccess(14, null, null, 3, null);
    }

    public void test_NOT_BETWEEN() throws Exception {
        OperatorTest.assertSuccess(15, 2, 3, 4, true);
        OperatorTest.assertSuccess(15, 2.0, 3.0, 4.0, true);
        OperatorTest.assertSuccess(15, true, 1, 3, false);
        OperatorTest.assertSuccess(15, null, null, 3, null);
    }

    public void test_IN() throws Exception {
        HashSet<SimpleString> set = new HashSet<SimpleString>();
        set.add(new SimpleString("foo"));
        set.add(new SimpleString("bar"));
        set.add(new SimpleString("baz"));
        SimpleString foo = new SimpleString("foo");
        OperatorTest.assertSuccess(22, foo, set, true);
        OperatorTest.assertSuccess(22, foo, new HashSet(), false);
        OperatorTest.assertFailure(22, true, set);
    }

    public void test_NOT_IN() throws Exception {
        HashSet<SimpleString> set = new HashSet<SimpleString>();
        set.add(new SimpleString("foo"));
        set.add(new SimpleString("bar"));
        set.add(new SimpleString("baz"));
        SimpleString foo = new SimpleString("foo");
        OperatorTest.assertSuccess(23, foo, set, false);
        OperatorTest.assertSuccess(23, foo, new HashSet(), true);
        OperatorTest.assertFailure(23, true, set);
    }

    public void test_LIKE() throws Exception {
        SimpleString pattern = new SimpleString("12%3");
        OperatorTest.assertSuccess(16, new SimpleString("123"), pattern, true);
        OperatorTest.assertSuccess(16, new SimpleString("12993"), pattern, true);
        OperatorTest.assertSuccess(16, new SimpleString("1234"), pattern, false);
        pattern = new SimpleString("l_se");
        OperatorTest.assertSuccess(16, new SimpleString("lose"), pattern, true);
        OperatorTest.assertSuccess(16, new SimpleString("loose"), pattern, false);
        OperatorTest.assertSuccess(16, null, pattern, null);
    }

    public void test_LIKE_ESCAPE() throws Exception {
        SimpleString pattern = new SimpleString("\\_%");
        SimpleString escapeChar = new SimpleString("\\");
        OperatorTest.assertSuccess(18, new SimpleString("_foo"), pattern, escapeChar, true);
        OperatorTest.assertSuccess(18, new SimpleString("bar"), pattern, escapeChar, false);
        OperatorTest.assertSuccess(18, null, pattern, escapeChar, null);
        OperatorTest.assertFailure(18, new SimpleString("_foo"), pattern, new SimpleString("must be a single char"));
    }

    public void test_NOT_LIKE() throws Exception {
        SimpleString pattern = new SimpleString("12%3");
        OperatorTest.assertSuccess(17, new SimpleString("123"), pattern, false);
        OperatorTest.assertSuccess(17, new SimpleString("12993"), pattern, false);
        OperatorTest.assertSuccess(17, new SimpleString("1234"), pattern, true);
        OperatorTest.assertSuccess(17, null, pattern, null);
    }

    public void test_NOT_LIKE_ESCAPE() throws Exception {
        SimpleString pattern = new SimpleString("\\_%");
        SimpleString escapeChar = new SimpleString("\\");
        OperatorTest.assertSuccess(19, new SimpleString("_foo"), pattern, escapeChar, false);
        OperatorTest.assertSuccess(19, new SimpleString("bar"), pattern, escapeChar, true);
        OperatorTest.assertSuccess(19, null, pattern, escapeChar, null);
        OperatorTest.assertFailure(19, new SimpleString("_foo"), pattern, new SimpleString("must be a single char"));
    }
}

