/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.utils.UUID;
import org.hornetq.utils.UUIDGenerator;

public abstract class NodeManager
implements HornetQComponent {
    protected static final byte FIRST_TIME_START = 48;
    private static final String SERVER_LOCK_NAME = "server.lock";
    private static final String ACCESS_MODE = "rw";
    protected final boolean replicatedBackup;
    private final String directory;
    private final Object nodeIDGuard = new Object();
    private SimpleString nodeID;
    private UUID uuid;
    private String nodeGroupName;
    private boolean isStarted = false;
    protected FileChannel channel;

    public NodeManager(boolean replicatedBackup, String directory) {
        this.directory = directory;
        this.replicatedBackup = replicatedBackup;
    }

    public abstract void awaitLiveNode() throws Exception;

    public abstract void startBackup() throws Exception;

    public abstract void startLiveNode() throws Exception;

    public abstract void pauseLiveServer() throws Exception;

    public abstract void crashLiveServer() throws Exception;

    public abstract void releaseBackup() throws Exception;

    public synchronized void start() throws Exception {
        this.isStarted = true;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleString getNodeId() {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            return this.nodeID;
        }
    }

    public abstract SimpleString readNodeId() throws HornetQIllegalStateException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getUUID() {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            return this.uuid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeID(String nodeID) {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            this.nodeID = new SimpleString(nodeID);
            this.uuid = new UUID(1, UUID.stringToBytes((String)nodeID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUUID(UUID generateUUID) {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            this.uuid = generateUUID;
            this.nodeID = new SimpleString(this.uuid.toString());
        }
    }

    public void setNodeGroupName(String nodeGroupName) {
        this.nodeGroupName = nodeGroupName;
    }

    public String getNodeGroupName() {
        return this.nodeGroupName;
    }

    public abstract boolean isAwaitingFailback() throws Exception;

    public abstract boolean isBackupLive() throws Exception;

    public abstract void interrupt();

    public synchronized void stop() throws Exception {
        FileChannel channelCopy = this.channel;
        if (channelCopy != null) {
            channelCopy.close();
        }
        this.isStarted = false;
    }

    public final void stopBackup() throws Exception {
        if (this.replicatedBackup && this.getNodeId() != null) {
            this.setUpServerLockFile();
        }
        this.releaseBackup();
    }

    protected final synchronized void setUpServerLockFile() throws IOException {
        File serverLockFile = this.newFile(SERVER_LOCK_NAME);
        boolean fileCreated = false;
        int count = 0;
        while (!serverLockFile.exists()) {
            try {
                fileCreated = serverLockFile.createNewFile();
            }
            catch (RuntimeException e) {
                HornetQServerLogger.LOGGER.nodeManagerCantOpenFile(e, serverLockFile);
                throw e;
            }
            catch (IOException e) {
                if (count < 5) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++count;
                    continue;
                }
                HornetQServerLogger.LOGGER.nodeManagerCantOpenFile(e, serverLockFile);
                throw e;
            }
            if (fileCreated) continue;
            throw new IllegalStateException("Unable to create server lock file");
        }
        RandomAccessFile raFile = new RandomAccessFile(serverLockFile, ACCESS_MODE);
        this.channel = raFile.getChannel();
        if (fileCreated) {
            ByteBuffer id = ByteBuffer.allocateDirect(3);
            byte[] bytes = new byte[]{48, 48, 48};
            id.put(bytes, 0, 3);
            id.position(0);
            this.channel.write(id, 0L);
            this.channel.force(true);
        }
        this.createNodeId();
    }

    protected final File newFile(String fileName) {
        File file = new File(this.directory, fileName);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void createNodeId() throws IOException {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            ByteBuffer id = ByteBuffer.allocateDirect(16);
            int read = this.channel.read(id, 3L);
            if (this.replicatedBackup) {
                id.position(0);
                id.put(this.getUUID().asBytes(), 0, 16);
                id.position(0);
                this.channel.write(id, 3L);
                this.channel.force(true);
            } else if (read != 16) {
                this.setUUID(UUIDGenerator.getInstance().generateUUID());
                id.put(this.getUUID().asBytes(), 0, 16);
                id.position(0);
                this.channel.write(id, 3L);
                this.channel.force(true);
            } else {
                byte[] bytes = new byte[16];
                id.position(0);
                id.get(bytes);
                this.setUUID(new UUID(1, bytes));
            }
        }
    }
}

