/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.FileConfiguration;
import org.hornetq.core.deployers.impl.FileConfigurationParser;
import org.hornetq.tests.util.UnitTestCase;
import org.hornetq.utils.DefaultSensitiveStringCodec;
import org.junit.Test;
import org.xml.sax.SAXParseException;

public class FileConfigurationParserTest
extends UnitTestCase {
    private static String firstPart = "<configuration xmlns=\"urn:hornetq\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"urn:hornetq /schema/hornetq-configuration.xsd\">\n<name>HornetQ.main.config</name>\n<backup-group-name>anodegroupname</backup-group-name>\n<log-delegate-factory-class-name>org.hornetq.integration.logging.Log4jLogDelegateFactory</log-delegate-factory-class-name>\n<bindings-directory>${jboss.server.data.dir}/hornetq/bindings</bindings-directory>\n<journal-directory>${jboss.server.data.dir}/hornetq/journal</journal-directory>\n<journal-min-files>10</journal-min-files>\n<large-messages-directory>${jboss.server.data.dir}/hornetq/largemessages</large-messages-directory>\n<paging-directory>${jboss.server.data.dir}/hornetq/paging</paging-directory>\n<connectors>\n<connector name=\"netty\">\n<factory-class>org.hornetq.core.remoting.impl.netty.NettyConnectorFactory</factory-class>\n<param key=\"host\"  value=\"${jboss.bind.address:localhost}\"/>\n<param key=\"port\"  value=\"${hornetq.remoting.netty.port:5445}\"/>\n</connector>\n<connector name=\"netty-throughput\">\n<factory-class>org.hornetq.core.remoting.impl.netty.NettyConnectorFactory</factory-class>\n<param key=\"host\"  value=\"${jboss.bind.address:localhost}\"/>\n<param key=\"port\"  value=\"${hornetq.remoting.netty.batch.port:5455}\"/>\n<param key=\"batch-delay\" value=\"50\"/>\n</connector>\n<connector name=\"in-vm\">\n<factory-class>org.hornetq.core.remoting.impl.invm.InVMConnectorFactory</factory-class>\n<param key=\"server-id\" value=\"${hornetq.server-id:0}\"/>\n</connector>\n</connectors>\n<acceptors>\n<acceptor name=\"netty\">\n<factory-class>org.hornetq.core.remoting.impl.netty.NettyAcceptorFactory</factory-class>\n<param key=\"host\"  value=\"${jboss.bind.address:localhost}\"/>\n<param key=\"port\"  value=\"${hornetq.remoting.netty.port:5445}\"/>\n</acceptor>\n<acceptor name=\"netty-throughput\">\n<factory-class>org.hornetq.core.remoting.impl.netty.NettyAcceptorFactory</factory-class>\n<param key=\"host\"  value=\"${jboss.bind.address:localhost}\"/>\n<param key=\"port\"  value=\"${hornetq.remoting.netty.batch.port:5455}\"/>\n<param key=\"batch-delay\" value=\"50\"/>\n<param key=\"direct-deliver\" value=\"false\"/>\n</acceptor>\n<acceptor name=\"in-vm\">\n<factory-class>org.hornetq.core.remoting.impl.invm.InVMAcceptorFactory</factory-class>\n<param key=\"server-id\" value=\"0\"/>\n</acceptor>\n</acceptors>\n<security-settings>\n<security-setting match=\"#\">\n<permission type=\"createNonDurableQueue\" roles=\"guest\"/>\n<permission type=\"deleteNonDurableQueue\" roles=\"guest\"/>\n<permission type=\"createDurableQueue\" roles=\"guest\"/>\n<permission type=\"deleteDurableQueue\" roles=\"guest\"/>\n<permission type=\"consume\" roles=\"guest\"/>\n<permission type=\"send\" roles=\"guest\"/>\n</security-setting>\n</security-settings>\n<address-settings>\n<address-setting match=\"#\">\n<dead-letter-address>jms.queue.DLQ\n</dead-letter-address>\n<expiry-address>jms.queue.ExpiryQueue\n</expiry-address>\n<redelivery-delay>0\n</redelivery-delay>\n<max-size-bytes>10485760\n</max-size-bytes>\n<message-counter-history-day-limit>10</message-counter-history-day-limit>\n<address-full-policy>BLOCK</address-full-policy>\n</address-setting>\n</address-settings><backup-servers><backup-server name=\"myBackup\" port-offset=\"200\"/></backup-servers>";
    private static String lastPart = "</configuration>";

    @Test
    public void testSchemaValidation() throws Exception {
        for (int i = 0; i < 6; ++i) {
            String filename = "InvalidConfigurationTest" + i + ".xml";
            FileConfiguration fc = new FileConfiguration(filename);
            try {
                fc.start();
                FileConfigurationParserTest.fail((String)("parsing should have failed for " + filename));
                continue;
            }
            catch (IllegalStateException e) {
                Throwable cause = e.getCause();
                FileConfigurationParserTest.assertTrue((String)"must have been org.xml.sax.SAXParseException", (boolean)(cause instanceof SAXParseException));
            }
        }
    }

    @Test
    public void testDivertRoutingNameIsNotRequired() throws Exception {
        String filename = "divertRoutingNameNotRequired.xml";
        FileConfiguration fc = new FileConfiguration(filename);
        fc.start();
    }

    @Test
    public void testParsingDefaultServerConfig() throws Exception {
        FileConfigurationParser parser = new FileConfigurationParser();
        String configStr = firstPart + lastPart;
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration config = parser.parseMainConfig((InputStream)input);
        String clusterPassword = config.getClusterPassword();
        FileConfigurationParserTest.assertEquals((Object)HornetQDefaultConfiguration.getDefaultClusterPassword(), (Object)clusterPassword);
        String clusterPasswordPart = "<cluster-password>helloworld</cluster-password>";
        configStr = firstPart + clusterPasswordPart + lastPart;
        config = parser.parseMainConfig((InputStream)new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8)));
        FileConfigurationParserTest.assertEquals((Object)"helloworld", (Object)config.getClusterPassword());
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        String mask = (String)codec.encode("helloworld");
        String maskPasswordPart = "<mask-password>true</mask-password>";
        clusterPasswordPart = "<cluster-password>" + mask + "</cluster-password>";
        configStr = firstPart + clusterPasswordPart + maskPasswordPart + lastPart;
        config = parser.parseMainConfig((InputStream)new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8)));
        FileConfigurationParserTest.assertEquals((Object)"helloworld", (Object)config.getClusterPassword());
        codec = new DefaultSensitiveStringCodec();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("key", "newkey");
        codec.init(prop);
        mask = (String)codec.encode("newpassword");
        clusterPasswordPart = "<cluster-password>" + mask + "</cluster-password>";
        String codecPart = "<password-codec>org.hornetq.utils.DefaultSensitiveStringCodec;key=newkey</password-codec>";
        configStr = firstPart + clusterPasswordPart + maskPasswordPart + codecPart + lastPart;
        config = parser.parseMainConfig((InputStream)new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8)));
        FileConfigurationParserTest.assertEquals((Object)"newpassword", (Object)config.getClusterPassword());
        FileConfigurationParserTest.assertEquals((Object)"anodegroupname", (Object)config.getBackupGroupName());
    }
}

