/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.tests.util;

import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import org.hornetq.core.asyncio.impl.AsynchronousFileImpl;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.FileConfiguration;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.NodeManager;
import org.hornetq.core.server.impl.AIOFileLockNodeManager;
import org.hornetq.core.server.impl.FileLockNodeManager;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.spi.core.security.HornetQSecurityManager;

public class ColocatedHornetQServer
extends HornetQServerImpl {
    private final NodeManager nodeManagerLive;
    private final NodeManager nodeManagerBackup;
    boolean backup = false;
    public ColocatedHornetQServer backupServer;

    public ColocatedHornetQServer(FileConfiguration fc, HornetQSecurityManager sm, NodeManager nodeManagerLive, NodeManager nodeManagerBackup) {
        super((Configuration)fc, sm);
        this.nodeManagerLive = nodeManagerLive;
        this.nodeManagerBackup = nodeManagerBackup;
    }

    public ColocatedHornetQServer(Configuration backupServerConfiguration, HornetQServer parentServer, NodeManager nodeManagerBackup, NodeManager nodeManagerLive) {
        super(backupServerConfiguration, null, null, parentServer);
        this.nodeManagerLive = nodeManagerLive;
        this.nodeManagerBackup = nodeManagerBackup;
    }

    public ColocatedHornetQServer(Configuration configuration, MBeanServer platformMBeanServer, HornetQSecurityManager securityManager, NodeManager nodeManagerLive, NodeManager nodeManagerBackup) {
        super(configuration, platformMBeanServer, securityManager);
        this.nodeManagerLive = nodeManagerLive;
        this.nodeManagerBackup = nodeManagerBackup;
    }

    protected NodeManager createNodeManager(String directory, String nodeGroupName, boolean replicatingBackup) {
        if (replicatingBackup) {
            if (this.getConfiguration().getJournalType() == JournalType.ASYNCIO && AsynchronousFileImpl.isLoaded()) {
                return new AIOFileLockNodeManager(directory, replicatingBackup);
            }
            return new FileLockNodeManager(directory, replicatingBackup);
        }
        if (this.backup) {
            this.nodeManagerBackup.setNodeGroupName(nodeGroupName);
            return this.nodeManagerBackup;
        }
        this.nodeManagerLive.setNodeGroupName(nodeGroupName);
        return this.nodeManagerLive;
    }

    protected void startBackupServers(Configuration configuration, Map<String, HornetQServer> backupServers) {
        Set backupServerConfigurations = configuration.getBackupServerConfigurations();
        for (Configuration backupServerConfiguration : backupServerConfigurations) {
            ColocatedHornetQServer backup = new ColocatedHornetQServer(backupServerConfiguration, (HornetQServer)this, this.nodeManagerBackup, this.nodeManagerLive);
            backup.backup = true;
            this.backupServer = backup;
            backupServers.put(backupServerConfiguration.getName(), (HornetQServer)backup);
        }
        for (HornetQServer hornetQServer : backupServers.values()) {
            try {
                hornetQServer.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

