/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionInfo;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.io.IOException;
import java.io.PrintWriter;

public class ActionHierarchy {
    public static final int DEFAULT_HIERARCHY_DEPTH = 5;
    private ActionInfo[] hierarchy;
    private int maxHierarchyDepth;
    private int currentDepth;

    public ActionHierarchy(int depth) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("ActionHierarchy::ActionHierarchy(" + depth + ")");
        }
        this.hierarchy = null;
        this.maxHierarchyDepth = depth;
        this.currentDepth = 0;
        if (this.maxHierarchyDepth > 0) {
            this.hierarchy = new ActionInfo[this.maxHierarchyDepth];
            for (int i = 0; i < this.maxHierarchyDepth; ++i) {
                this.hierarchy[i] = null;
            }
        }
    }

    public ActionHierarchy(ActionHierarchy theCopy) {
        int i;
        this.hierarchy = null;
        this.maxHierarchyDepth = theCopy.maxHierarchyDepth;
        this.currentDepth = theCopy.currentDepth;
        if (this.maxHierarchyDepth > 0) {
            this.hierarchy = new ActionInfo[this.maxHierarchyDepth];
            for (i = 0; i < this.maxHierarchyDepth; ++i) {
                this.hierarchy[i] = null;
            }
        }
        for (i = 0; i < this.currentDepth; ++i) {
            this.hierarchy[i] = new ActionInfo(theCopy.hierarchy[i]);
        }
    }

    public void print(PrintWriter strm) {
        strm.println("\tCurrent depth : " + this.currentDepth);
        if (this.currentDepth == 0) {
            strm.println("\tAction Uids : NULL");
        } else {
            strm.println("\tAction Uids :");
            for (int i = 0; i < this.currentDepth; ++i) {
                strm.println("\t\t" + this.hierarchy[i].actionUid);
            }
        }
    }

    public synchronized void copy(ActionHierarchy c) {
        int i;
        if (this == c) {
            return;
        }
        if (this.hierarchy != null) {
            this.hierarchy = null;
        }
        this.currentDepth = c.currentDepth;
        this.maxHierarchyDepth = c.maxHierarchyDepth;
        if (this.maxHierarchyDepth > 0) {
            this.hierarchy = new ActionInfo[this.maxHierarchyDepth];
            for (i = 0; i < this.maxHierarchyDepth; ++i) {
                this.hierarchy[i] = null;
            }
        }
        for (i = 0; i < this.currentDepth; ++i) {
            this.hierarchy[i] = new ActionInfo(c.hierarchy[i]);
        }
    }

    public final boolean equals(ActionHierarchy other) {
        boolean same = true;
        if (this.currentDepth == other.depth()) {
            for (int i = 0; i < this.currentDepth; ++i) {
                if (!this.hierarchy[i].notEquals(other.getActionInfo(i))) continue;
                same = false;
                break;
            }
        } else {
            same = false;
        }
        return same;
    }

    public final boolean add(Uid actionId) {
        return this.add(actionId, 0);
    }

    public final boolean add(Uid actionId, int at) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("ActionHierarchy::add(" + actionId + ", " + at + ")");
        }
        boolean result = true;
        if (this.currentDepth >= this.maxHierarchyDepth) {
            ActionInfo[] newHier = null;
            int newDepth = (this.maxHierarchyDepth + 1) * 2;
            newHier = new ActionInfo[newDepth];
            if (newHier != null) {
                int i;
                this.maxHierarchyDepth = newDepth;
                for (i = 0; i < this.currentDepth; ++i) {
                    newHier[i] = this.hierarchy[i];
                }
                for (i = this.currentDepth; i < newDepth; ++i) {
                    newHier[i] = null;
                }
                this.hierarchy = newHier;
                newHier = null;
            } else {
                result = false;
            }
        }
        if (result) {
            if (this.hierarchy[this.currentDepth] == null) {
                this.hierarchy[this.currentDepth] = new ActionInfo();
            }
            this.hierarchy[this.currentDepth].actionUid = new Uid(actionId);
            ++this.currentDepth;
            this.hierarchy[this.currentDepth].actionType = at;
        }
        return result;
    }

    public final boolean isAncestor(Uid target) {
        boolean result = false;
        for (int i = this.currentDepth - 1; i >= 0 && !result; --i) {
            if (this.hierarchy[i].actionUid.equals(target)) {
                result = true;
                break;
            }
            if (this.hierarchy[i].actionType == 0) break;
        }
        return result;
    }

    public void pack(OutputBuffer state) throws IOException {
        state.packInt(this.currentDepth);
        for (int i = 0; i < this.currentDepth; ++i) {
            UidHelper.packInto(this.hierarchy[i].actionUid, state);
            state.packInt(this.hierarchy[i].actionType);
        }
    }

    public void unpack(InputBuffer state) throws IOException {
        int newDepth = 0;
        ActionHierarchy newHier = null;
        ActionInfo temp = new ActionInfo();
        newDepth = state.unpackInt();
        try {
            newHier = new ActionHierarchy(newDepth);
        }
        catch (OutOfMemoryError ex) {
            IOException ioException = new IOException(tsLogger.i18NLogger.get_coordinator_ActionHierarchy_1());
            ioException.initCause(ex);
            throw ioException;
        }
        for (int i = 0; i < newDepth; ++i) {
            temp.actionUid = UidHelper.unpackFrom(state);
            temp.actionType = state.unpackInt();
            newHier.add(temp.actionUid, temp.actionType);
        }
        this.hierarchy = newHier.hierarchy;
        this.currentDepth = newHier.currentDepth;
        this.maxHierarchyDepth = newHier.maxHierarchyDepth;
        newHier.hierarchy = null;
        newHier = null;
    }

    public final void forgetDeepest() {
        if (this.currentDepth > 0) {
            this.hierarchy[--this.currentDepth] = null;
        }
    }

    public final int findCommonPrefix(ActionHierarchy oldHierarchy) {
        int common;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("ActionHierarchy::findCommonPrefix()");
        }
        int max = oldHierarchy.depth();
        for (common = 0; common < this.currentDepth && common < max && this.hierarchy[common].equals(oldHierarchy.getActionInfo(common)); ++common) {
        }
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("ActionHierarchy::::findCommonPrefix(): prefix is " + common);
        }
        return common;
    }

    public final synchronized int depth() {
        return this.currentDepth;
    }

    public final synchronized Uid getDeepestActionUid() {
        if (this.currentDepth > 0) {
            return this.hierarchy[this.currentDepth - 1].actionUid;
        }
        return Uid.nullUid();
    }

    public final synchronized Uid getActionUid(int typeIndex) {
        return this.hierarchy[typeIndex].actionUid;
    }

    public final synchronized ActionInfo getActionInfo(int typeIndex) {
        return this.hierarchy[typeIndex];
    }
}

