/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreIterator;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.tools.osb.mbean.OSEntryBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBrowserMBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.UidWrapper;
import com.arjuna.ats.arjuna.tools.osb.util.JMXServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObjStoreBrowser
implements ObjStoreBrowserMBean {
    public static final String OBJ_STORE_BROWSER_HANDLERS = "com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBrowserHandlers";
    private static final String STORE_MBEAN_NAME = "jboss.jta:type=ObjectStore";
    private static final String saaStateType = "com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.SubordinateAtomicAction";
    private static final String saaBeanType = "com.arjuna.ats.internal.jta.tools.osb.mbean.jta.SubordinateActionBean";
    private static final String defaultStateHandlers = "com.arjuna.ats.arjuna.AtomicAction=com.arjuna.ats.internal.jta.tools.osb.mbean.jta.JTAActionBean,com.arjuna.ats.internal.jta.tools.osb.mbean.jts.ArjunaTransactionImpleWrapper=com.arjuna.ats.arjuna.tools.osb.mbean.ActionBean";
    private Map<String, String> stateTypes = null;
    private Map<String, String> beanTypes = null;
    private Map<String, List<UidWrapper>> allUids;
    private boolean exposeAllLogs = false;

    public void start() {
        JMXServer.getAgent().registerMBean(STORE_MBEAN_NAME, this);
    }

    public void stop() {
        for (List<UidWrapper> uids : this.allUids.values()) {
            Iterator<UidWrapper> i = uids.iterator();
            while (i.hasNext()) {
                UidWrapper w = i.next();
                i.remove();
                w.unregister();
            }
        }
        JMXServer.getAgent().unregisterMBean(STORE_MBEAN_NAME);
    }

    @Deprecated
    public void setTypes(Map<String, String> types) {
    }

    public boolean setType(String osTypeClassName, String beanTypeClassName) {
        String typeName = this.getOSType(osTypeClassName);
        if (typeName != null) {
            if (typeName.startsWith("/")) {
                typeName = typeName.substring(1);
            }
            this.stateTypes.put(typeName, osTypeClassName);
            this.beanTypes.put(typeName, beanTypeClassName);
            return true;
        }
        return false;
    }

    private void initTypeHandlers(String handlers) {
        for (String h : handlers.split(",")) {
            String typeName;
            String[] handler = h.split("=");
            if (handler.length != 2 || (typeName = this.getOSType(handler[0])) == null) continue;
            if (typeName.startsWith("/")) {
                typeName = typeName.substring(1);
            }
            this.stateTypes.put(typeName, handler[0]);
            this.beanTypes.put(typeName, handler[1]);
        }
    }

    private void init(String logDir) {
        if (logDir != null) {
            arjPropertyManager.getObjectStoreEnvironmentBean().setObjectStoreDir(logDir);
        }
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("ObjectStoreDir: " + arjPropertyManager.getObjectStoreEnvironmentBean().getObjectStoreDir());
        }
        this.allUids = new HashMap<String, List<UidWrapper>>();
        this.stateTypes = new HashMap<String, String>();
        this.beanTypes = new HashMap<String, String>();
        this.initTypeHandlers(defaultStateHandlers);
        this.initTypeHandlers(System.getProperty(OBJ_STORE_BROWSER_HANDLERS, ""));
    }

    public ObjStoreBrowser() {
        this.init(null);
    }

    public ObjStoreBrowser(String logDir) {
        this.init(logDir);
    }

    public StringBuilder dump(StringBuilder sb) {
        for (Map.Entry<String, List<UidWrapper>> typeEntry : this.allUids.entrySet()) {
            sb.append(typeEntry.getKey()).append('\n');
            for (UidWrapper uid : typeEntry.getValue()) {
                uid.toString("\t", sb);
            }
        }
        return sb;
    }

    public UidWrapper findUid(Uid uid) {
        return this.findUid(uid.stringForm());
    }

    public UidWrapper findUid(String uid) {
        for (Map.Entry<String, List<UidWrapper>> typeEntry : this.allUids.entrySet()) {
            for (UidWrapper w : typeEntry.getValue()) {
                if (!w.getUid().stringForm().equals(uid)) continue;
                return w;
            }
        }
        return null;
    }

    private String getOSType(String classType) {
        try {
            Class<?> cls = Class.forName(classType);
            StateManager sm = (StateManager)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            return sm.type();
        }
        catch (Exception e) {
            if (tsLogger.logger.isDebugEnabled()) {
                tsLogger.logger.debug("Invalid class type in system property ObjStoreBrowserHandlers: " + classType);
            }
            return null;
        }
    }

    @Override
    public void probe() {
        block7: {
            InputObjectState types = new InputObjectState();
            try {
                String tname;
                if (!StoreManager.getRecoveryStore().allTypes(types)) break block7;
                do {
                    List<UidWrapper> uids;
                    try {
                        tname = types.unpackString();
                    }
                    catch (IOException e1) {
                        tname = "";
                    }
                    if (tname.length() == 0 || (uids = this.allUids.get(tname)) != null) continue;
                    uids = new ArrayList<UidWrapper>();
                    this.allUids.put(tname, uids);
                } while (tname.length() != 0);
            }
            catch (ObjectStoreException e2) {
                if (!tsLogger.logger.isTraceEnabled()) break block7;
                tsLogger.logger.trace(e2.toString());
            }
        }
        for (String tname : this.allUids.keySet()) {
            List<UidWrapper> uids = this.allUids.get(tname);
            if (uids == null) {
                uids = new ArrayList<UidWrapper>();
                this.allUids.put(tname, uids);
            }
            if (!this.exposeAllLogs && !this.beanTypes.containsKey(tname)) continue;
            this.updateMBeans(uids, System.currentTimeMillis(), true, tname);
        }
    }

    @Override
    public void viewSubordinateAtomicActions(boolean enable) {
        if (enable) {
            this.setType(saaStateType, saaBeanType);
        } else {
            String typeName = this.getOSType(saaStateType);
            if (typeName != null) {
                if (typeName.startsWith("/")) {
                    typeName = typeName.substring(1);
                }
                this.stateTypes.remove(typeName);
                this.beanTypes.remove(typeName);
                for (List<UidWrapper> uids : this.allUids.values()) {
                    Iterator<UidWrapper> i = uids.iterator();
                    while (i.hasNext()) {
                        UidWrapper w = i.next();
                        if (!saaStateType.equals(w.getClassName())) continue;
                        i.remove();
                        w.unregister();
                    }
                }
            }
        }
    }

    @Override
    public void setExposeAllRecordsAsMBeans(boolean exposeAllLogs) {
        this.exposeAllLogs = exposeAllLogs;
    }

    public List<UidWrapper> probe(String type) {
        if (!this.allUids.containsKey(type)) {
            block7: {
                InputObjectState types = new InputObjectState();
                try {
                    String tname;
                    if (!StoreManager.getRecoveryStore().allTypes(types)) break block7;
                    do {
                        List<UidWrapper> uids;
                        try {
                            tname = types.unpackString();
                        }
                        catch (IOException e1) {
                            tname = "";
                        }
                        if (tname.length() == 0 || (uids = this.allUids.get(tname)) != null) continue;
                        uids = new ArrayList<UidWrapper>();
                        this.allUids.put(tname, uids);
                    } while (tname.length() != 0);
                }
                catch (ObjectStoreException e2) {
                    if (!tsLogger.logger.isTraceEnabled()) break block7;
                    tsLogger.logger.trace(e2.toString());
                }
            }
            if (!this.allUids.containsKey(type)) {
                return null;
            }
        }
        List<UidWrapper> uids = this.allUids.get(type);
        this.updateMBeans(uids, System.currentTimeMillis(), false, type);
        return uids;
    }

    private String getBeanType(String type) {
        if (this.beanTypes.containsKey(type)) {
            return this.beanTypes.get(type);
        }
        return OSEntryBean.class.getName();
    }

    private void updateMBeans(List<UidWrapper> uids, long tstamp, boolean register, String type) {
        UidWrapper w;
        Uid u;
        ObjectStoreIterator iter = new ObjectStoreIterator(StoreManager.getRecoveryStore(), type);
        while ((u = iter.iterate()) != null && !Uid.nullUid().equals(u)) {
            w = new UidWrapper(this, this.getBeanType(type), type, this.stateTypes.get(type), u);
            int i = uids.indexOf(w);
            if (i == -1) {
                w.setTimestamp(tstamp);
                uids.add(w);
                w.createMBean();
                if (!register) continue;
                w.register();
                continue;
            }
            uids.get(i).setTimestamp(tstamp);
        }
        Iterator<UidWrapper> i = uids.iterator();
        while (i.hasNext()) {
            w = i.next();
            if (w.getTimestamp() == tstamp) continue;
            if (register) {
                w.unregister();
            }
            i.remove();
        }
    }
}

