/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.tools.osb.mbean.OSEntryBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBrowser;
import java.lang.reflect.Constructor;
import java.util.List;

public class UidWrapper {
    private String name;
    private ObjStoreBrowser browser;
    private String beantype;
    private String className;
    private String ostype;
    private Uid uid;
    private long tstamp;
    private OSEntryBean mbean;

    public UidWrapper(Uid uid) {
        this.uid = uid;
        this.name = "";
        this.beantype = "";
        this.ostype = "";
        this.className = null;
    }

    public OSEntryBean getMBean() {
        return this.mbean;
    }

    public UidWrapper(ObjStoreBrowser browser, String beantype, String ostype, String className, Uid uid) {
        this.browser = browser;
        this.ostype = ostype;
        this.beantype = beantype;
        this.className = className;
        this.uid = uid;
        this.tstamp = 0L;
        this.name = "jboss.jta:type=ObjectStore,itype=" + ostype + ",uid=" + uid.fileStringForm();
    }

    public void probe() {
        this.browser.probe();
    }

    public String getType() {
        return this.ostype;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    void register() {
        this.mbean.register();
    }

    void unregister() {
        this.mbean.unregister();
    }

    public long getTimestamp() {
        return this.tstamp;
    }

    public void setTimestamp(long tstamp) {
        this.tstamp = tstamp;
    }

    public Uid getUid() {
        return this.uid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UidWrapper that = (UidWrapper)o;
        return !(this.uid == null ? that.uid != null : !this.uid.equals(that.uid));
    }

    public int hashCode() {
        return this.uid != null ? this.uid.hashCode() : 0;
    }

    public String toString() {
        return "UidWrapper{ostype='" + this.ostype + '\'' + ", uid=" + this.uid + ", tstamp=" + this.tstamp + '}';
    }

    public StringBuilder toString(String prefix, StringBuilder sb) {
        return this.mbean.toString(prefix, sb);
    }

    public List<UidWrapper> probe(String type) {
        return this.browser.probe(type);
    }

    public OSEntryBean createMBean() {
        try {
            Class<?> cl = Class.forName(this.beantype);
            Constructor<?> constructor = cl.getConstructor(UidWrapper.class);
            this.mbean = (OSEntryBean)constructor.newInstance(this);
        }
        catch (Throwable e) {
            tsLogger.i18NLogger.info_osb_MBeanCtorFail(e);
            this.mbean = new OSEntryBean(this);
        }
        this.mbean.activate();
        return this.mbean;
    }
}

