/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.abstractrecords;

import com.arjuna.ats.arjuna.ObjectType;
import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.abstractrecords.StateManagerFriend;
import java.io.PrintWriter;

public class ActivationRecord
extends AbstractRecord {
    private StateManager objectAddr;
    private BasicAction actionHandle;
    private int state;

    public ActivationRecord(int st, StateManager sm, BasicAction action) {
        super(sm.get_uid(), sm.type(), 1);
        this.objectAddr = sm;
        this.actionHandle = action;
        this.state = st;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("ActivationRecord::ActivationRecord(" + this.state + ", " + sm.get_uid() + ")");
        }
    }

    @Override
    public int typeIs() {
        return 131;
    }

    @Override
    public Object value() {
        return new Integer(this.state);
    }

    @Override
    public void setValue(Object v) {
        tsLogger.i18NLogger.warn_ActivationRecord_1();
    }

    @Override
    public int nestedAbort() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("ActivationRecord::nestedAbort() for " + this.order());
        }
        int outcome = 8;
        if (this.objectAddr != null && this.actionHandle != null) {
            outcome = StateManagerFriend.forgetAction(this.objectAddr, this.actionHandle, false, 131) ? 7 : 8;
        }
        return outcome;
    }

    @Override
    public int nestedCommit() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("ActivationRecord::nestedCommit() for " + this.order());
        }
        return 7;
    }

    @Override
    public int nestedPrepare() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("ActivationRecord::nestedPrepare() for " + this.order());
        }
        if (this.objectAddr != null && this.actionHandle != null) {
            int state = this.objectAddr.status();
            if (StateManagerFriend.forgetAction(this.objectAddr, this.actionHandle, true, 131)) {
                this.actionHandle = this.actionHandle.parent();
                if (StateManagerFriend.rememberAction(this.objectAddr, this.actionHandle, 131, state)) {
                    return 2;
                }
            }
        }
        return 8;
    }

    @Override
    public int topLevelAbort() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("ActivationRecord::topLevelAbort() for " + this.order());
        }
        return this.nestedAbort();
    }

    @Override
    public int topLevelCommit() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("ActivationRecord::topLevelCommit() for " + this.order());
        }
        if (this.objectAddr != null && this.actionHandle != null) {
            return StateManagerFriend.forgetAction(this.objectAddr, this.actionHandle, true, 131) ? 7 : 8;
        }
        return 8;
    }

    @Override
    public int topLevelPrepare() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("ActivationRecord::topLevelPrepare() for " + this.order());
        }
        if (this.objectAddr == null) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean restore_state(InputObjectState os, int v) {
        tsLogger.i18NLogger.warn_ActivationRecord_2(this.type(), this.order());
        return false;
    }

    public boolean save_state(OutputObjectState os, ObjectType v) {
        return true;
    }

    @Override
    public void print(PrintWriter strm) {
        super.print(strm);
        strm.println("ActivationRecord with state:\n" + this.state);
    }

    @Override
    public String type() {
        return "/StateManager/AbstractRecord/ActivationRecord";
    }

    @Override
    public void merge(AbstractRecord a) {
    }

    @Override
    public void alter(AbstractRecord a) {
    }

    @Override
    public boolean shouldAdd(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldReplace(AbstractRecord a) {
        return false;
    }

    public ActivationRecord() {
        this.objectAddr = null;
        this.actionHandle = null;
        this.state = 0;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("ActivationRecord::ActivationRecord()");
        }
    }
}

