/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.Service;
import com.arjuna.ats.internal.arjuna.recovery.Connection;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.List;

public class Listener
extends Thread {
    private ServerSocket _listener_socket;
    private int _listener_port;
    private boolean _stop_listener = false;
    private int _listener_socket_timeout_in_msecs = 1500;
    private Service _listener_service;
    private List<Socket> connections;
    private static boolean setTimeout = false;

    public Listener(int port, Service service) throws IOException {
        super("Listener:" + port);
        this._listener_port = port;
        this._listener_service = service;
        this._listener_socket = new ServerSocket(this._listener_port);
        if (setTimeout) {
            this._listener_socket.setSoTimeout(this._listener_socket_timeout_in_msecs);
        }
        this.connections = new LinkedList<Socket>();
    }

    public Listener(ServerSocket serverSocket, Service service) throws IOException {
        super("Listener:" + serverSocket.getLocalPort());
        this._listener_port = serverSocket.getLocalPort();
        this._listener_service = service;
        this._listener_socket = serverSocket;
        if (setTimeout) {
            this._listener_socket.setSoTimeout(this._listener_socket_timeout_in_msecs);
        }
        this.connections = new LinkedList<Socket>();
    }

    @Override
    public void run() {
        while (!this.stopRequested()) {
            try {
                final Socket conn = this._listener_socket.accept();
                if (!this.addConnection(conn)) continue;
                Connection.Callback callback = new Connection.Callback(){
                    private Socket _conn;
                    {
                        this._conn = conn;
                    }

                    @Override
                    public void run() {
                        Listener.this.removeConnection(this._conn);
                    }
                };
                Connection new_conn = new Connection(conn, this._listener_service, callback);
                if (tsLogger.logger.isDebugEnabled()) {
                    tsLogger.logger.debug("Connected to " + conn.getInetAddress().getHostAddress() + " on port " + conn.getPort() + " on listener port " + conn.getLocalPort() + " for service " + this._listener_service.getClass().getName());
                }
                new_conn.start();
            }
            catch (InterruptedIOException ex) {
            }
            catch (SocketException ex) {
                if (!tsLogger.logger.isDebugEnabled()) continue;
                tsLogger.logger.debug("Recovery listener existing " + this._listener_service.getClass().getName());
            }
            catch (IOException ex) {
                if (!tsLogger.logger.isDebugEnabled()) continue;
                tsLogger.logger.debug("Listener - IOException " + ex);
            }
            catch (Exception exception) {}
        }
    }

    public synchronized boolean addConnection(Socket conn) {
        if (!this._stop_listener) {
            this.connections.add(conn);
            return true;
        }
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public synchronized void removeConnection(Socket conn) {
        this.connections.remove(conn);
        this.notifyAll();
    }

    public synchronized void stopListener() {
        this._stop_listener = true;
        try {
            this._listener_socket.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        while (this.connections.size() > 0) {
            Socket conn = this.connections.get(0);
            try {
                conn.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized boolean stopRequested() {
        return this._stop_listener;
    }

    static {
        setTimeout = recoveryPropertyManager.getRecoveryEnvironmentBean().isTimeoutSocket();
    }
}

