/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.resources.arjunacore;

import com.arjuna.ats.arjuna.coordinator.OnePhaseResource;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.ClassloadingUtility;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.utils.XAHelper;
import com.arjuna.ats.jta.xa.RecoverableXAConnection;
import com.arjuna.ats.jta.xa.XidImple;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAOnePhaseResource
implements OnePhaseResource {
    private XAResource xaResource;
    private RecoverableXAConnection recoverableXAConnection;
    private Xid xid;

    public XAOnePhaseResource() {
    }

    public XAOnePhaseResource(XAResource xaResource, Xid xid, Object[] params) {
        Object param;
        this.xaResource = xaResource;
        this.xid = xid;
        if (params != null && params.length >= 0 && (param = params[0]) instanceof RecoverableXAConnection) {
            this.recoverableXAConnection = (RecoverableXAConnection)param;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int commit() {
        boolean doForget = false;
        try {
            this.xaResource.commit(this.xid, true);
            int n = 7;
            return n;
        }
        catch (XAException xae) {
            if (jtaLogger.logger.isTraceEnabled()) {
                jtaLogger.logger.trace("XAOnePhaseResource.commit(" + this.xid + ") " + xae.getMessage());
            }
            jtaLogger.i18NLogger.warn_resources_arjunacore_opcerror(XAHelper.xidToString(this.xid), this.xaResource.toString(), XAHelper.printXAErrorCode(xae), xae);
            switch (xae.errorCode) {
                case 5: 
                case 8: {
                    int ex = 6;
                    return ex;
                }
                case 7: {
                    doForget = true;
                    int ex = 7;
                    return ex;
                }
                case 6: {
                    doForget = true;
                    int ex = 10;
                    return ex;
                }
                case -3: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    int ex = 10;
                    return ex;
                }
                case -4: {
                    int ex = 6;
                    return ex;
                }
                case -5: {
                    int ex = 6;
                    return ex;
                }
                case -6: 
                case 4: {
                    int ex = 10;
                    return ex;
                }
            }
            int ex = 8;
            return ex;
        }
        catch (Throwable ex) {
            String resourceString;
            String xidString = this.xid == null ? "<  >" : XAHelper.xidToString(this.xid);
            String string = resourceString = this.xaResource == null ? "null XA resource" : this.xaResource.toString();
            if (jtaLogger.logger.isTraceEnabled()) {
                jtaLogger.logger.trace("XAOnePhaseResource.commit(" + this.xid + ") " + ex.getMessage());
            }
            jtaLogger.i18NLogger.warn_resources_arjunacore_commitxaerror(xidString, resourceString, "-", ex);
        }
        finally {
            block49: {
                try {
                    if (doForget) {
                        this.xaResource.forget(this.xid);
                    }
                }
                catch (Throwable ex) {
                    if (!jtaLogger.logger.isTraceEnabled()) break block49;
                    jtaLogger.logger.trace("XAOnePhaseResource.commit(" + this.xid + ") called forget and got " + ex.getMessage());
                }
            }
        }
        return 10;
    }

    @Override
    public int rollback() {
        block3: {
            try {
                this.xaResource.rollback(this.xid);
                return 7;
            }
            catch (XAException xae) {
                jtaLogger.i18NLogger.warn_resources_arjunacore_XAOnePhaseResource_rollbackexception(XAHelper.xidToString(this.xid), xae);
            }
            catch (Throwable ex) {
                if (!jtaLogger.logger.isTraceEnabled()) break block3;
                jtaLogger.logger.trace("XAOnePhaseResource.rollback(" + this.xid + ") " + ex.getMessage());
            }
        }
        return 8;
    }

    @Override
    public void pack(OutputObjectState os) throws IOException {
        XidImple.pack(os, this.xid);
        if (this.recoverableXAConnection != null) {
            os.packInt(0);
            os.packString(this.recoverableXAConnection.getClass().getName());
            this.recoverableXAConnection.packInto(os);
        } else {
            byte[] data;
            os.packInt(1);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this.xaResource);
                oos.flush();
                oos.close();
                data = baos.toByteArray();
            }
            catch (IOException ioe) {
                String message = jtaLogger.i18NLogger.get_resources_arjunacore_XAOnePhaseResource_pack();
                IOException ioException = new IOException(message);
                ioException.initCause(ioe);
                throw ioException;
            }
            os.packBytes(data);
        }
    }

    @Override
    public void unpack(InputObjectState is) throws IOException {
        XidImple.unpack(is);
        int recoveryType = is.unpackInt();
        switch (recoveryType) {
            case 0: {
                String recoverableXAConnectionClassName = is.unpackString();
                this.recoverableXAConnection = ClassloadingUtility.loadAndInstantiateClass(RecoverableXAConnection.class, recoverableXAConnectionClassName, null);
                if (this.recoverableXAConnection == null) {
                    throw XAOnePhaseResource.generateUnpackError(new ClassNotFoundException());
                }
                this.recoverableXAConnection.unpackFrom(is);
                try {
                    this.xaResource = this.recoverableXAConnection.getResource();
                    break;
                }
                catch (SQLException sqle) {
                    throw XAOnePhaseResource.generateUnpackError(sqle);
                }
            }
            case 1: {
                byte[] data = is.unpackBytes();
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    this.xaResource = (XAResource)ois.readObject();
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    throw XAOnePhaseResource.generateUnpackError(cnfe);
                }
                catch (IOException ioe) {
                    throw XAOnePhaseResource.generateUnpackError(ioe);
                }
                catch (ClassCastException cce) {
                    throw XAOnePhaseResource.generateUnpackError(cce);
                }
            }
            default: {
                String message = jtaLogger.i18NLogger.get_resources_arjunacore_XAOnePhaseResource_unpackType(Integer.toString(recoveryType));
                throw new IOException(message);
            }
        }
    }

    public String toString() {
        return "XAOnePhaseResource(" + this.xaResource + ")";
    }

    private static IOException generateUnpackError(Exception ex) {
        String message = jtaLogger.i18NLogger.get_resources_arjunacore_XAOnePhaseResource_unpack();
        return new IOException(message, ex);
    }
}

