/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.objectstore.ParticipantStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jts.Implementations;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators.JacOrbRCDefaultServant;
import com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators.JacOrbRCShutdown;
import com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators.ORBRunner;
import com.arjuna.ats.internal.jts.recovery.recoverycoordinators.GenericRecoveryCreator;
import com.arjuna.ats.internal.jts.recovery.recoverycoordinators.RecoveryServiceInit;
import com.arjuna.ats.jts.common.jtsPropertyManager;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.orbportability.OA;
import com.arjuna.orbportability.ORB;
import com.arjuna.orbportability.RootOA;
import java.util.Properties;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class JacOrbRCServiceInit
implements RecoveryServiceInit {
    private static final String POA_NAME_PREFIX = "RcvCo-";
    protected static POA _poa = null;
    protected static ORB _orb = null;
    protected static RootOA _oa = null;
    protected static String uid4Recovery = "0:ffff52e38d0c:c91:4140398c:0";
    private static java.lang.Object orbRunnerLock = new java.lang.Object();
    private static ORBRunner _runOA;

    private static POA getRCPOA() {
        String rcServiceName = GenericRecoveryCreator.getRecCoordServiceName();
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("JacOrbRCServiceInit.getRCPOA " + rcServiceName);
        }
        if (_poa == null) {
            String domainName = "recovery_coordinator";
            String poaName = POA_NAME_PREFIX + rcServiceName + domainName;
            try {
                POA rootPOA = _oa.rootPoa();
                if (rootPOA == null) {
                    jtsLogger.i18NLogger.warn_orbspecific_jacorb_recoverycoordinators_JacOrbRCServiceInit_8();
                    return null;
                }
                Policy[] policies = null;
                policies = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT)};
                _poa = rootPOA.create_POA(poaName, rootPOA.the_POAManager(), policies);
            }
            catch (Exception ex) {
                jtsLogger.i18NLogger.warn_orbspecific_jacorb_recoverycoordinators_JacOrbRCServiceInit_1(ex);
            }
        }
        return _poa;
    }

    private static void initORBandOA() throws InvalidName {
        if (!ORBManager.isInitialised()) {
            _orb = ORB.getInstance("RecoveryServer");
            String recoveryManagerPort = "" + jtsPropertyManager.getJTSEnvironmentBean().getRecoveryManagerPort();
            String recoveryManagerAddr = jtsPropertyManager.getJTSEnvironmentBean().getRecoveryManagerAddress();
            jtsLogger.i18NLogger.info_orbspecific_jacorb_recoverycoordinators_JacOrbRCServiceInit_6(recoveryManagerPort, recoveryManagerAddr);
            Properties p = new Properties();
            p.setProperty("OAPort", recoveryManagerPort);
            if (recoveryManagerAddr != null && recoveryManagerAddr.length() > 0) {
                p.setProperty("OAIAddr", recoveryManagerAddr);
            }
            try {
                _orb.initORB((String[])null, p);
                _oa = OA.getRootOA(_orb);
                _oa.initOA();
            }
            catch (RuntimeException e) {
                ORBManager.reset();
                _orb.shutdown();
                throw e;
            }
            ORBManager.setORB(_orb);
            ORBManager.setPOA(_oa);
        } else {
            _orb = ORBManager.getORB();
            _oa = (RootOA)ORBManager.getPOA();
            jtsLogger.i18NLogger.info_orbspecific_jacorb_recoverycoordinators_JacOrbRCServiceInit_6a();
        }
        ORBManager.getPOA().addPreShutdown(new JacOrbRCShutdown());
    }

    @Override
    public boolean startRCservice() {
        try {
            JacOrbRCServiceInit.initORBandOA();
            POA ourPOA = JacOrbRCServiceInit.getRCPOA();
            if (ourPOA == null) {
                return false;
            }
            Implementations.initialise();
            JacOrbRCDefaultServant theButler = new JacOrbRCDefaultServant(_orb.orb());
            ourPOA.set_servant((Servant)theButler);
            Object obj = ourPOA.create_reference_with_id("RecoveryManager".getBytes(), RecoveryCoordinatorHelper.id());
            String reference = _orb.orb().object_to_string(obj);
            try {
                OutputObjectState oState = new OutputObjectState();
                oState.packString(reference);
                ParticipantStore txLog = StoreManager.getCommunicationStore();
                txLog.write_committed(new Uid(uid4Recovery), JacOrbRCServiceInit.type(), oState);
            }
            catch (SecurityException sex) {
                jtsLogger.i18NLogger.fatal_orbspecific_jacorb_recoverycoordinators_JacOrbRCServiceInit_5();
            }
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug("JacOrbRCServiceInit - set default servant and activated");
            }
            _oa.rootPoa().the_POAManager().activate();
            _runOA = new ORBRunner();
            return true;
        }
        catch (Exception ex) {
            jtsLogger.i18NLogger.warn_orbspecific_jacorb_recoverycoordinators_JacOrbRCServiceInit_3(ex);
            return false;
        }
    }

    public static void shutdownRCService() {
        _poa = null;
    }

    public static String type() {
        return "/RecoveryCoordinator";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForRunningORBRunner() {
        java.lang.Object object = orbRunnerLock;
        synchronized (object) {
            if (_runOA != null) {
                try {
                    orbRunnerLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void orbRunnerCompleted() {
        java.lang.Object object = orbRunnerLock;
        synchronized (object) {
            _runOA = null;
            orbRunnerLock.notify();
        }
    }
}

