/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.orbspecific.javaidl.recoverycoordinators;

import com.arjuna.ats.internal.jts.orbspecific.javaidl.recoverycoordinators.JavaIdlRCServiceInit;
import com.arjuna.ats.jts.logging.jtsLogger;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.ForwardRequest;

public class ClientForwardInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private RecoveryCoordinator reco = null;
    private boolean first_loop = false;
    private boolean in_loop = false;
    private ORB _ourOrb = null;
    ServiceContext RCctx = null;
    int RecoveryContextId = 100001;
    byte[] RCobjectId;
    private Current piCurrent;
    private int IndicatorSlotId = -1;

    public ClientForwardInterceptor(ORB orb, Current _piCurrent, int _IndicatorSlotId) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("Client Interceptor for RecoveryCoordinators created");
        }
        this.piCurrent = _piCurrent;
        this.IndicatorSlotId = _IndicatorSlotId;
        java.lang.Object obj = null;
        this._ourOrb = orb;
    }

    public String name() {
        return "arjuna.ClientForwardInterceptor";
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        String objectIdString = null;
        try {
            Any indicator;
            this.RCobjectId = JavaIdlRCServiceInit._poa.reference_to_id(ri.effective_target());
            objectIdString = new String(this.RCobjectId);
            if (JavaIdlRCServiceInit.RC_ID.equals(objectIdString) && (indicator = ri.get_slot(this.IndicatorSlotId)).type().kind().equals(TCKind.tk_null)) {
                ri.add_request_service_context(this.RCctx, false);
            }
        }
        catch (Exception ex) {
            jtsLogger.i18NLogger.warn_orbspecific_jacorb_recoverycoordinators_ClientForwardInterceptor_4(ex);
        }
        if (!this.in_loop) {
            this.in_loop = true;
            if (JavaIdlRCServiceInit.RC_ID.equals(objectIdString)) {
                if (ri.effective_target()._is_a(RecoveryCoordinatorHelper.id())) {
                    this.RCobjectId = this.extractObjectId(objectIdString).getBytes();
                    this.RCctx = new ServiceContext(this.RecoveryContextId, this.RCobjectId);
                    this.in_loop = false;
                    throw new ForwardRequest((Object)this.reco);
                }
                this.in_loop = false;
            }
            this.in_loop = false;
        }
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
    }

    private String extractObjectId(String encodedRCData) {
        boolean ok;
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("RecoveryCoordinatorId(" + encodedRCData + ")");
        }
        String ObjectId2SvcCtx = null;
        int delimiter = 35;
        boolean bl = ok = encodedRCData != null;
        if (ok) {
            int index1 = encodedRCData.indexOf(delimiter);
            boolean index2 = false;
            if (index1 != -1) {
                ObjectId2SvcCtx = encodedRCData.substring(0, index1);
            } else {
                ok = false;
            }
            if (ok) {
                try {
                    String RCDefaultObjectReference = encodedRCData.substring(index1 + 1);
                    Object obj = this._ourOrb.string_to_object(RCDefaultObjectReference);
                    this.reco = RecoveryCoordinatorHelper.narrow(obj);
                }
                catch (Exception e) {
                    jtsLogger.i18NLogger.warn_orbspecific_jacorb_recoverycoordinators_ClientForwardInterceptor_2(e);
                }
            }
        }
        return ObjectId2SvcCtx;
    }
}

