/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.orbspecific.javaidl.recoverycoordinators;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.objectstore.ParticipantStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.orbspecific.javaidl.recoverycoordinators.JavaIdlRCServiceInit;
import com.arjuna.ats.internal.jts.orbspecific.javaidl.recoverycoordinators.RecoverIOR;
import com.arjuna.ats.internal.jts.orbspecific.recovery.recoverycoordinators.GenericRecoveryCoordinator;
import com.arjuna.ats.internal.jts.recovery.recoverycoordinators.RcvCoManager;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.io.FileNotFoundException;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;

public class JavaIdlRCManager
implements RcvCoManager {
    private static final String rcvcoRepositoryId = RecoveryCoordinatorHelper.id();
    protected static String ref_ReCoo = null;
    private static boolean _runWithoutDaemon = false;
    private static boolean _initialised = false;

    @Override
    public RecoveryCoordinator makeRC(Uid RCUid, Uid tranUid, Uid processUid, boolean isServerTransaction) {
        this.initialise();
        RecoveryCoordinator rc = null;
        try {
            String rcObjectId = GenericRecoveryCoordinator.makeId(RCUid, tranUid, processUid, isServerTransaction);
            if (ref_ReCoo != null) {
                String new_ior = RecoverIOR.getIORFromString(ORBManager.getORB().orb(), ref_ReCoo, rcObjectId);
                Object rcAsObject = ORBManager.getORB().orb().string_to_object(new_ior);
                rc = RecoveryCoordinatorHelper.narrow(rcAsObject);
                if (jtsLogger.logger.isDebugEnabled()) {
                    jtsLogger.logger.debug("JavaIdlRCManager: Created reference for tran " + tranUid + " = " + rc);
                }
            } else {
                if (_runWithoutDaemon) {
                    throw new NO_IMPLEMENT();
                }
                jtsLogger.i18NLogger.warn_orbspecific_jacorb_recoverycoordinators_JacOrbRCManager_3();
                rc = null;
            }
        }
        catch (Exception ex) {
            jtsLogger.i18NLogger.warn_orbspecific_jacorb_recoverycoordinators_JacOrbRCManager_2(ex);
        }
        return rc;
    }

    @Override
    public void destroy(RecoveryCoordinator rc) throws SystemException {
    }

    @Override
    public void destroyAll(java.lang.Object[] params) throws SystemException {
    }

    private synchronized void initialise() {
        if (!_initialised) {
            _initialised = true;
            if (!_runWithoutDaemon) {
                try {
                    ParticipantStore participantStore = StoreManager.getCommunicationStore();
                    InputObjectState iState = participantStore.read_committed(new Uid(JavaIdlRCServiceInit.uid4Recovery), JavaIdlRCServiceInit.type());
                    if (iState != null) {
                        ref_ReCoo = iState.unpackString();
                    } else {
                        jtsLogger.i18NLogger.warn_orbspecific_jacorb_recoverycoordinators_JacOrbRCManager_4();
                    }
                }
                catch (FileNotFoundException ex) {
                    jtsLogger.i18NLogger.warn_orbspecific_jacorb_recoverycoordinators_JacOrbRCManager_4();
                }
                catch (Exception ex) {
                    jtsLogger.i18NLogger.warn_orbspecific_jacorb_recoverycoordinators_JacOrbRCManager_5(ex);
                }
            }
        }
    }

    static {
        String env = System.getProperty("com.arjuna.ats.internal.jts.orbspecific.javaidl.recoverycoordinators.noDaemon");
        String env2 = System.getProperty("com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators.noDaemon");
        _runWithoutDaemon = env != null && env.equals("YES") || env2 != null && env2.equals("YES");
    }
}

