/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.orbspecific.recovery.recoverycoordinators;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.jts.logging.jtsLogger;

public class RecoveryCoordinatorId {
    Uid _RCUid;
    Uid _actionUid;
    Uid _originalProcessUid;
    boolean _isServerTransaction;
    private static final char _ObjKeyDelimiter = '*';

    RecoveryCoordinatorId(Uid RCUid, Uid actionUid, Uid processUid, boolean isServerTransaction) {
        this._RCUid = RCUid;
        this._actionUid = actionUid;
        this._originalProcessUid = processUid;
        this._isServerTransaction = isServerTransaction;
    }

    String makeId() {
        String rcObjectKey = null;
        try {
            StringBuffer stringBuf = new StringBuffer();
            stringBuf.append(this._RCUid.toString());
            stringBuf.append('*');
            stringBuf.append(this._actionUid.toString());
            stringBuf.append('*');
            stringBuf.append(this._originalProcessUid.toString());
            stringBuf.append('*');
            stringBuf.append(this._isServerTransaction);
            rcObjectKey = stringBuf.toString();
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug("RecoveryCoordinatorId: created RCkey " + rcObjectKey);
            }
        }
        catch (Exception e) {
            jtsLogger.i18NLogger.warn_recovery_recoverycoordinators_RecoveryCoordinatorId_2(e);
        }
        return rcObjectKey;
    }

    public static RecoveryCoordinatorId reconstruct(String encodedRCData) {
        boolean ok;
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("RecoveryCoordinatorId(" + encodedRCData + ")");
        }
        Uid RCUid = null;
        Uid actionUid = null;
        Uid originalProcessUid = null;
        boolean isServerTransaction = false;
        boolean bl = ok = encodedRCData != null;
        if (ok) {
            int index1 = encodedRCData.indexOf(42);
            int index2 = 0;
            if (index1 != -1) {
                String stringifiedRCUid = encodedRCData.substring(0, index1);
                RCUid = new Uid(stringifiedRCUid);
            } else {
                ok = false;
            }
            if (ok) {
                index2 = encodedRCData.indexOf(42, index1 + 1);
                if (index2 != -1) {
                    String stringifiedTranUid = encodedRCData.substring(index1 + 1, index2);
                    actionUid = new Uid(stringifiedTranUid);
                    index1 = index2;
                } else {
                    ok = false;
                }
            }
            if (ok) {
                index2 = encodedRCData.indexOf(42, index1 + 1);
                if (index2 != -1) {
                    String stringifiedProcessUid = encodedRCData.substring(index1 + 1, index2);
                    originalProcessUid = new Uid(stringifiedProcessUid);
                    index1 = index2;
                } else {
                    ok = false;
                }
            }
            if (ok) {
                String stringifiedIsServerTransaction = encodedRCData.substring(index1 + 1);
                isServerTransaction = Boolean.valueOf(stringifiedIsServerTransaction);
            }
        }
        if (ok) {
            return new RecoveryCoordinatorId(RCUid, actionUid, originalProcessUid, isServerTransaction);
        }
        jtsLogger.i18NLogger.warn_recovery_recoverycoordinators_RecoveryCoordinatorId_3(encodedRCData);
        return null;
    }

    public String toString() {
        return "(" + this._RCUid + ", " + this._actionUid + ", " + this._originalProcessUid + (this._isServerTransaction ? ", interposed-tx" : ", root-tx") + ")";
    }
}

