/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.transactions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jts.recovery.transactions.TransactionCache;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;

public class CachedRecoveredTransaction {
    private Uid _theTransactionUid = null;
    private String _theTransactionType = null;

    public CachedRecoveredTransaction(Uid actionUid, String theType) {
        this._theTransactionUid = new Uid(actionUid);
        this._theTransactionType = theType;
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("CachedRecoveredTransaction created [" + this._theTransactionUid + ", " + this._theTransactionType + "]");
        }
    }

    public Uid getTransactionUid() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("CachedRecoveredTransaction.getTransactionUid() =" + this._theTransactionUid);
        }
        return this._theTransactionUid;
    }

    public synchronized Status get_status() throws SystemException {
        Status theStatus = TransactionCache.get_status(this._theTransactionUid, this._theTransactionType);
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("CachedRecoveredTransaction.get_status [" + this._theTransactionUid + ", " + this._theTransactionType + "] = " + Utility.stringStatus(theStatus));
        }
        return theStatus;
    }

    boolean originalBusy() {
        Status originalStatus = this.getOriginalStatus();
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("CachedRecoveredTransaction.originalBusy - told status is " + Utility.stringStatus(originalStatus));
        }
        switch (originalStatus.value()) {
            case 9: {
                return false;
            }
            case 0: 
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        return true;
    }

    Status getOriginalStatus() {
        return TransactionCache.getOriginalStatus(this._theTransactionUid, this._theTransactionType);
    }

    public int getRecoveryStatus() {
        return TransactionCache.getRecoveryStatus(this._theTransactionUid, this._theTransactionType);
    }

    public void addResourceRecord(Uid rcUid, Resource r) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("CachedRecoveredTransaction.addResourceRecord [" + this._theTransactionUid + ", " + this._theTransactionType + "]" + "(" + rcUid + ")");
        }
        TransactionCache.addResourceRecord(this._theTransactionUid, this._theTransactionType, rcUid, r);
    }

    public void replayPhase2() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("CachedRecoveredTransaction.replayPhase2 [" + this._theTransactionUid + ", " + this._theTransactionType + "]");
        }
        TransactionCache.replayPhase2(this._theTransactionUid, this._theTransactionType);
    }
}

