/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.transactions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jts.recovery.transactions.CachedRecoveredTransaction;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CosTransactions.Status;

public abstract class TransactionRecoveryModule {
    protected String _transactionType = null;
    protected static RecoveryStore _recoveryStore = null;
    protected Vector _transactionUidVector;

    public TransactionRecoveryModule() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("TransactionRecoveryModule created");
        }
        if (_recoveryStore == null) {
            _recoveryStore = StoreManager.getRecoveryStore();
        }
    }

    protected void periodicWorkFirstPass() {
        jtsLogger.i18NLogger.info_recovery_transactions_TransactionRecoveryModule_11();
        if (this._transactionType == null) {
            jtsLogger.i18NLogger.warn_recovery_transactions_TransactionRecoveryModule_2();
            return;
        }
        this._transactionUidVector = new Vector();
        InputObjectState uids = new InputObjectState();
        boolean anyTransactions = false;
        try {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug("TransactionRecoveryModule: scanning for " + this._transactionType);
            }
            anyTransactions = _recoveryStore.allObjUids(this._transactionType, uids);
        }
        catch (ObjectStoreException e1) {
            jtsLogger.i18NLogger.warn_recovery_transactions_TransactionRecoveryModule_4(e1);
        }
        if (anyTransactions) {
            Uid theUid = null;
            boolean moreUids = true;
            while (moreUids) {
                try {
                    theUid = UidHelper.unpackFrom(uids);
                    if (theUid.equals(Uid.nullUid())) {
                        moreUids = false;
                        continue;
                    }
                    Uid newUid = new Uid(theUid);
                    if (jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug("found transaction " + newUid);
                    }
                    this._transactionUidVector.addElement(newUid);
                }
                catch (Exception e2) {
                    moreUids = false;
                }
            }
        }
    }

    protected void periodicWorkSecondPass() {
        jtsLogger.i18NLogger.info_recovery_transactions_TransactionRecoveryModule_12();
        Enumeration transactionUidEnum = this._transactionUidVector.elements();
        while (transactionUidEnum.hasMoreElements()) {
            Uid currentUid = (Uid)transactionUidEnum.nextElement();
            try {
                if (_recoveryStore.currentState(currentUid, this._transactionType) != -1) {
                    jtsLogger.i18NLogger.info_recovery_transactions_TransactionRecoveryModule_6(currentUid);
                    this.recoverTransaction(currentUid);
                    continue;
                }
                if (!jtsLogger.logger.isDebugEnabled()) continue;
                jtsLogger.logger.debug("Transaction " + currentUid + " in state unknown (?)");
            }
            catch (ObjectStoreException e4) {
                if (!jtsLogger.logger.isDebugEnabled()) continue;
                jtsLogger.logger.debug("Transaction " + currentUid + " is not in object store - assumed completed");
            }
        }
    }

    protected void initialise() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("TransactionRecoveryModule.initialise()");
        }
    }

    private void recoverTransaction(Uid tranUid) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("TransactionRecoveryModule.recoverTransaction(" + tranUid + ")");
        }
        Status currentStatus = Status.StatusUnknown;
        CachedRecoveredTransaction cachedRecoveredTransaction = new CachedRecoveredTransaction(tranUid, this._transactionType);
        currentStatus = cachedRecoveredTransaction.get_status();
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("Activated transaction " + tranUid + " status = " + Utility.stringStatus(currentStatus));
        }
        if (cachedRecoveredTransaction.originalBusy()) {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug("Transaction " + tranUid + " still busy");
            }
            return;
        }
        cachedRecoveredTransaction.replayPhase2();
        cachedRecoveredTransaction = null;
    }
}

