/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.txoj.recovery;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionStatus;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.ParticipantStore;
import com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.Header;
import com.arjuna.ats.txoj.logging.txojLogger;

public class RecoveredTransactionalObject
extends StateManager {
    private Uid _ourUid;
    private Uid _owningTransactionUid;
    private Uid _originalProcessUid;
    private ParticipantStore _participantStore;
    private String _type;
    private TransactionStatusConnectionManager _transactionStatusConnectionMgr;

    protected RecoveredTransactionalObject(Uid objectUid, String originalType, ParticipantStore participantStore) {
        this._ourUid = objectUid;
        this._type = originalType;
        this._participantStore = participantStore;
        this._transactionStatusConnectionMgr = new TransactionStatusConnectionManager();
        if (txojLogger.logger.isDebugEnabled()) {
            txojLogger.logger.debug("RecoveredTransactionalObject created for " + this._ourUid);
        }
    }

    protected final void replayPhase2() {
        if (this.findHoldingTransaction()) {
            if (txojLogger.logger.isDebugEnabled()) {
                txojLogger.logger.debug("TO held by transaction " + this._owningTransactionUid);
            }
            int tranStatus = this._transactionStatusConnectionMgr.getTransactionStatus(this._owningTransactionUid);
            if (txojLogger.logger.isDebugEnabled()) {
                txojLogger.logger.debug("RecoveredTransactionalObject - transaction status " + ActionStatus.stringForm(tranStatus));
            }
            boolean inactive = false;
            if (tranStatus == 9) {
                if (txojLogger.logger.isDebugEnabled()) {
                    txojLogger.logger.debug("transaction Status from original application " + Integer.toString(tranStatus) + " and inactive: " + inactive);
                }
                inactive = true;
            }
            if (tranStatus == 4 || inactive) {
                this.rollback();
            } else {
                this.commit();
            }
        } else if (txojLogger.logger.isDebugEnabled()) {
            txojLogger.logger.debug("RecoveredTransactionalObject.replayPhase2 - cannot find/no holding transaction");
        }
    }

    private final boolean findHoldingTransaction() {
        InputObjectState uncommittedState = null;
        this._originalProcessUid = new Uid(Uid.nullUid());
        try {
            uncommittedState = this._participantStore.read_uncommitted(this._ourUid, this._type);
        }
        catch (ObjectStoreException e) {
            txojLogger.i18NLogger.warn_recovery_RecoveredTransactionalObject_6(e);
            return false;
        }
        this._originalProcessUid = null;
        this._owningTransactionUid = null;
        try {
            Header hdr = new Header();
            this.unpackHeader(uncommittedState, hdr);
            this._originalProcessUid = hdr.getProcessId();
            this._owningTransactionUid = hdr.getTxId();
            if (txojLogger.logger.isDebugEnabled()) {
                txojLogger.logger.debug("RecoveredTransactionalObject::findHoldingTransaction - uid is " + this._owningTransactionUid);
            }
            return this._owningTransactionUid.notEquals(Uid.nullUid());
        }
        catch (Exception e) {
            txojLogger.i18NLogger.warn_recovery_RecoveredTransactionalObject_8(e);
            return false;
        }
    }

    private final void rollback() {
        try {
            this._participantStore.remove_uncommitted(this._ourUid, this._type);
        }
        catch (ObjectStoreException e) {
            txojLogger.i18NLogger.warn_recovery_RecoveredTransactionalObject_9(this._ourUid, e);
        }
    }

    private final void commit() {
        try {
            this._participantStore.commit_state(this._ourUid, this._type);
        }
        catch (ObjectStoreException e) {
            txojLogger.i18NLogger.warn_recovery_RecoveredTransactionalObject_10(this._ourUid, e);
        }
    }
}

