/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jts;

import com.arjuna.ArjunaOTS.InterpositionFailed;
import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.internal.jts.orbspecific.ControlImple;
import com.arjuna.ats.internal.jts.orbspecific.CurrentImple;
import com.arjuna.ats.internal.jts.orbspecific.TransactionFactoryImple;
import com.arjuna.ats.jts.logging.jtsLogger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.PropagationContext;

public class ExplicitInterposition {
    private boolean _remember;
    private boolean _inUse;
    private ControlWrapper _oldControl;

    public ExplicitInterposition() {
        this(true);
    }

    public ExplicitInterposition(boolean remember) {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace("ExplicitInterposition::ExplicitInterposition ( " + remember + " )");
        }
        this._remember = remember;
        this._inUse = false;
        this._oldControl = null;
    }

    public ExplicitInterposition(Control action, boolean remember) throws InterpositionFailed, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace("ExplicitInterposition::ExplicitInterposition ( Control action, " + remember + " )");
        }
        this._remember = remember;
        this._inUse = false;
        this._oldControl = null;
        this.registerTransaction(action);
    }

    public ExplicitInterposition(PropagationContext ctx, boolean remember) throws InterpositionFailed, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace("ExplicitInterposition::ExplicitInterposition ( PropagationContext ctx, " + remember + " )");
        }
        this._remember = remember;
        this._inUse = false;
        this._oldControl = null;
        this.registerTransaction(ctx);
    }

    public void finalize() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace("ExplicitInterposition.finalize ()");
        }
        if (this._inUse) {
            try {
                this.unregisterTransaction();
            }
            catch (Exception e) {
                jtsLogger.i18NLogger.warn_exunregfail("ExplicitInterposition.finalize");
            }
        }
    }

    public final synchronized void registerTransaction(Control action) throws InterpositionFailed, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace("ExplicitInterposition::registerTransaction ( Control action )");
        }
        if (this._inUse) {
            jtsLogger.i18NLogger.warn_excalledagain("ExplicitInterposition.unregisterTransaction");
            throw new InterpositionFailed();
        }
        boolean registerNull = false;
        if (action != null) {
            try {
                Coordinator coord = action.get_coordinator();
                if (coord != null) {
                    PropagationContext ctx = coord.get_txcontext();
                    if (ctx != null) {
                        try {
                            this.registerTransaction(ctx);
                            ctx = null;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ctx = null;
                            throw new InterpositionFailed(e.toString());
                        }
                    } else {
                        registerNull = true;
                    }
                    coord = null;
                }
                registerNull = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InterpositionFailed(e.toString());
            }
        } else {
            this._inUse = true;
            registerNull = true;
        }
        if (registerNull) {
            try {
                OTSImpleManager.current().resume(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InterpositionFailed(e.toString());
            }
        }
    }

    public synchronized void unregisterTransaction() throws SystemException {
        block8: {
            if (jtsLogger.logger.isTraceEnabled()) {
                jtsLogger.logger.trace("ExplicitInterposition::unregisterTransaction ()");
            }
            if (!this._inUse) {
                throw new INVALID_TRANSACTION(60007, CompletionStatus.COMPLETED_NO);
            }
            try {
                Control control = OTSImpleManager.current().suspend();
                control = null;
                if (!this._remember || this._oldControl == null) break block8;
                try {
                    OTSImpleManager.current().resumeWrapper(this._oldControl);
                    this._oldControl = null;
                }
                catch (Exception exp) {
                    throw new UNKNOWN(exp.toString());
                }
            }
            catch (UNKNOWN exp) {
                throw exp;
            }
            catch (SystemException ex) {
                this._inUse = false;
                throw ex;
            }
            catch (Exception e) {
                this._inUse = false;
                throw new UNKNOWN(e.toString());
            }
        }
        this._inUse = false;
    }

    private final synchronized void registerTransaction(PropagationContext ctx) throws InterpositionFailed, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace("ExplicitInterposition::registerTransaction ( PropagationContext ctx )");
        }
        if (this._inUse) {
            jtsLogger.i18NLogger.warn_excalledagain("ExplicitInterposition.registerTransaction");
            throw new InterpositionFailed();
        }
        if (ctx == null || ctx.current.coord == null) {
            throw new INVALID_TRANSACTION(60007, CompletionStatus.COMPLETED_NO);
        }
        this._inUse = true;
        TransactionFactoryImple _localFactory = OTSImpleManager.factory();
        try {
            ControlImple cont = _localFactory.recreateLocal(ctx);
            CurrentImple current = OTSImpleManager.current();
            if (this._remember) {
                try {
                    this._oldControl = current.suspendWrapper();
                }
                catch (Exception e) {
                    throw new InterpositionFailed();
                }
            }
            current.resumeImple(cont);
            cont = null;
        }
        catch (InterpositionFailed ex) {
            throw ex;
        }
        catch (Exception e) {
            jtsLogger.i18NLogger.warn_eicaughtexception("ExplicitInterposition.registerTransaction(PropagationContext)", e);
            throw new InterpositionFailed();
        }
    }
}

