/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jts.orbspecific.jacorb.interceptors.interposition;

import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.internal.arjuna.thread.ThreadActionData;
import com.arjuna.ats.jts.OTSManager;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.orbspecific.jacorb.interceptors.interposition.InterpositionClientRequestInterceptorImpl;
import com.arjuna.ats.jts.orbspecific.jacorb.interceptors.interposition.InterpositionServerRequestInterceptorImpl;
import com.arjuna.ats.jts.orbspecific.jacorb.interceptors.interposition.InterpositionThreadSetup;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class InterpositionORBInitializerImpl
extends LocalObject
implements ORBInitializer {
    public InterpositionORBInitializerImpl() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace("InterpositionORBInitializerImpl ()");
        }
        ThreadActionData.addSetup(new InterpositionThreadSetup());
    }

    public void pre_init(ORBInitInfo init_info) {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace("InterpositionORBInitializer.pre_init ()");
        }
        int localSlot = init_info.allocate_slot_id();
        int receivedSlot = init_info.allocate_slot_id();
        OTSManager.setLocalSlotId(localSlot);
        OTSManager.setReceivedSlotId(receivedSlot);
        Codec cdr_codec = null;
        try {
            if (jtsLogger.logger.isTraceEnabled()) {
                jtsLogger.logger.trace("InterpositionORBInitializerImpl - getting reference to ENCODING_CDR_ENCAPS codec");
            }
            Encoding cdr_encoding = new Encoding(0, 1, 0);
            cdr_codec = init_info.codec_factory().create_codec(cdr_encoding);
        }
        catch (UnknownEncoding ex) {
            jtsLogger.i18NLogger.warn_orbspecific_jacorb_interceptors_interposition_codecerror("InterpositionORBInitializerImpl", "ENCODING_CDR_ENCAPS", ex);
            throw new FatalError(jtsLogger.i18NLogger.get_orbspecific_jacorb_interceptors_interposition_codeccreate(), ex);
        }
        try {
            if (jtsLogger.logger.isTraceEnabled()) {
                jtsLogger.logger.trace("InterpositionORBInitializerImpl - registering ClientRequestInterceptor");
            }
            InterpositionClientRequestInterceptorImpl client_interceptor = new InterpositionClientRequestInterceptorImpl(localSlot, cdr_codec);
            init_info.add_client_request_interceptor((ClientRequestInterceptor)client_interceptor);
        }
        catch (DuplicateName ex) {
            jtsLogger.i18NLogger.warn_orbspecific_jacorb_interceptors_interposition_duplicatename("InterpositionORBInitializerImpl", "ClientRequestInterceptor", ex);
            throw new FatalError(jtsLogger.i18NLogger.get_orbspecific_jacorb_interceptors_interposition_cie(), ex);
        }
        try {
            if (jtsLogger.logger.isTraceEnabled()) {
                jtsLogger.logger.trace("InterpositionORBInitializerImpl - registering ServerRequestInterceptor");
            }
            InterpositionServerRequestInterceptorImpl server_interceptor = new InterpositionServerRequestInterceptorImpl(receivedSlot, cdr_codec);
            init_info.add_server_request_interceptor((ServerRequestInterceptor)server_interceptor);
        }
        catch (DuplicateName ex) {
            jtsLogger.i18NLogger.warn_orbspecific_jacorb_interceptors_interposition_duplicatename("InterpositionORBInitializerImpl", "ServerRequestInterceptor", ex);
            throw new FatalError(jtsLogger.i18NLogger.get_orbspecific_jacorb_interceptors_interposition_sie(), ex);
        }
    }

    public void post_init(ORBInitInfo init_info) {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace("InterpositionORBInitializerImpl.post_init ()");
        }
    }
}

