/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.orbportability.oa.core;

import com.arjuna.orbportability.common.opPropertyManager;
import com.arjuna.orbportability.logging.opLogger;
import com.arjuna.orbportability.oa.core.POAImple;
import com.arjuna.orbportability.orb.core.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;

public class OA {
    private final ORB _theORB;
    private final POAImple _theOA;

    public OA(ORB theORB) {
        this._theORB = theORB;
        try {
            Class<? extends POAImple> clazz = opPropertyManager.getOrbPortabilityEnvironmentBean().getPoaImpleClass();
            if (opLogger.logger.isTraceEnabled()) {
                opLogger.logger.trace("OA.initialise() - using OA Implementation " + clazz.getCanonicalName());
            }
            this._theOA = clazz.newInstance();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public boolean initialised() {
        return this._theOA.initialised();
    }

    public void init() throws InvalidName, AdapterInactive, SystemException {
        this._theOA.init(this._theORB);
    }

    public void createPOA(String adapterName, Policy[] policies) throws AdapterAlreadyExists, InvalidPolicy, AdapterInactive, SystemException {
        this._theOA.createPOA(adapterName, policies);
    }

    public void destroyRootPOA() throws SystemException {
        this._theOA.destroyRootPOA();
    }

    public void destroyPOA(String adapterName) throws SystemException {
        this._theOA.destroyPOA(adapterName);
    }

    public POA rootPoa() throws SystemException {
        return this._theOA.rootPoa();
    }

    public void rootPoa(POA thePOA) throws SystemException {
        this._theOA.rootPoa(thePOA);
    }

    public POA poa(String adapterName) throws SystemException {
        return this._theOA.poa(adapterName);
    }

    public void poa(String adapterName, POA thePOA) throws SystemException {
        this._theOA.poa(adapterName, thePOA);
    }

    public void run(String name) throws SystemException {
        this._theOA.run(this._theORB, name);
    }

    public void run() throws SystemException {
        this._theOA.run(this._theORB);
    }
}

