/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.cursor.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.hornetq.api.core.Pair;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.paging.cursor.PageSubscriptionCounter;
import org.hornetq.core.paging.impl.Page;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionOperation;
import org.hornetq.core.transaction.TransactionOperationAbstract;
import org.hornetq.core.transaction.impl.TransactionImpl;

public class PageSubscriptionCounterImpl
implements PageSubscriptionCounter {
    private static final boolean isTrace = HornetQServerLogger.LOGGER.isTraceEnabled();
    private static final int FLUSH_COUNTER = 1000;
    private final long subscriptionID;
    private long recordID = -1L;
    private boolean persistent;
    private final PageSubscription subscription;
    private final StorageManager storage;
    private final Executor executor;
    private final AtomicLong value = new AtomicLong(0L);
    private final AtomicLong pendingValue = new AtomicLong(0L);
    private final LinkedList<Long> incrementRecords = new LinkedList();
    private final Map<Long, Pair<Long, AtomicInteger>> pendingCounters = new HashMap<Long, Pair<Long, AtomicInteger>>();
    private LinkedList<Pair<Long, Integer>> loadList;
    private final Runnable cleanupCheck = new Runnable(){

        @Override
        public void run() {
            PageSubscriptionCounterImpl.this.cleanup();
        }
    };

    public PageSubscriptionCounterImpl(StorageManager storage, PageSubscription subscription, Executor executor, boolean persistent, long subscriptionID) {
        this.subscriptionID = subscriptionID;
        this.executor = executor;
        this.storage = storage;
        this.persistent = persistent;
        this.subscription = subscription;
    }

    @Override
    public long getValue() {
        return this.value.get() + this.pendingValue.get();
    }

    @Override
    public synchronized void pendingCounter(Page page, int increment) throws Exception {
        if (!this.persistent) {
            return;
        }
        Pair<Long, AtomicInteger> pendingInfo = this.pendingCounters.get(page.getPageId());
        if (pendingInfo == null) {
            long id = this.storage.storePendingCounter(this.subscriptionID, page.getPageId(), increment);
            pendingInfo = new Pair<Long, AtomicInteger>(id, new AtomicInteger(1));
            this.pendingCounters.put(Long.valueOf(page.getPageId()), pendingInfo);
        } else {
            pendingInfo.getB().addAndGet(increment);
        }
        this.pendingValue.addAndGet(increment);
        page.addPendingCounter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupNonTXCounters(long pageID) throws Exception {
        Pair<Long, AtomicInteger> pendingInfo;
        PageSubscriptionCounterImpl pageSubscriptionCounterImpl = this;
        synchronized (pageSubscriptionCounterImpl) {
            pendingInfo = this.pendingCounters.remove(pageID);
        }
        if (pendingInfo != null) {
            final AtomicInteger valueCleaned = pendingInfo.getB();
            TransactionImpl tx2 = new TransactionImpl(this.storage);
            this.storage.deletePendingPageCounter(tx2.getID(), pendingInfo.getA());
            this.increment(tx2, valueCleaned.get());
            tx2.addOperation(new TransactionOperationAbstract(){

                @Override
                public void afterCommit(Transaction tx2) {
                    PageSubscriptionCounterImpl.this.pendingValue.addAndGet(-valueCleaned.get());
                }
            });
            tx2.commit();
        }
    }

    @Override
    public void increment(Transaction tx2, int add) throws Exception {
        if (tx2 == null) {
            if (this.persistent) {
                long id = this.storage.storePageCounterInc(this.subscriptionID, add);
                this.incrementProcessed(id, add);
            } else {
                this.incrementProcessed(-1L, add);
            }
        } else if (this.persistent) {
            tx2.setContainsPersistent();
            long id = this.storage.storePageCounterInc(tx2.getID(), this.subscriptionID, add);
            this.applyIncrementOnTX(tx2, id, add);
        } else {
            this.applyIncrementOnTX(tx2, -1L, add);
        }
    }

    @Override
    public void applyIncrementOnTX(Transaction tx2, long recordID1, int add) {
        CounterOperations oper = (CounterOperations)tx2.getProperty(3);
        if (oper == null) {
            oper = new CounterOperations();
            tx2.putProperty(3, oper);
            tx2.addOperation(oper);
        }
        oper.operations.add(new ItemOper(this, recordID1, add));
    }

    @Override
    public synchronized void loadValue(long recordID1, long value1) {
        if (this.subscription != null) {
            this.subscription.notEmpty();
        }
        this.value.set(value1);
        this.recordID = recordID1;
    }

    public synchronized void incrementProcessed(long id, int add) {
        this.addInc(id, add);
        if (this.incrementRecords.size() > 1000) {
            this.executor.execute(this.cleanupCheck);
        }
    }

    @Override
    public void delete() throws Exception {
        TransactionImpl tx2 = new TransactionImpl(this.storage);
        this.delete(tx2);
        tx2.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Transaction tx2) throws Exception {
        this.storage.readLock();
        try {
            PageSubscriptionCounterImpl pageSubscriptionCounterImpl = this;
            synchronized (pageSubscriptionCounterImpl) {
                for (Long record : this.incrementRecords) {
                    this.storage.deleteIncrementRecord(tx2.getID(), record);
                    tx2.setContainsPersistent();
                }
                if (this.recordID >= 0L) {
                    this.storage.deletePageCounter(tx2.getID(), this.recordID);
                    tx2.setContainsPersistent();
                }
                this.recordID = -1L;
                this.value.set(0L);
                this.incrementRecords.clear();
            }
        }
        finally {
            this.storage.readUnLock();
        }
    }

    @Override
    public void loadInc(long id, int add) {
        if (this.loadList == null) {
            this.loadList = new LinkedList();
        }
        this.loadList.add(new Pair<Long, Integer>(id, add));
    }

    @Override
    public void processReload() {
        if (this.loadList != null) {
            if (this.subscription != null) {
                this.subscription.notEmpty();
            }
            for (Pair pair : this.loadList) {
                this.value.addAndGet(((Integer)pair.getB()).intValue());
                this.incrementRecords.add((Long)pair.getA());
            }
            this.loadList.clear();
            this.loadList = null;
        }
    }

    @Override
    public synchronized void addInc(long id, int variance) {
        this.value.addAndGet(variance);
        if (id >= 0L) {
            this.incrementRecords.add(id);
        }
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        ArrayList<Long> deleteList;
        long valueReplace;
        PageSubscriptionCounterImpl pageSubscriptionCounterImpl = this;
        synchronized (pageSubscriptionCounterImpl) {
            if (this.incrementRecords.size() <= 1000) {
                return;
            }
            valueReplace = this.value.get();
            deleteList = new ArrayList<Long>(this.incrementRecords.size());
            deleteList.addAll(this.incrementRecords);
            this.incrementRecords.clear();
        }
        long newRecordID = -1L;
        long txCleanup = this.storage.generateUniqueID();
        try {
            for (Long value1 : deleteList) {
                this.storage.deleteIncrementRecord(txCleanup, value1);
            }
            if (this.recordID >= 0L) {
                this.storage.deletePageCounter(txCleanup, this.recordID);
            }
            newRecordID = this.storage.storePageCounter(txCleanup, this.subscriptionID, valueReplace);
            if (isTrace) {
                HornetQServerLogger.LOGGER.trace("Replacing page-counter record = " + this.recordID + " by record = " + newRecordID + " on subscriptionID = " + this.subscriptionID + " for queue = " + this.subscription.getQueue().getName());
            }
            this.storage.commit(txCleanup);
        }
        catch (Exception e) {
            newRecordID = this.recordID;
            HornetQServerLogger.LOGGER.problemCleaningPagesubscriptionCounter(e);
            try {
                this.storage.rollback(txCleanup);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        finally {
            this.recordID = newRecordID;
        }
    }

    private static class CounterOperations
    extends TransactionOperationAbstract
    implements TransactionOperation {
        LinkedList<ItemOper> operations = new LinkedList();

        private CounterOperations() {
        }

        @Override
        public void afterCommit(Transaction tx2) {
            for (ItemOper oper : this.operations) {
                oper.counter.incrementProcessed(oper.id, oper.ammount);
            }
        }
    }

    private static class ItemOper {
        PageSubscriptionCounterImpl counter;
        long id;
        int ammount;

        public ItemOper(PageSubscriptionCounterImpl counter, long id, int add) {
            this.counter = counter;
            this.id = id;
            this.ammount = add;
        }
    }
}

