/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.postoffice.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.DuplicateIDCache;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionOperationAbstract;

public class DuplicateIDCacheImpl
implements DuplicateIDCache {
    private final Map<ByteArrayHolder, Integer> cache = new ConcurrentHashMap<ByteArrayHolder, Integer>();
    private final SimpleString address;
    private final ArrayList<Pair<ByteArrayHolder, Long>> ids;
    private int pos;
    private final int cacheSize;
    private final StorageManager storageManager;
    private final boolean persist;

    public DuplicateIDCacheImpl(SimpleString address, int size, StorageManager storageManager, boolean persist) {
        this.address = address;
        this.cacheSize = size;
        this.ids = new ArrayList(size);
        this.storageManager = storageManager;
        this.persist = persist;
    }

    @Override
    public void load(List<Pair<byte[], Long>> theIds) throws Exception {
        int count = 0;
        long txID = -1L;
        for (Pair<byte[], Long> id : theIds) {
            if (count < this.cacheSize) {
                ByteArrayHolder bah = new ByteArrayHolder(id.getA());
                Pair<ByteArrayHolder, Long> pair = new Pair<ByteArrayHolder, Long>(bah, id.getB());
                this.cache.put(bah, this.ids.size());
                this.ids.add(pair);
            } else {
                if (txID == -1L) {
                    txID = this.storageManager.generateUniqueID();
                }
                this.storageManager.deleteDuplicateIDTransactional(txID, id.getB());
            }
            ++count;
        }
        if (txID != -1L) {
            this.storageManager.commit(txID);
        }
        this.pos = this.ids.size();
        if (this.pos == this.cacheSize) {
            this.pos = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFromCache(byte[] duplicateID) throws Exception {
        ByteArrayHolder bah = new ByteArrayHolder(duplicateID);
        Integer posUsed = this.cache.remove(bah);
        if (posUsed != null) {
            DuplicateIDCacheImpl duplicateIDCacheImpl = this;
            synchronized (duplicateIDCacheImpl) {
                Pair<ByteArrayHolder, Long> id = this.ids.get(posUsed);
                if (id.getA().equals(bah)) {
                    id.setA(null);
                    this.storageManager.deleteDuplicateID(id.getB());
                    id.setB(null);
                }
            }
        }
    }

    @Override
    public boolean contains(byte[] duplID) {
        return this.cache.get(new ByteArrayHolder(duplID)) != null;
    }

    @Override
    public synchronized void addToCache(byte[] duplID, Transaction tx2) throws Exception {
        long recordID = -1L;
        if (tx2 == null) {
            if (this.persist) {
                recordID = this.storageManager.generateUniqueID();
                this.storageManager.storeDuplicateID(this.address, duplID, recordID);
            }
            this.addToCacheInMemory(duplID, recordID);
        } else {
            if (this.persist) {
                recordID = this.storageManager.generateUniqueID();
                this.storageManager.storeDuplicateIDTransactional(tx2.getID(), this.address, duplID, recordID);
                tx2.setContainsPersistent();
            }
            tx2.addOperation(new AddDuplicateIDOperation(duplID, recordID));
        }
    }

    @Override
    public void load(Transaction tx2, byte[] duplID) {
        tx2.addOperation(new AddDuplicateIDOperation(duplID, tx2.getID()));
    }

    private synchronized void addToCacheInMemory(byte[] duplID, long recordID) {
        ByteArrayHolder holder = new ByteArrayHolder(duplID);
        this.cache.put(holder, this.pos);
        if (this.pos < this.ids.size()) {
            Pair<ByteArrayHolder, Long> id = this.ids.get(this.pos);
            if (id.getA() != null) {
                this.cache.remove(id.getA());
                if (id.getB() != null) {
                    try {
                        this.storageManager.deleteDuplicateID(id.getB());
                    }
                    catch (Exception e) {
                        HornetQServerLogger.LOGGER.errorDeletingDuplicateCache(e);
                    }
                }
            }
            id.setA(holder);
            id.setB(recordID >= 0L ? Long.valueOf(recordID) : null);
            holder.pos = this.pos;
        } else {
            Pair<ByteArrayHolder, Long> id = new Pair<ByteArrayHolder, Long>(holder, recordID >= 0L ? Long.valueOf(recordID) : null);
            this.ids.add(id);
            holder.pos = this.pos;
        }
        if (this.pos++ == this.cacheSize - 1) {
            this.pos = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws Exception {
        DuplicateIDCacheImpl duplicateIDCacheImpl = this;
        synchronized (duplicateIDCacheImpl) {
            if (this.ids.size() > 0) {
                long tx2 = this.storageManager.generateUniqueID();
                for (Pair<ByteArrayHolder, Long> id : this.ids) {
                    this.storageManager.deleteDuplicateIDTransactional(tx2, id.getB());
                }
                this.storageManager.commit(tx2);
            }
            this.ids.clear();
            this.cache.clear();
            this.pos = 0;
        }
    }

    private static final class ByteArrayHolder {
        final byte[] bytes;
        int hash;
        int pos;

        ByteArrayHolder(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object other) {
            if (other instanceof ByteArrayHolder) {
                ByteArrayHolder s = (ByteArrayHolder)other;
                if (this.bytes.length != s.bytes.length) {
                    return false;
                }
                for (int i = 0; i < this.bytes.length; ++i) {
                    if (this.bytes[i] == s.bytes[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            if (this.hash == 0) {
                for (byte b : this.bytes) {
                    this.hash = 31 * this.hash + b;
                }
            }
            return this.hash;
        }
    }

    private final class AddDuplicateIDOperation
    extends TransactionOperationAbstract {
        final byte[] duplID;
        final long recordID;
        volatile boolean done;

        AddDuplicateIDOperation(byte[] duplID, long recordID) {
            this.duplID = duplID;
            this.recordID = recordID;
        }

        private void process() {
            if (!this.done) {
                DuplicateIDCacheImpl.this.addToCacheInMemory(this.duplID, this.recordID);
                this.done = true;
            }
        }

        @Override
        public void afterCommit(Transaction tx2) {
            this.process();
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return null;
        }
    }
}

