/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.impl.PagedMessageImpl;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class ReplicationPageWriteMessage
extends PacketImpl {
    private int pageNumber;
    private PagedMessage pagedMessage;

    public ReplicationPageWriteMessage() {
        super((byte)97);
    }

    public ReplicationPageWriteMessage(PagedMessage pagedMessage, int pageNumber) {
        this();
        this.pageNumber = pageNumber;
        this.pagedMessage = pagedMessage;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeInt(this.pageNumber);
        this.pagedMessage.encode(buffer);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.pageNumber = buffer.readInt();
        this.pagedMessage = new PagedMessageImpl();
        this.pagedMessage.decode(buffer);
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public PagedMessage getPagedMessage() {
        return this.pagedMessage;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.pageNumber;
        result = 31 * result + (this.pagedMessage == null ? 0 : this.pagedMessage.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplicationPageWriteMessage other = (ReplicationPageWriteMessage)obj;
        if (this.pageNumber != other.pageNumber) {
            return false;
        }
        return !(this.pagedMessage == null ? other.pagedMessage != null : !this.pagedMessage.equals(other.pagedMessage));
    }
}

