/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;

public class StompFrame {
    private static final byte[] END_OF_FRAME = new byte[]{0, 10};
    protected final String command;
    protected final Map<String, String> headers;
    private String body;
    protected byte[] bytesBody;
    protected HornetQBuffer buffer = null;
    protected int size;
    private boolean disconnect;
    private boolean isPing;

    public StompFrame(String command) {
        this(command, false);
    }

    public StompFrame(String command, boolean disconnect) {
        this.command = command;
        this.headers = new LinkedHashMap<String, String>();
        this.disconnect = disconnect;
    }

    public StompFrame(String command, Map<String, String> headers, byte[] content) {
        this.command = command;
        this.headers = headers;
        this.bytesBody = content;
    }

    public String getCommand() {
        return this.command;
    }

    public int getEncodedSize() throws Exception {
        if (this.buffer == null) {
            this.buffer = this.toHornetQBuffer();
        }
        return this.size;
    }

    public String toString() {
        return "StompFrame[command=" + this.command + ", headers=" + this.headers + ", content= " + this.body + " bytes " + Arrays.toString(this.bytesBody);
    }

    public boolean isPing() {
        return this.isPing;
    }

    public void setPing(boolean ping) {
        this.isPing = ping;
    }

    public HornetQBuffer toHornetQBuffer() throws Exception {
        if (this.buffer == null) {
            this.buffer = this.bytesBody != null ? HornetQBuffers.dynamicBuffer(this.bytesBody.length + 512) : HornetQBuffers.dynamicBuffer(512);
            if (this.isPing()) {
                this.buffer.writeByte((byte)10);
                return this.buffer;
            }
            StringBuffer head = new StringBuffer();
            head.append(this.command);
            head.append("\n");
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                head.append(header.getKey());
                head.append(":");
                head.append(header.getValue());
                head.append("\n");
            }
            head.append("\n");
            this.buffer.writeBytes(head.toString().getBytes("UTF-8"));
            if (this.bytesBody != null) {
                this.buffer.writeBytes(this.bytesBody);
            }
            this.buffer.writeBytes(END_OF_FRAME);
            this.size = this.buffer.writerIndex();
        }
        return this.buffer;
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public void addHeader(String key, String val) {
        this.headers.put(key, val);
    }

    public Map<String, String> getHeadersMap() {
        return this.headers;
    }

    public String escape(String str) {
        int len = str.length();
        char[] buffer = new char[2 * len];
        int iBuffer = 0;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                buffer[iBuffer++] = 92;
                buffer[iBuffer] = 110;
            } else if (c == '\\') {
                buffer[iBuffer++] = 92;
                buffer[iBuffer] = 92;
            } else if (c == ':') {
                buffer[iBuffer++] = 92;
                buffer[iBuffer] = 58;
            } else {
                buffer[iBuffer] = c;
            }
            ++iBuffer;
        }
        char[] total = new char[iBuffer];
        System.arraycopy(buffer, 0, total, 0, iBuffer);
        return new String(total);
    }

    public void setBody(String body) throws UnsupportedEncodingException {
        this.body = body;
        this.bytesBody = body.getBytes("UTF-8");
    }

    public boolean hasHeader(String key) {
        return this.headers.containsKey(key);
    }

    public String getBody() throws UnsupportedEncodingException {
        if (this.body == null && this.bytesBody != null) {
            this.body = new String(this.bytesBody, "UTF-8");
        }
        return this.body;
    }

    public byte[] getBodyAsBytes() throws UnsupportedEncodingException {
        return this.bytesBody;
    }

    public boolean needsDisconnect() {
        return this.disconnect;
    }

    public void setByteBody(byte[] content) {
        this.bytesBody = content;
    }

    public void setNeedsDisconnect(boolean b) {
        this.disconnect = b;
    }

    public class Header {
        public String key;
        public String val;

        public Header(String key, String val) {
            this.key = key;
            this.val = val;
        }

        public String getEscapedKey() {
            return StompFrame.this.escape(this.key);
        }

        public String getEscapedValue() {
            return StompFrame.this.escape(this.val);
        }
    }
}

