/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.client.impl.ClientMessageImpl;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.core.protocol.stomp.Stomp;
import org.hornetq.core.protocol.stomp.StompFrame;
import org.hornetq.core.server.impl.ServerMessageImpl;

public class StompUtils {
    private static final String DEFAULT_MESSAGE_PRIORITY = "4";

    public static void copyStandardHeadersFromFrameToMessage(StompFrame frame, ServerMessageImpl msg) throws Exception {
        String expiration;
        Object replyTo;
        HashMap<String, String> headers = new HashMap<String, String>(frame.getHeadersMap());
        String priority = (String)headers.remove("priority");
        if (priority != null) {
            msg.setPriority(Byte.parseByte(priority));
        } else {
            msg.setPriority(Byte.parseByte(DEFAULT_MESSAGE_PRIORITY));
        }
        String persistent = (String)headers.remove(Stomp.Headers.Send.PERSISTENT);
        if (persistent != null) {
            msg.setDurable(Boolean.parseBoolean(persistent));
        }
        msg.putObjectProperty("JMSCorrelationID", headers.remove("correlation-id"));
        msg.putObjectProperty("JMSType", headers.remove("type"));
        String groupID = (String)headers.remove("JMSXGroupID");
        if (groupID != null) {
            msg.putStringProperty(Message.HDR_GROUP_ID, SimpleString.toSimpleString(groupID));
        }
        if ((replyTo = headers.remove("reply-to")) != null) {
            msg.putStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME, SimpleString.toSimpleString((String)replyTo));
        }
        if ((expiration = (String)headers.remove("expires")) != null) {
            msg.setExpiration(Long.parseLong(expiration));
        }
        for (Map.Entry entry : headers.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            msg.putObjectProperty(name, value);
        }
    }

    public static void copyStandardHeadersFromMessageToFrame(MessageInternal message, StompFrame command, int deliveryCount) throws Exception {
        command.addHeader("message-id", String.valueOf(message.getMessageID()));
        command.addHeader("destination", message.getAddress().toString());
        if (message.getObjectProperty("JMSCorrelationID") != null) {
            command.addHeader("correlation-id", message.getObjectProperty("JMSCorrelationID").toString());
        }
        command.addHeader("expires", "" + message.getExpiration());
        command.addHeader("redelivered", String.valueOf(deliveryCount > 1));
        command.addHeader("priority", "" + message.getPriority());
        if (message.getStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME) != null) {
            command.addHeader("reply-to", message.getStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME));
        }
        command.addHeader("timestamp", "" + message.getTimestamp());
        if (message.getObjectProperty("JMSType") != null) {
            command.addHeader("type", message.getObjectProperty("JMSType").toString());
        }
        Set<SimpleString> names = message.getPropertyNames();
        for (SimpleString name : names) {
            String value = name.toString();
            if (name.equals(ClientMessageImpl.REPLYTO_HEADER_NAME) || value.equals("JMSType") || value.equals("JMSCorrelationID") || value.equals("destination")) continue;
            command.addHeader(name.toString(), message.getObjectProperty(name).toString());
        }
    }
}

